/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters;

import com.compomics.util.experiment.identification.protein_inference.PeptideMapperType;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class SequenceMatchingSettingsDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JButton annotationPreferencesHelpJButton;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox indexTypeCmb;
    private JLabel indexTypeLbl;
    private JComboBox matchingCmb;
    private JLabel matchingMethodLbl;
    private JButton okButton;
    private JPanel sequenceMatchingPanel;
    private JLabel xLbl;
    private JSpinner xSpinner;

    public SequenceMatchingSettingsDialog(Frame parentFrame, SequenceMatchingPreferences sequenceMatchingPreferences, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(sequenceMatchingPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public SequenceMatchingSettingsDialog(Dialog owner, Frame parentFrame, SequenceMatchingPreferences sequenceMatchingPreferences, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(sequenceMatchingPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.matchingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.matchingCmb.setEnabled(this.editable);
        this.indexTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.indexTypeCmb.setEnabled(this.editable);
        this.xSpinner.setEnabled(this.editable);
    }

    private void populateGUI(SequenceMatchingPreferences sequenceMatchingPreferences) {
        SequenceMatchingPreferences.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
        this.matchingCmb.setSelectedItem((Object)matchingType);
        PeptideMapperType peptideMapperType = sequenceMatchingPreferences.getPeptideMapperType();
        this.indexTypeCmb.setSelectedItem((Object)peptideMapperType);
        this.xSpinner.setValue(sequenceMatchingPreferences.getLimitX());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public SequenceMatchingPreferences getSequenceMatchingPreferences() {
        SequenceMatchingPreferences sequenceMatchingPreferences = new SequenceMatchingPreferences();
        sequenceMatchingPreferences.setPeptideMapperType((PeptideMapperType)((Object)this.indexTypeCmb.getSelectedItem()));
        sequenceMatchingPreferences.setSequenceMatchingType((SequenceMatchingPreferences.MatchingType)((Object)this.matchingCmb.getSelectedItem()));
        sequenceMatchingPreferences.setLimitX((Double)this.xSpinner.getValue());
        return sequenceMatchingPreferences;
    }

    public boolean validateInput() {
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.sequenceMatchingPanel = new JPanel();
        this.matchingMethodLbl = new JLabel();
        this.xLbl = new JLabel();
        this.matchingCmb = new JComboBox();
        this.xSpinner = new JSpinner();
        this.indexTypeCmb = new JComboBox();
        this.indexTypeLbl = new JLabel();
        this.annotationPreferencesHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sequence Matching");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SequenceMatchingSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceMatchingSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceMatchingSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.sequenceMatchingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.sequenceMatchingPanel.setOpaque(false);
        this.matchingMethodLbl.setText("Matching Method");
        this.xLbl.setText("Maximum Share of X's");
        this.matchingCmb.setModel(new DefaultComboBoxModel<SequenceMatchingPreferences.MatchingType>(SequenceMatchingPreferences.MatchingType.values()));
        this.xSpinner.setModel(new SpinnerNumberModel(0.25, 0.0, 1.0, 0.1));
        this.indexTypeCmb.setModel(new DefaultComboBoxModel<PeptideMapperType>(PeptideMapperType.values()));
        this.indexTypeLbl.setText("Index Type");
        GroupLayout sequenceMatchingPanelLayout = new GroupLayout(this.sequenceMatchingPanel);
        this.sequenceMatchingPanel.setLayout(sequenceMatchingPanelLayout);
        sequenceMatchingPanelLayout.setHorizontalGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceMatchingPanelLayout.createSequentialGroup().addContainerGap().addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchingMethodLbl).addComponent(this.xLbl).addComponent(this.indexTypeLbl)).addGap(18, 18, 18).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.indexTypeCmb, 0, -1, Short.MAX_VALUE).addComponent(this.matchingCmb, 0, -1, Short.MAX_VALUE).addComponent(this.xSpinner, -1, 295, Short.MAX_VALUE)).addContainerGap()));
        sequenceMatchingPanelLayout.setVerticalGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sequenceMatchingPanelLayout.createSequentialGroup().addContainerGap().addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indexTypeLbl).addComponent(this.indexTypeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchingMethodLbl).addComponent(this.matchingCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(sequenceMatchingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xLbl).addComponent(this.xSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.annotationPreferencesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.annotationPreferencesHelpJButton.setToolTipText("Help");
        this.annotationPreferencesHelpJButton.setBorder(null);
        this.annotationPreferencesHelpJButton.setBorderPainted(false);
        this.annotationPreferencesHelpJButton.setContentAreaFilled(false);
        this.annotationPreferencesHelpJButton.setFocusable(false);
        this.annotationPreferencesHelpJButton.setHorizontalTextPosition(0);
        this.annotationPreferencesHelpJButton.setVerticalTextPosition(3);
        this.annotationPreferencesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SequenceMatchingSettingsDialog.this.annotationPreferencesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SequenceMatchingSettingsDialog.this.annotationPreferencesHelpJButtonMouseExited(evt);
            }
        });
        this.annotationPreferencesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceMatchingSettingsDialog.this.annotationPreferencesHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.annotationPreferencesHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.sequenceMatchingPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sequenceMatchingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.annotationPreferencesHelpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void annotationPreferencesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void annotationPreferencesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void annotationPreferencesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/SequenceMatchingPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Sequence Matching - Help");
        this.setCursor(new Cursor(0));
    }
}

