/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.utils.user_choice.list_choosers;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.gui.utils.user_choice.ListChooser;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class PtmChooser
extends ListChooser {
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private ArrayList<String> ptmList = new ArrayList();

    public PtmChooser(Frame parent, ArrayList<String> ptms, String dialogTitle, String panelTitle, String instructionsLabel, boolean multipleSelection) {
        super(parent, ptms, dialogTitle, panelTitle, instructionsLabel, multipleSelection);
        this.ptmList = ptms;
        if (ptms == null || ptms.isEmpty()) {
            throw new IllegalArgumentException("No item to select.");
        }
        this.setUpTable();
        this.setVisible(true);
    }

    public PtmChooser(Frame parent, ArrayList<String> ptms, boolean multipleSelection) {
        this(parent, ptms, "PTM Selection", "Searched PTMs", "Please select a PTM from the list of possibilities.", multipleSelection);
    }

    @Override
    protected void formatTable() {
        JTable ptmTable = this.getTable();
        ptmTable.setModel(new PtmTable());
        double minMass = 0.0;
        double maxMass = 0.0;
        for (String modification : this.ptmList) {
            PTM ptm = this.ptmFactory.getPTM(modification);
            double mass = ptm.getMass();
            if (mass < minMass) {
                minMass = mass;
            }
            if (!(mass > maxMass)) continue;
            maxMass = mass;
        }
        ptmTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        ptmTable.getColumn(" ").setMaxWidth(35);
        ptmTable.getColumn("Mass").setMaxWidth(100);
        ptmTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)ptmTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        ArrayList<String> modificationTableToolTips = this.getTableTooltips();
        modificationTableToolTips.add(null);
        modificationTableToolTips.add("Modification Name");
        modificationTableToolTips.add("Modification Mass");
        modificationTableToolTips.add("Default Modification");
    }

    private class PtmTable
    extends DefaultTableModel {
        private PtmTable() {
        }

        @Override
        public int getRowCount() {
            return PtmChooser.this.ptmList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Mass";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String ptmName = (String)PtmChooser.this.ptmList.get(row);
            switch (column) {
                case 0: {
                    return PtmChooser.this.ptmFactory.getColor(ptmName);
                }
                case 1: {
                    return ptmName;
                }
                case 2: {
                    PTM ptm = PtmChooser.this.ptmFactory.getPTM(ptmName);
                    return ptm.getMass();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

