/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;

public class SimpleXmlWriter {
    protected int indentCounter = 0;
    private HashMap<Integer, String> indentMap = new HashMap();
    private String indentString = "\t";
    private BufferedWriter bw;

    public SimpleXmlWriter(BufferedWriter bw) {
        this.bw = bw;
    }

    private String getCurrentIndent() {
        return this.getIndentAtN(this.indentCounter);
    }

    private String getIndentAtN(int n) {
        if (n == 0) {
            return "";
        }
        String currentTab = this.indentMap.get(n);
        if (currentTab == null) {
            String previousIndent = this.getIndentAtN(n - 1);
            StringBuilder tabBuilder = new StringBuilder(previousIndent.length() + this.indentString.length());
            tabBuilder.append(previousIndent);
            tabBuilder.append(this.indentString);
            currentTab = tabBuilder.toString();
            this.indentMap.put(this.indentCounter, currentTab);
        }
        return currentTab;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
        this.indentMap.clear();
    }

    public void writeIndent() throws IOException {
        this.bw.write(this.getCurrentIndent());
    }

    public void write(String content) throws IOException {
        this.bw.write(content);
    }

    public void writeLine(String line) throws IOException {
        this.writeLine(line, false, false);
    }

    public void writeLineIncreasedIndent(String line) throws IOException {
        this.writeLine(line, true, false);
    }

    public void writeLineDecreasedIndent(String line) throws IOException {
        this.writeLine(line, false, true);
    }

    private void writeLine(String line, boolean increaseIndent, boolean decreaseIndent) throws IOException {
        if (increaseIndent) {
            this.increaseIndent();
        }
        if (decreaseIndent) {
            this.decreaseIndent();
        }
        this.bw.write(this.getCurrentIndent());
        this.bw.write(line);
        this.newLine();
    }

    public void newLine() throws IOException {
        this.bw.newLine();
    }

    public void increaseIndent() {
        ++this.indentCounter;
    }

    public void decreaseIndent() {
        --this.indentCounter;
    }

    public void close() throws IOException {
        this.bw.close();
    }
}

