/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import fr.profi.mzdb.io.writer.mgf.MgfField;
import fr.profi.mzdb.io.writer.mgf.MgfWriter;
import java.util.HashMap;
import java.util.Map;

public class MgfPrecursor {
    private Double precMz = null;
    private Integer charge = null;
    private Float rt = null;
    private Map<String, Object> annotations = null;

    public MgfPrecursor(double precMz, int charge) {
        this((Double)precMz, (Integer)charge, null);
    }

    public MgfPrecursor(double precMz, float rt) {
        this((Double)precMz, null, Float.valueOf(rt));
    }

    public MgfPrecursor(double precMz, int charge, float rt) {
        this((Double)precMz, (Integer)charge, Float.valueOf(rt));
    }

    public MgfPrecursor(Double precMz, Integer charge, Float rt) {
        this.precMz = precMz;
        this.charge = charge;
        this.rt = rt;
    }

    public Double getPrecMz() {
        return this.precMz;
    }

    public Integer getCharge() {
        return this.charge;
    }

    public Float getRt() {
        return this.rt;
    }

    private Map<String, Object> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, Object>();
        }
        return this.annotations;
    }

    public void addAnnotation(String key, Object value) {
        this.getAnnotations().put(key, value);
    }

    public Object getAnnotationOrElse(String key, Object defaultValue) {
        return this.annotations == null ? defaultValue : this.annotations.getOrDefault(key, defaultValue);
    }

    public boolean hasAnnotation(String key) {
        return this.annotations != null && this.annotations.containsKey(key);
    }

    public Object getAnnotation(String key) {
        return this.annotations == null ? null : this.annotations.get(key);
    }

    public StringBuilder appendToStringBuilder(StringBuilder sb) {
        sb.append((Object)MgfField.PEPMASS).append("=").append(String.format("%.4f", this.precMz)).append(MgfWriter.LINE_SPERATOR);
        if (this.charge != null) {
            sb.append((Object)MgfField.CHARGE).append("=").append(this.charge).append("+").append(MgfWriter.LINE_SPERATOR);
        }
        if (this.rt != null) {
            sb.append((Object)MgfField.RTINSECONDS).append("=").append(String.format("%.2f", this.rt)).append(MgfWriter.LINE_SPERATOR);
        }
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return this.appendToStringBuilder(sb).toString();
    }
}

