/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command;

import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mgfboost.ui.command.AbstractCommand;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.MaxQuantCreateMgfPanel;
import fr.profi.mgfboost.ui.model.MS2Collection;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.MaxQuantProcessing;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxQuantCreateMgfCommand
extends AbstractCommand<CommandArguments.MaxQuantMGFCommand> {
    private static final Logger logger = LoggerFactory.getLogger(MaxQuantCreateMgfCommand.class);

    public MaxQuantCreateMgfCommand() {
        this.command = new CommandArguments.MaxQuantMGFCommand();
    }

    @Override
    public MS2Collection execute(File ... files) throws Exception {
        logger.info("Execute command " + this.getCommandName() + " on " + Arrays.stream(files).map(f -> f.getName()).collect(Collectors.joining()));
        logger.info("Command args : " + ToStringBuilder.reflectionToString((Object)this.command));
        MaxQuantProcessing.createMgf((CommandArguments.MaxQuantMGFCommand)((CommandArguments.MaxQuantMGFCommand)this.command));
        return new MS2Collection(new File(((CommandArguments.MaxQuantMGFCommand)this.command).outputFileName), MainPanel.FileType.MGF);
    }

    @Override
    public ICommand.ExecutionMode getExecutionMode() {
        return ICommand.ExecutionMode.SINGLE_FILE;
    }

    @Override
    protected AbstractCommandPanel<CommandArguments.MaxQuantMGFCommand> getConfigurationPanel() {
        if (this.configurationPanel == null) {
            this.configurationPanel = new MaxQuantCreateMgfPanel((CommandArguments.MaxQuantMGFCommand)this.command);
        }
        return this.configurationPanel;
    }

    @Override
    public AbstractCommandPanel<CommandArguments.MaxQuantMGFCommand> getConfigurationPanel(List<MS2Collection> selectedCollections) {
        File[] aplFiles = MS2Collection.MaxQuant.locateAPLFiles(selectedCollections.get(0));
        if (aplFiles.length > 0 && aplFiles[0] != null) {
            ((CommandArguments.MaxQuantMGFCommand)this.command).inputFileName1 = aplFiles[0].getAbsolutePath();
        }
        if (aplFiles.length > 1 && aplFiles[1] != null) {
            ((CommandArguments.MaxQuantMGFCommand)this.command).inputFileName2 = aplFiles[1].getAbsolutePath();
        }
        this.configurationPanel = new MaxQuantCreateMgfPanel((CommandArguments.MaxQuantMGFCommand)this.command);
        if (((CommandArguments.MaxQuantMGFCommand)this.command).inputFileName1 != null && !((CommandArguments.MaxQuantMGFCommand)this.command).inputFileName1.isEmpty()) {
            this.configurationPanel.setOutputRootFolder(new File(((CommandArguments.MaxQuantMGFCommand)this.command).inputFileName1).getParentFile());
        }
        return this.configurationPanel;
    }
}

