/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2.util;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.util.ParamsRetriever;
import java.util.List;
import java.util.Map;

public class PositionalParamsRetriever
extends ParamsRetriever {
    private List<Object> params;

    private static void throwMissingParameterException(int position) throws JSONRPC2Error {
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Missing parameter at position " + position);
    }

    private static void throwNullParameterException(int position) throws JSONRPC2Error {
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Parameter at position " + position + " must not be null");
    }

    private static void throwEnumParameterException(int position, String[] enumStrings) throws JSONRPC2Error {
        StringBuilder msg = new StringBuilder(": Enumerated parameter at position " + position + "\" must have values ");
        for (int i = 0; i < enumStrings.length; ++i) {
            if (i > 0 && i == enumStrings.length - 1) {
                msg.append(" or ");
            } else if (i > 0) {
                msg.append(", ");
            }
            msg.append('\"');
            msg.append(enumStrings[i]);
            msg.append('\"');
        }
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(msg.toString());
    }

    private static <T extends Enum<T>> void throwEnumParameterException(int position, Class<T> enumClass) throws JSONRPC2Error {
        StringBuilder msg = new StringBuilder(": Enumerated parameter at position " + position + " must have values ");
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            if (i > 0 && i == constants.length - 1) {
                msg.append(" or ");
            } else if (i > 0) {
                msg.append(", ");
            }
            msg.append('\"');
            msg.append(constants[i].toString());
            msg.append('\"');
        }
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(msg.toString());
    }

    private static JSONRPC2Error newUnexpectedParameterTypeException(int position) {
        return JSONRPC2Error.INVALID_PARAMS.appendMessage(": Parameter at position " + position + " has an unexpected JSON type");
    }

    private static JSONRPC2Error newArrayException(int position) {
        return JSONRPC2Error.INVALID_PARAMS.appendMessage(": Parameter at position " + position + " caused an array exception");
    }

    public PositionalParamsRetriever(List<Object> params) {
        if (params == null) {
            throw new IllegalArgumentException("The parameters list must not be null");
        }
        this.params = params;
    }

    public List<Object> getParams() {
        return this.params;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    public boolean hasParam(int position) {
        return position < this.params.size();
    }

    public void ensureParam(int position) throws JSONRPC2Error {
        if (position >= this.params.size()) {
            PositionalParamsRetriever.throwMissingParameterException(position);
        }
    }

    public <T> void ensureParam(int position, Class<T> clazz) throws JSONRPC2Error {
        this.ensureParam(position, clazz, false);
    }

    public <T> void ensureParam(int position, Class<T> clazz, boolean allowNull) throws JSONRPC2Error {
        this.ensureParam(position);
        Object value = this.params.get(position);
        if (value == null) {
            if (allowNull) {
                return;
            }
            PositionalParamsRetriever.throwNullParameterException(position);
        }
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw PositionalParamsRetriever.newUnexpectedParameterTypeException(position);
        }
    }

    public Object get(int position) throws JSONRPC2Error {
        this.ensureParam(position);
        return this.params.get(position);
    }

    public <T> T get(int position, Class<T> clazz) throws JSONRPC2Error {
        return this.get(position, clazz, false);
    }

    public <T> T get(int position, Class<T> clazz, boolean allowNull) throws JSONRPC2Error {
        this.ensureParam(position, clazz, allowNull);
        try {
            return (T)this.params.get(position);
        }
        catch (ClassCastException e) {
            throw PositionalParamsRetriever.newUnexpectedParameterTypeException(position);
        }
    }

    public <T> T getOpt(int position, Class<T> clazz, T defaultValue) throws JSONRPC2Error {
        return this.getOpt(position, clazz, false, defaultValue);
    }

    public <T> T getOpt(int position, Class<T> clazz, boolean allowNull, T defaultValue) throws JSONRPC2Error {
        if (!this.hasParam(position)) {
            return defaultValue;
        }
        this.ensureParam(position, clazz, allowNull);
        try {
            return (T)this.params.get(position);
        }
        catch (ClassCastException e) {
            throw PositionalParamsRetriever.newUnexpectedParameterTypeException(position);
        }
    }

    public String getString(int position) throws JSONRPC2Error {
        return this.getString(position, false);
    }

    public String getString(int position, boolean allowNull) throws JSONRPC2Error {
        return this.get(position, String.class, allowNull);
    }

    public String getOptString(int position, String defaultValue) throws JSONRPC2Error {
        return this.getOptString(position, false, defaultValue);
    }

    public String getOptString(int position, boolean allowNull, String defaultValue) throws JSONRPC2Error {
        return this.getOpt(position, String.class, allowNull, defaultValue);
    }

    public String getEnumString(int position, String[] enumStrings) throws JSONRPC2Error {
        return this.getEnumString(position, enumStrings, false);
    }

    public String getEnumString(int position, String[] enumStrings, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.get(position, String.class);
        String match = PositionalParamsRetriever.getEnumStringMatch(value, enumStrings, ignoreCase);
        if (match == null) {
            PositionalParamsRetriever.throwEnumParameterException(position, enumStrings);
        }
        return match;
    }

    public String getOptEnumString(int position, String[] enumStrings, String defaultValue) throws JSONRPC2Error {
        return this.getOptEnumString(position, enumStrings, defaultValue, false);
    }

    public String getOptEnumString(int position, String[] enumStrings, String defaultValue, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.getOpt(position, String.class, defaultValue);
        if (defaultValue == null && value == null) {
            return null;
        }
        String match = PositionalParamsRetriever.getEnumStringMatch(value, enumStrings, ignoreCase);
        if (match == null) {
            PositionalParamsRetriever.throwEnumParameterException(position, enumStrings);
        }
        return match;
    }

    public <T extends Enum<T>> T getEnum(int position, Class<T> enumClass) throws JSONRPC2Error {
        return this.getEnum(position, enumClass, false);
    }

    public <T extends Enum<T>> T getEnum(int position, Class<T> enumClass, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.get(position, String.class);
        T match = PositionalParamsRetriever.getEnumStringMatch(value, enumClass, ignoreCase);
        if (match == null) {
            PositionalParamsRetriever.throwEnumParameterException(position, enumClass);
        }
        return match;
    }

    public <T extends Enum<T>> T getOptEnum(int position, Class<T> enumClass, String defaultValue) throws JSONRPC2Error {
        return this.getOptEnum(position, enumClass, defaultValue, false);
    }

    public <T extends Enum<T>> T getOptEnum(int position, Class<T> enumClass, String defaultValue, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.getOpt(position, String.class, defaultValue);
        if (defaultValue == null && value == null) {
            return null;
        }
        T match = PositionalParamsRetriever.getEnumStringMatch(value, enumClass, ignoreCase);
        if (match == null) {
            PositionalParamsRetriever.throwEnumParameterException(position, enumClass);
        }
        return match;
    }

    public boolean getBoolean(int position) throws JSONRPC2Error {
        return this.get(position, Boolean.class);
    }

    public boolean getOptBoolean(int position, boolean defaultValue) throws JSONRPC2Error {
        return this.getOpt(position, Boolean.class, defaultValue);
    }

    public int getInt(int position) throws JSONRPC2Error {
        Number number = this.get(position, Number.class);
        return number.intValue();
    }

    public int getOptInt(int position, int defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(position, Number.class, defaultValue);
        return number.intValue();
    }

    public long getLong(int position) throws JSONRPC2Error {
        Number number = this.get(position, Number.class);
        return number.longValue();
    }

    public long getOptLong(int position, long defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(position, Number.class, defaultValue);
        return number.longValue();
    }

    public float getFloat(int position) throws JSONRPC2Error {
        Number number = this.get(position, Number.class);
        return number.floatValue();
    }

    public float getOptFloat(int position, float defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(position, Number.class, Float.valueOf(defaultValue));
        return number.floatValue();
    }

    public double getDouble(int position) throws JSONRPC2Error {
        Number number = this.get(position, Number.class);
        return number.doubleValue();
    }

    public double getOptDouble(int position, double defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(position, Number.class, defaultValue);
        return number.doubleValue();
    }

    public List<Object> getList(int position) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getList(position, false);
    }

    public List<Object> getList(int position, boolean allowNull) throws JSONRPC2Error {
        return this.get(position, List.class, allowNull);
    }

    public List<Object> getOptList(int position, List<Object> defaultValue) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getOptList(position, false, defaultValue);
    }

    public List<Object> getOptList(int position, boolean allowNull, List<Object> defaultValue) throws JSONRPC2Error {
        return this.getOpt(position, List.class, allowNull, defaultValue);
    }

    public String[] getStringArray(int position) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getStringArray(position, false);
    }

    public String[] getStringArray(int position, boolean allowNull) throws JSONRPC2Error {
        List<Object> list = this.getList(position, allowNull);
        if (list == null) {
            return null;
        }
        try {
            return list.toArray(new String[0]);
        }
        catch (ArrayStoreException e) {
            throw PositionalParamsRetriever.newArrayException(position);
        }
    }

    public String[] getOptStringArray(int position, String[] defaultValue) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getOptStringArray(position, false, defaultValue);
    }

    public String[] getOptStringArray(int position, boolean allowNull, String[] defaultValue) throws JSONRPC2Error {
        if (!this.hasParam(position)) {
            return defaultValue;
        }
        return this.getStringArray(position, allowNull);
    }

    public Map<String, Object> getMap(int position) throws JSONRPC2Error {
        return this.getMap(position, false);
    }

    public Map<String, Object> getMap(int position, boolean allowNull) throws JSONRPC2Error {
        try {
            return this.get(position, Map.class, allowNull);
        }
        catch (ClassCastException e) {
            throw PositionalParamsRetriever.newUnexpectedParameterTypeException(position);
        }
    }

    public Map<String, Object> getOptMap(int position, Map<String, Object> defaultValue) throws JSONRPC2Error {
        return this.getOptMap(position, false, defaultValue);
    }

    public Map<String, Object> getOptMap(int position, boolean allowNull, Map<String, Object> defaultValue) throws JSONRPC2Error {
        try {
            return this.getOpt(position, Map.class, allowNull, defaultValue);
        }
        catch (ClassCastException e) {
            throw PositionalParamsRetriever.newUnexpectedParameterTypeException(position);
        }
    }
}

