/*
 * Decompiled with CFR 0.152.
 */
package MZIDparser;

import MZIDparser.JModification;
import MZIDparser.JPSM;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisProtocolCollection;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.DataCollection;
import uk.ac.ebi.jmzidml.model.mzidml.Enzyme;
import uk.ac.ebi.jmzidml.model.mzidml.Modification;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidence;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidenceRef;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationItem;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationResult;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class ReadmzID {
    public double qvalue = 0.001;

    public ReadmzID(double qvalue) {
        this.qvalue = qvalue;
    }

    public ArrayList<JPSM> readmzIdentML(String mzidFileString) throws JAXBException {
        File mzidFile = new File(mzidFileString);
        if (!mzidFile.isFile()) {
            System.err.println("mzIdentML file: " + mzidFileString + " is not exist!");
            System.exit(0);
        }
        ArrayList<JPSM> psmArrayList = new ArrayList<JPSM>();
        MzIdentMLUnmarshaller unmarshaller = new MzIdentMLUnmarshaller(mzidFile);
        DataCollection dataCollection = (DataCollection)unmarshaller.unmarshal(MzIdentMLElement.DataCollection);
        if (dataCollection == null) {
            System.err.println("Failed! DataCollection is null!");
            System.exit(0);
        }
        boolean autoTargetDecoySearch = false;
        ArrayList<String> enzyme = new ArrayList<String>();
        AnalysisProtocolCollection apc = (AnalysisProtocolCollection)unmarshaller.unmarshal(MzIdentMLElement.AnalysisProtocolCollection);
        for (SpectrumIdentificationProtocol sProtocol : apc.getSpectrumIdentificationProtocol()) {
            for (UserParam userParam : sProtocol.getAdditionalSearchParams().getUserParam()) {
                if (!userParam.getName().contentEquals("TargetDecoyApproach")) continue;
                autoTargetDecoySearch = Boolean.valueOf(userParam.getValue());
                break;
            }
            for (Enzyme en : sProtocol.getEnzymes().getEnzyme()) {
                for (CvParam cvParam : en.getEnzymeName().getCvParam()) {
                    enzyme.add(cvParam.getAccession());
                }
            }
        }
        if (autoTargetDecoySearch) {
            System.out.println("Auto target-decoy search!");
        } else {
            System.out.println("Must searching with target-decoy mode!");
            System.exit(0);
        }
        List sil = dataCollection.getAnalysisData().getSpectrumIdentificationList();
        for (SpectrumIdentificationList sIdentList : sil) {
            for (SpectrumIdentificationResult spectrumIdentResult : sIdentList.getSpectrumIdentificationResult()) {
                String spectrumID = spectrumIdentResult.getSpectrumID();
                for (SpectrumIdentificationItem spectrumIdentItem : spectrumIdentResult.getSpectrumIdentificationItem()) {
                    Double calculatedMassToCharge = spectrumIdentItem.getCalculatedMassToCharge();
                    Double experimentalMassToCharge = spectrumIdentItem.getExperimentalMassToCharge();
                    int rank = spectrumIdentItem.getRank();
                    if (rank >= 2) continue;
                    int charge = spectrumIdentItem.getChargeState();
                    Peptide peptide = (Peptide)unmarshaller.unmarshal(Peptide.class, spectrumIdentItem.getPeptideRef());
                    String peptideSequence = peptide.getPeptideSequence();
                    JPSM psm = new JPSM();
                    psm.setCalculatedMassToCharge(calculatedMassToCharge);
                    psm.setCharge(charge);
                    psm.setExperimentalMassToCharge(experimentalMassToCharge);
                    psm.setRank(rank);
                    psm.setSpectrumID(spectrumID);
                    String[] tmpIndexArrayList = spectrumID.split("=");
                    psm.setSpectrumIndex(Integer.valueOf(tmpIndexArrayList[tmpIndexArrayList.length - 1]));
                    psm.setPepSeq(peptideSequence);
                    for (PeptideEvidenceRef peptideEvidenceRef : spectrumIdentItem.getPeptideEvidenceRef()) {
                        PeptideEvidence pEvidence = (PeptideEvidence)unmarshaller.unmarshal(PeptideEvidence.class, peptideEvidenceRef.getPeptideEvidenceRef());
                        DBSequence dbSequence = (DBSequence)unmarshaller.unmarshal(DBSequence.class, pEvidence.getDBSequenceRef());
                        psm.addProteins(dbSequence.getAccession());
                        if (!pEvidence.isIsDecoy()) continue;
                        psm.setDecoy(true);
                    }
                    if (psm.isDecoy()) continue;
                    for (CvParam cvParam : spectrumIdentItem.getCvParam()) {
                        if (!cvParam.getAccession().contentEquals("MS:1002054")) continue;
                        psm.setQvalue(Double.valueOf(cvParam.getValue()));
                    }
                    if (psm.getQvalue() > this.qvalue) continue;
                    List modificationList = peptide.getModification();
                    for (Modification modObj : modificationList) {
                        JModification modification = new JModification();
                        modification.setModLocation(modObj.getLocation());
                        String modaa = "";
                        modaa = modObj.getLocation() == 0 ? "N-term" : (modObj.getLocation() == peptideSequence.length() + 1 ? "C-term" : String.valueOf(peptideSequence.charAt(modObj.getLocation() - 1)));
                        modification.setResidue(modaa);
                        modification.setModMassDelta(modObj.getMonoisotopicMassDelta());
                        psm.addModificationList(modification);
                    }
                    if (rank == 1) {
                        psmArrayList.add(psm);
                        continue;
                    }
                    psmArrayList.get(psmArrayList.size() - 1).addPSMRank(psm);
                }
            }
        }
        return psmArrayList;
    }
}

