/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.bruker.timstof.model;

import fr.profi.bruker.timstof.model.Precursor;
import fr.profi.bruker.timstof.model.Spectrum;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import java.text.DecimalFormat;

public class PasefMsMsData {
    private int m_frameId;
    private float m_frameRT;
    private int m_startScan;
    private int m_endScan;
    private int m_precursorId;
    private Spectrum m_pasefMsMs;
    private double m_collisionEnergy;
    private Precursor m_precursor;
    private static DecimalFormat df = new DecimalFormat("#.##");
    private double m_isolationMz;
    private double m_isolationWidth;

    public PasefMsMsData(int frId, int startScan, int endScan, double isolationMz, double isolationWidth, double collisionEnergy, int precursorId, float frameRT) {
        this.m_frameId = frId;
        this.m_startScan = startScan;
        this.m_endScan = endScan;
        this.m_isolationMz = isolationMz;
        this.m_isolationWidth = isolationWidth;
        this.m_precursorId = precursorId;
        this.m_collisionEnergy = collisionEnergy;
        this.m_frameRT = frameRT;
    }

    public double getCollisionEnergy() {
        return this.m_collisionEnergy;
    }

    public int getFrameId() {
        return this.m_frameId;
    }

    public int getStartScan() {
        return this.m_startScan;
    }

    public int getEndScan() {
        return this.m_endScan;
    }

    public int getPrecursorId() {
        return this.m_precursorId;
    }

    public double getIsolationMz() {
        return this.m_isolationMz;
    }

    public double getIsolationWidth() {
        return this.m_isolationWidth;
    }

    protected void setSpectrumData(double[] masses, float[] intensities) {
        String avMzStr = df.format(this.m_precursor.getAverageMz());
        this.m_pasefMsMs = new Spectrum("Frame_" + this.m_frameId + "-Precursor_" + avMzStr, 2, this.m_frameRT, masses, intensities);
    }

    protected void addSpectrumData(Double2FloatMap massInt) {
        if (this.m_pasefMsMs == null) {
            String avMzStr = df.format(this.m_precursor.getAverageMz());
            this.m_pasefMsMs = new Spectrum("Frame_" + this.m_frameId + "-Precursor_" + avMzStr, 2, this.m_frameRT, massInt);
        } else {
            this.m_pasefMsMs.addPeaks(massInt);
        }
    }

    protected void addSpectrumData(double[] masses, float[] intensities) {
        if (this.m_pasefMsMs == null) {
            String avMzStr = df.format(this.m_precursor.getAverageMz());
            this.m_pasefMsMs = new Spectrum("Frame_" + this.m_frameId + "-Precursor_" + avMzStr, 2, this.m_frameRT, masses, intensities);
        } else {
            this.m_pasefMsMs.addPeaks(masses, intensities);
        }
    }

    public void setPrecursor(Precursor p) {
        this.m_precursor = p;
    }

    public Precursor getPrecursor() {
        return this.m_precursor;
    }

    public Spectrum getPasefSpectrum() {
        return this.m_pasefMsMs;
    }

    public void resetSpectrumData() {
        this.m_pasefMsMs = null;
    }

    public boolean containsScan(Integer scanIndex) {
        return scanIndex >= this.getStartScan() && scanIndex <= this.getEndScan();
    }
}

