/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.List;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.special.PowerOf2;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.StructureAnyD;

abstract class ArrayFactory<N extends Comparable<N>, I extends BasicArray<N>>
implements Factory1D.Dense<I> {
    ArrayFactory() {
    }

    @Override
    public I copy(Access1D<?> source) {
        long count = source.count();
        I retVal = this.makeToBeFilled(count);
        retVal.fillMatching(source);
        return retVal;
    }

    @Override
    public I copy(Comparable<?>[] source) {
        int length = source.length;
        I retVal = this.makeToBeFilled(length);
        for (int i = 0; i < length; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    @Override
    public I copy(double ... source) {
        int length = source.length;
        I retVal = this.makeToBeFilled(length);
        for (int i = 0; i < length; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    @Override
    public I copy(List<? extends Comparable<?>> source) {
        int size = source.size();
        I retVal = this.makeToBeFilled(size);
        for (int i = 0; i < size; ++i) {
            retVal.set((long)i, source.get(i));
        }
        return retVal;
    }

    public abstract FunctionSet<N> function();

    @Override
    public I make(long count) {
        return this.makeStructuredZero(count);
    }

    @Override
    public I makeFilled(long count, NullaryFunction<?> supplier) {
        I retVal = this.makeToBeFilled(count);
        if (((BasicArray)retVal).isPrimitive()) {
            for (long i = 0L; i < count; ++i) {
                retVal.set(i, supplier.doubleValue());
            }
        } else {
            for (long i = 0L; i < count; ++i) {
                retVal.set(i, (Comparable<?>)supplier.get());
            }
        }
        return retVal;
    }

    public abstract Scalar.Factory<N> scalar();

    abstract AggregatorSet<N> aggregator();

    abstract long getCapacityLimit();

    SegmentedArray<N> makeSegmented(long ... structure) {
        long totalCount = StructureAnyD.count(structure);
        int max = PowerOf2.powerOf2Smaller(Math.min(totalCount, this.getCapacityLimit()));
        int min = PowerOf2.powerOf2Larger(totalCount / 0x7FFFFFF7L);
        if (min > max) {
            throw new IllegalArgumentException();
        }
        int indexBits = Math.max(min, max - OjAlgoUtils.ENVIRONMENT.cores);
        return new SegmentedArray(totalCount, indexBits, this);
    }

    abstract I makeStructuredZero(long ... var1);

    abstract I makeToBeFilled(long ... var1);

    @SafeVarargs
    final SegmentedArray<N> wrapAsSegments(BasicArray<N> ... segments) {
        return new SegmentedArray<N>(segments, this);
    }
}

