/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.constant.QuaternionMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.Scalar;

public final class QuaternionAggregator
extends AggregatorSet<Quaternion> {
    private static final ThreadLocal<AggregatorFunction<Quaternion>> AVERAGE = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private int myCount = 0;
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return (Quaternion)this.myNumber.divide(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    ++this.myCount;
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myCount = 0;
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> CARDINALITY = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private int myCount = 0;

                @Override
                public Quaternion get() {
                    return Quaternion.valueOf(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(Quaternion anArg) {
                    if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, anArg.norm())) {
                        ++this.myCount;
                    }
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> LARGEST = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = QuaternionMath.MAX.invoke(this.myNumber, QuaternionMath.ABS.invoke(anArg));
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> MAX = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = QuaternionMath.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> MIN = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.INFINITY;

                @Override
                public Quaternion get() {
                    if (Quaternion.isInfinite(this.myNumber)) {
                        return Quaternion.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = QuaternionMath.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> NORM1 = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = this.myNumber.add(anArg.norm());
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> NORM2 = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return Quaternion.valueOf(PrimitiveMath.SQRT.invoke(this.myNumber.norm()));
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    double tmpMod = anArg.norm();
                    this.myNumber = this.myNumber.add(tmpMod * tmpMod);
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> PRODUCT = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ONE;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = this.myNumber.multiply(anArg);
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ONE;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> PRODUCT2 = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ONE;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = this.myNumber.multiply(anArg.multiply(anArg));
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ONE;
                    return this;
                }
            };
        }
    };
    private static final QuaternionAggregator SET = new QuaternionAggregator();
    private static final ThreadLocal<AggregatorFunction<Quaternion>> SMALLEST = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.INFINITY;

                @Override
                public Quaternion get() {
                    if (Quaternion.isInfinite(this.myNumber)) {
                        return Quaternion.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    if (!Quaternion.isSmall(PrimitiveMath.ONE, anArg)) {
                        this.myNumber = QuaternionMath.MIN.invoke(this.myNumber, QuaternionMath.ABS.invoke(anArg));
                    }
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.INFINITY;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> SUM = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = this.myNumber.add(anArg);
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };
    private static final ThreadLocal<AggregatorFunction<Quaternion>> SUM2 = new ThreadLocal<AggregatorFunction<Quaternion>>(){

        @Override
        protected AggregatorFunction<Quaternion> initialValue() {
            return new QuaternionAggregatorFunction(){
                private Quaternion myNumber = Quaternion.ZERO;

                @Override
                public Quaternion get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(Quaternion anArg) {
                    this.myNumber = this.myNumber.add(anArg.multiply(anArg));
                }

                @Override
                public AggregatorFunction<Quaternion> reset() {
                    this.myNumber = Quaternion.ZERO;
                    return this;
                }
            };
        }
    };

    public static QuaternionAggregator getSet() {
        return SET;
    }

    private QuaternionAggregator() {
    }

    @Override
    public AggregatorFunction<Quaternion> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<Quaternion> sum2() {
        return SUM2.get().reset();
    }

    static abstract class QuaternionAggregatorFunction
    implements AggregatorFunction<Quaternion> {
        QuaternionAggregatorFunction() {
        }

        @Override
        public final double doubleValue() {
            return ((Quaternion)this.get()).doubleValue();
        }

        @Override
        public final void invoke(double anArg) {
            this.invoke(Quaternion.valueOf(anArg));
        }

        @Override
        public final void invoke(float anArg) {
            this.invoke(Quaternion.valueOf(anArg));
        }

        @Override
        public final Scalar<Quaternion> toScalar() {
            return (Scalar)this.get();
        }
    }
}

