/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.Primitive32Store;
import org.ojalgo.structure.Access1D;

public final class PolynomialR032
extends AbstractPolynomial<Double> {
    public PolynomialR032(int degree) {
        super((Array1D)Array1D.R032.make(degree + 1));
    }

    PolynomialR032(Array1D<Double> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, Primitive32Store.FACTORY, QR.R064);
    }

    @Override
    public Double integrate(Double fromPoint, Double toPoint) {
        PolynomialFunction primitive = this.buildPrimitive();
        double fromVal = primitive.invoke(fromPoint);
        double toVal = primitive.invoke(toPoint);
        return toVal - fromVal;
    }

    @Override
    public Double invoke(Double arg) {
        return this.invoke((double)arg);
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int limit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < limit; ++p) {
            this.set(p, coefficients.doubleValue(p));
        }
    }

    @Override
    protected Double getDerivativeFactor(int power) {
        int nextIndex = power + 1;
        return (double)nextIndex * this.doubleValue(nextIndex);
    }

    @Override
    protected Double getPrimitiveFactor(int power) {
        if (power <= 0) {
            return PrimitiveMath.ZERO;
        }
        return this.doubleValue(power - 1) / (double)power;
    }

    @Override
    protected AbstractPolynomial<Double> makeInstance(int size) {
        return new PolynomialR032((Array1D)Array1D.R032.make(size));
    }
}

