/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.decomposition.GeneralEvD;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access2D;

abstract class DynamicEvD<N extends Comparable<N>>
extends EigenvalueDecomposition<N> {
    private final EigenvalueDecomposition<N> myGeneralDelegate;
    private boolean myHermitian = false;
    private final EigenvalueDecomposition<N> myHermitianDelegate;

    private DynamicEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        this(factory, null, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected DynamicEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, EigenvalueDecomposition<N> hermitianDelegate, EigenvalueDecomposition<N> generalDelegate) {
        super(factory);
        this.myHermitianDelegate = hermitianDelegate;
        this.myGeneralDelegate = generalDelegate;
    }

    @Override
    public boolean checkAndDecompose(MatrixStore<N> matrix) {
        return this.decompose(matrix);
    }

    @Override
    public N getDeterminant() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getDeterminant();
        }
        return this.myGeneralDelegate.getDeterminant();
    }

    @Override
    public ComplexNumber getTrace() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getTrace();
        }
        return this.myGeneralDelegate.getTrace();
    }

    @Override
    public boolean isHermitian() {
        return this.myHermitian;
    }

    @Override
    public boolean isOrdered() {
        return this.myHermitian ? this.myHermitianDelegate.isOrdered() : this.myGeneralDelegate.isOrdered();
    }

    @Override
    public void reset() {
        super.reset();
        this.myGeneralDelegate.reset();
        this.myHermitianDelegate.reset();
    }

    @Override
    protected boolean doDecompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly) {
        this.myHermitian = matrix instanceof MatrixStore ? ((MatrixStore)matrix).isHermitian() : false;
        if (this.myHermitian) {
            return this.myHermitianDelegate.doDecompose(matrix, valuesOnly);
        }
        return this.myGeneralDelegate.doDecompose(matrix, valuesOnly);
    }

    @Override
    protected MatrixStore<N> makeD() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getD();
        }
        return this.myGeneralDelegate.getD();
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getEigenvalues();
        }
        return this.myGeneralDelegate.getEigenvalues();
    }

    @Override
    protected MatrixStore<N> makeV() {
        if (this.myHermitian) {
            return this.myHermitianDelegate.getV();
        }
        return this.myGeneralDelegate.getV();
    }

    static final class R064
    extends DynamicEvD<Double> {
        R064() {
            super(Primitive64Store.FACTORY, new HermitianEvD.R064(), new GeneralEvD.R064());
        }
    }
}

