/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.util.List;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.task.iterative.IterativeSolverTask;
import org.ojalgo.matrix.task.iterative.KrylovSubspaceSolver;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;

public final class ConjugateGradientSolver
extends KrylovSubspaceSolver
implements IterativeSolverTask.SparseDelegate {
    private transient Primitive64Store myDirection = null;
    private transient Primitive64Store myPreconditioned = null;
    private transient Primitive64Store myResidual = null;
    private transient Primitive64Store myVector = null;

    @Override
    public double resolve(List<Equation> equations, PhysicalStore<Double> solution) {
        double pivot;
        double tmpVal;
        Equation row;
        int r;
        int nbEquations = equations.size();
        int iterations = 0;
        int limit = this.getIterationsLimit();
        NumberContext accuracy = this.getAccuracyContext();
        double normErr = Double.POSITIVE_INFINITY;
        double normRHS = PrimitiveMath.ONE;
        Primitive64Store residual = this.residual(solution);
        Primitive64Store direction = this.direction(solution);
        Primitive64Store preconditioned = this.preconditioned(solution);
        Primitive64Store vector = this.vector(solution);
        double zr0 = 1.0;
        double pAp0 = 0.0;
        for (r = 0; r < nbEquations; ++r) {
            row = equations.get(r);
            tmpVal = row.getRHS();
            normRHS = PrimitiveMath.HYPOT.invoke(normRHS, tmpVal);
            residual.set((long)row.index, tmpVal -= row.dot(solution));
            pivot = row.getPivot();
            preconditioned.set((long)row.index, tmpVal / pivot);
        }
        direction.fillMatching(preconditioned);
        double zr1 = preconditioned.dot(residual);
        do {
            zr0 = zr1;
            for (int i = 0; i < nbEquations; ++i) {
                row = equations.get(i);
                vector.set((long)row.index, row.dot(direction));
            }
            pAp0 = direction.dot(vector);
            double stepLength = zr0 / pAp0;
            if (!Double.isNaN(stepLength)) {
                direction.axpy(stepLength, solution);
                vector.axpy(-stepLength, residual);
            }
            normErr = PrimitiveMath.ZERO;
            for (r = 0; r < nbEquations; ++r) {
                row = equations.get(r);
                tmpVal = residual.doubleValue((long)row.index);
                normErr = PrimitiveMath.HYPOT.invoke(normErr, tmpVal);
                pivot = row.getPivot();
                preconditioned.set((long)row.index, tmpVal / pivot);
            }
            zr1 = preconditioned.dot(residual);
            double gradientCorrectionFactor = zr1 / zr0;
            direction.modifyAll((UnaryFunction<Double>)PrimitiveMath.MULTIPLY.second(gradientCorrectionFactor));
            direction.modifyMatching(PrimitiveMath.ADD, preconditioned);
            ++iterations;
            if (!this.isDebugPrinterSet()) continue;
            this.debug(iterations, normErr / normRHS, solution);
        } while (iterations < limit && !Double.isNaN(normErr) && !accuracy.isSmall(normRHS, normErr));
        return normErr / normRHS;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        List<Equation> equations = IterativeSolverTask.toListOfRows(body, rhs);
        this.resolve(equations, preallocated);
        return preallocated;
    }

    private Primitive64Store direction(Structure1D structure) {
        if (this.myDirection == null || this.myDirection.count() != structure.count()) {
            this.myDirection = (Primitive64Store)Primitive64Store.FACTORY.make(structure.count(), 1L);
        } else {
            this.myDirection.fillAll(PrimitiveMath.ZERO);
        }
        return this.myDirection;
    }

    private Primitive64Store preconditioned(Structure1D structure) {
        if (this.myPreconditioned == null || this.myPreconditioned.count() != structure.count()) {
            this.myPreconditioned = (Primitive64Store)Primitive64Store.FACTORY.make(structure.count(), 1L);
        } else {
            this.myPreconditioned.fillAll(PrimitiveMath.ZERO);
        }
        return this.myPreconditioned;
    }

    private Primitive64Store residual(Structure1D structure) {
        if (this.myResidual == null || this.myResidual.count() != structure.count()) {
            this.myResidual = (Primitive64Store)Primitive64Store.FACTORY.make(structure.count(), 1L);
        } else {
            this.myResidual.fillAll(PrimitiveMath.ZERO);
        }
        return this.myResidual;
    }

    private Primitive64Store vector(Structure1D structure) {
        if (this.myVector == null || this.myVector.count() != structure.count()) {
            this.myVector = (Primitive64Store)Primitive64Store.FACTORY.make(structure.count(), 1L);
        } else {
            this.myVector.fillAll(PrimitiveMath.ZERO);
        }
        return this.myVector;
    }
}

