/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.ojalgo.netio.FromFileReader;
import org.ojalgo.netio.InMemoryFile;
import org.ojalgo.type.function.OperatorWithException;

public final class DataReader<T>
implements FromFileReader<T> {
    private final Deserializer<T> myDeserializer;
    private final DataInputStream myInput;

    public static <T> DataReader<T> of(File file, Deserializer<T> deserializer) {
        return new DataReader<T>(FromFileReader.input(file), deserializer);
    }

    public static <T> DataReader<T> of(File file, Deserializer<T> deserializer, OperatorWithException<InputStream> filter) {
        return new DataReader<T>(filter.apply(FromFileReader.input(file)), deserializer);
    }

    public static <T> DataReader<T> of(InMemoryFile file, Deserializer<T> deserializer) {
        return new DataReader<T>(file.newInputStream(), deserializer);
    }

    public static <T> DataReader<T> of(InMemoryFile file, Deserializer<T> deserializer, OperatorWithException<InputStream> filter) {
        return new DataReader<T>(filter.apply(file.newInputStream()), deserializer);
    }

    public DataReader(InputStream inputStream, Deserializer<T> deserializer) {
        this.myInput = new DataInputStream(new BufferedInputStream(inputStream));
        this.myDeserializer = deserializer;
    }

    @Override
    public void close() throws IOException {
        this.myInput.close();
    }

    @Override
    public T read() {
        return this.myDeserializer.apply(this.myInput);
    }

    @FunctionalInterface
    public static interface Deserializer<T>
    extends Function<DataInput, T> {
        @Override
        default public T apply(DataInput input) {
            try {
                return this.deserialize(input);
            }
            catch (IOException cause) {
                return null;
            }
        }

        public T deserialize(DataInput var1) throws IOException;
    }
}

