/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.ojalgo.netio.BasicParser;
import org.ojalgo.netio.TextLineReader;
import org.ojalgo.type.keyvalue.KeyValue;

public abstract class DetectingParser<T>
implements BasicParser<T> {
    private final List<KeyValue<Predicate<String>, TextLineReader.Parser<? extends T>>> myPotentialParsers = new ArrayList<KeyValue<Predicate<String>, TextLineReader.Parser<? extends T>>>();
    private TextLineReader.Parser<? extends T> mySelectedParser = null;
    private final TextLineReader.Parser<T> myDefaultParser;

    protected DetectingParser(TextLineReader.Parser<T> defaultParser) {
        this.myDefaultParser = defaultParser;
    }

    @Override
    public T parse(String line) {
        if (this.mySelectedParser == null) {
            for (KeyValue<Predicate<String>, TextLineReader.Parser<T>> pair : this.myPotentialParsers) {
                Predicate<String> predicate = pair.getKey();
                TextLineReader.Parser<? extends T> parser = pair.getValue();
                if (!predicate.test(line)) continue;
                this.mySelectedParser = parser;
                break;
            }
        }
        if (this.mySelectedParser == null) {
            this.mySelectedParser = this.myDefaultParser;
        }
        return this.mySelectedParser.parse(line);
    }

    protected void addPotentialParser(Predicate<String> predicate, TextLineReader.Parser<? extends T> parser) {
        this.myPotentialParsers.add(KeyValue.of(predicate, parser));
    }
}

