/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Matrix2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.BasePrimitiveSolver;
import org.ojalgo.optimisation.convex.ConvexData;
import org.ojalgo.optimisation.convex.ConvexObjectiveFunction;
import org.ojalgo.optimisation.convex.IterativeRefinementSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public abstract class ConvexSolver
extends GenericSolver {
    public static final ModelIntegration INTEGRATION = new ModelIntegration();

    public static void copy(ExpressionsBasedModel sourceModel, Builder destinationBuilder) {
        destinationBuilder.reset();
        List<Variable> freeVariables = sourceModel.getFreeVariables();
        Set<Structure1D.IntIndex> fixedVariables = sourceModel.getFixedVariables();
        int nbVariables = freeVariables.size();
        List tmpEqExpr = sourceModel.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int nbEqExpr = tmpEqExpr.size();
        if (nbEqExpr > 0) {
            SparseStore mtrxAE = (SparseStore)SparseStore.R064.make(nbEqExpr, nbVariables);
            PhysicalStore mtrxBE = (PhysicalStore)Primitive64Store.FACTORY.make(nbEqExpr, 1);
            for (int i = 0; i < nbEqExpr; ++i) {
                Expression expression = ((Expression)tmpEqExpr.get(i)).compensate(fixedVariables);
                for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                    mtrxAE.set((long)i, (long)sourceModel.indexOfFreeVariable(key.index), expression.get(key, true));
                }
                mtrxBE.set((long)i, 0L, expression.getUpperLimit(true, Double.POSITIVE_INFINITY));
            }
            destinationBuilder.equalities((Access2D)mtrxAE, (Access1D)mtrxBE);
        }
        Expression tmpObjExpr = sourceModel.objective().compensate(fixedVariables);
        boolean max = sourceModel.getOptimisationSense() == Optimisation.Sense.MAX;
        PhysicalStore mtrxQ = null;
        if (tmpObjExpr.isAnyQuadraticFactorNonZero()) {
            mtrxQ = (PhysicalStore)Primitive64Store.FACTORY.make(nbVariables, nbVariables);
            for (Structure2D.IntRowColumn intRowColumn : tmpObjExpr.getQuadraticKeySet()) {
                int row = sourceModel.indexOfFreeVariable(intRowColumn.row);
                int col = sourceModel.indexOfFreeVariable(intRowColumn.column);
                BigDecimal factor = max ? tmpObjExpr.get(intRowColumn, true).negate() : tmpObjExpr.get(intRowColumn, true);
                mtrxQ.add((long)row, (long)col, factor);
                mtrxQ.add((long)col, (long)row, factor);
            }
        }
        PhysicalStore mtrxC = null;
        if (tmpObjExpr.isAnyLinearFactorNonZero()) {
            mtrxC = (PhysicalStore)Primitive64Store.FACTORY.make(nbVariables, 1);
            if (max) {
                for (Structure1D.IntIndex key : tmpObjExpr.getLinearKeySet()) {
                    mtrxC.set((long)sourceModel.indexOfFreeVariable(key.index), 0L, tmpObjExpr.get(key, true));
                }
            } else {
                for (Structure1D.IntIndex key : tmpObjExpr.getLinearKeySet()) {
                    mtrxC.set((long)sourceModel.indexOfFreeVariable(key.index), 0L, tmpObjExpr.get(key, true).negate());
                }
            }
        }
        if (mtrxQ == null && mtrxC == null) {
            mtrxQ = Primitive64Store.FACTORY.makeEye(nbVariables, nbVariables);
        }
        destinationBuilder.objective(mtrxQ, mtrxC);
        List list = sourceModel.constraints().filter(e -> e.isUpperConstraint() && !e.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int nbUpExpr = list.size();
        List tmpUpVar = sourceModel.bounds().filter(c4 -> c4.isUpperConstraint()).collect(Collectors.toList());
        int nbUpVar = tmpUpVar.size();
        List tmpLoExpr = sourceModel.constraints().filter(c1 -> c1.isLowerConstraint() && !c1.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int nbLoExpr = tmpLoExpr.size();
        List tmpLoVar = sourceModel.bounds().filter(c3 -> c3.isLowerConstraint()).collect(Collectors.toList());
        int nbLoVar = tmpLoVar.size();
        if (nbUpExpr + nbUpVar + nbLoExpr + nbLoVar > 0) {
            Variable variable;
            Expression expression;
            SparseArray<Double> rowAI;
            int i;
            RowsSupplier<Double> mtrxAI = Primitive64Store.FACTORY.makeRowsSupplier(nbVariables);
            PhysicalStore mtrxBI = (PhysicalStore)Primitive64Store.FACTORY.make(nbUpExpr + nbUpVar + nbLoExpr + nbLoVar, 1);
            if (nbUpExpr > 0) {
                for (i = 0; i < nbUpExpr; ++i) {
                    rowAI = mtrxAI.addRow();
                    expression = ((Expression)list.get(i)).compensate(fixedVariables);
                    for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                        rowAI.set((long)sourceModel.indexOfFreeVariable(key.index), expression.doubleValue(key, true));
                    }
                    mtrxBI.set((long)i, 0L, expression.getUpperLimit(true, Double.POSITIVE_INFINITY));
                }
            }
            if (nbUpVar > 0) {
                for (i = 0; i < nbUpVar; ++i) {
                    rowAI = mtrxAI.addRow();
                    variable = (Variable)tmpUpVar.get(i);
                    rowAI.set((long)sourceModel.indexOfFreeVariable(variable), PrimitiveMath.ONE);
                    mtrxBI.set((long)(nbUpExpr + i), 0L, variable.getUpperLimit(false, Double.POSITIVE_INFINITY));
                }
            }
            if (nbLoExpr > 0) {
                for (i = 0; i < nbLoExpr; ++i) {
                    rowAI = mtrxAI.addRow();
                    expression = ((Expression)tmpLoExpr.get(i)).compensate(fixedVariables);
                    for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                        rowAI.set((long)sourceModel.indexOfFreeVariable(key.index), -expression.doubleValue(key, true));
                    }
                    mtrxBI.set((long)(nbUpExpr + nbUpVar + i), 0L, -expression.getLowerLimit(true, Double.NEGATIVE_INFINITY));
                }
            }
            if (nbLoVar > 0) {
                for (i = 0; i < nbLoVar; ++i) {
                    rowAI = mtrxAI.addRow();
                    variable = (Variable)tmpLoVar.get(i);
                    rowAI.set((long)sourceModel.indexOfFreeVariable(variable), PrimitiveMath.NEG);
                    mtrxBI.set((long)(nbUpExpr + nbUpVar + nbLoExpr + i), 0L, -variable.getLowerLimit(false, Double.NEGATIVE_INFINITY));
                }
            }
            destinationBuilder.inequalities(mtrxAI, (Access1D)mtrxBI);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <N extends Comparable<N>> ConvexData<N> copy(ExpressionsBasedModel sourceModel, PhysicalStore.Factory<N, ?> factory) {
        void var20_37;
        void var20_35;
        void var20_33;
        void var20_31;
        List<Variable> freeVariables = sourceModel.getFreeVariables();
        Set<Structure1D.IntIndex> fixedVariables = sourceModel.getFixedVariables();
        int nbVariables = freeVariables.size();
        List tmpEqExpr = sourceModel.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int nbEqExpr = tmpEqExpr.size();
        List tmpUpExpr = sourceModel.constraints().filter(e -> e.isUpperConstraint() && !e.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int nbUpExpr = tmpUpExpr.size();
        List tmpUpVar = sourceModel.bounds().filter(c4 -> c4.isUpperConstraint()).collect(Collectors.toList());
        int nbUpVar = tmpUpVar.size();
        List tmpLoExpr = sourceModel.constraints().filter(c1 -> c1.isLowerConstraint() && !c1.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int nbLoExpr = tmpLoExpr.size();
        List tmpLoVar = sourceModel.bounds().filter(c3 -> c3.isLowerConstraint()).collect(Collectors.toList());
        int nbLoVar = tmpLoVar.size();
        ConvexData<N> retVal = new ConvexData<N>(factory, nbVariables, nbEqExpr, nbUpExpr + nbUpVar + nbLoExpr + nbLoVar);
        Expression tmpObjExpr = sourceModel.objective().compensate(fixedVariables);
        boolean max = sourceModel.getOptimisationSense() == Optimisation.Sense.MAX;
        boolean didSet = false;
        if (tmpObjExpr.isAnyQuadraticFactorNonZero()) {
            for (Structure2D.IntRowColumn intRowColumn : tmpObjExpr.getQuadraticKeySet()) {
                int row = sourceModel.indexOfFreeVariable(intRowColumn.row);
                int col = sourceModel.indexOfFreeVariable(intRowColumn.column);
                BigDecimal factor = max ? tmpObjExpr.get(intRowColumn, true).negate() : tmpObjExpr.get(intRowColumn, true);
                retVal.addObjective(row, col, factor);
                retVal.addObjective(col, row, factor);
                didSet = true;
            }
        }
        if (tmpObjExpr.isAnyLinearFactorNonZero()) {
            if (max) {
                for (Structure1D.IntIndex intIndex : tmpObjExpr.getLinearKeySet()) {
                    retVal.setObjective(sourceModel.indexOfFreeVariable(intIndex.index), tmpObjExpr.get(intIndex, true));
                    didSet = true;
                }
            } else {
                for (Structure1D.IntIndex intIndex : tmpObjExpr.getLinearKeySet()) {
                    retVal.setObjective(sourceModel.indexOfFreeVariable(intIndex.index), tmpObjExpr.get(intIndex, true).negate());
                    didSet = true;
                }
            }
        }
        if (!didSet) {
            for (int ij = 0; ij < nbVariables; ++ij) {
                retVal.setObjective(ij, ij, BigMath.ONE);
            }
        }
        for (int i2 = 0; i2 < nbEqExpr; ++i2) {
            Expression expression = ((Expression)tmpEqExpr.get(i2)).compensate(fixedVariables);
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                retVal.setAE(i2, sourceModel.indexOfFreeVariable(key.index), expression.get(key, true));
            }
            retVal.setBE(i2, expression.getUpperLimit(true, BigMath.SMALLEST_POSITIVE_INFINITY));
        }
        int base = 0;
        boolean bl = false;
        while (var20_31 < nbUpExpr) {
            Expression expression = ((Expression)tmpUpExpr.get((int)var20_31)).compensate(fixedVariables);
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                retVal.setAI(base + var20_31, sourceModel.indexOfFreeVariable(key.index), expression.get(key, true));
            }
            retVal.setBI(base + var20_31, expression.getUpperLimit(true, BigMath.SMALLEST_POSITIVE_INFINITY));
            ++var20_31;
        }
        base += nbUpExpr;
        boolean bl2 = false;
        while (var20_33 < nbUpVar) {
            Variable variable = (Variable)tmpUpVar.get((int)var20_33);
            retVal.setAI(base + var20_33, sourceModel.indexOfFreeVariable(variable), PrimitiveMath.ONE);
            retVal.setBI(base + var20_33, variable.getUpperLimit(false, BigMath.SMALLEST_POSITIVE_INFINITY));
            ++var20_33;
        }
        base += nbUpVar;
        boolean bl3 = false;
        while (var20_35 < nbLoExpr) {
            Expression expression = ((Expression)tmpLoExpr.get((int)var20_35)).compensate(fixedVariables);
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                retVal.setAI(base + var20_35, sourceModel.indexOfFreeVariable(key.index), expression.get(key, true).negate());
            }
            retVal.setBI(base + var20_35, expression.getLowerLimit(true, BigMath.SMALLEST_NEGATIVE_INFINITY).negate());
            ++var20_35;
        }
        base += nbLoExpr;
        boolean bl4 = false;
        while (var20_37 < nbLoVar) {
            Variable variable = (Variable)tmpLoVar.get((int)var20_37);
            retVal.setAI(base + var20_37, sourceModel.indexOfFreeVariable(variable), PrimitiveMath.NEG);
            retVal.setBI(base + var20_37, variable.getLowerLimit(false, BigMath.SMALLEST_NEGATIVE_INFINITY).negate());
            ++var20_37;
        }
        base += nbLoVar;
        return retVal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Access2D<?> quadratic) {
        Builder retVal = new Builder(quadratic.getMinDim());
        retVal.quadratic(quadratic);
        return retVal;
    }

    public static Builder newBuilder(int nbVariables) {
        return new Builder(nbVariables);
    }

    protected ConvexSolver(Optimisation.Options solverOptions) {
        super(solverOptions);
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<ConvexSolver> {
        @Override
        public ConvexSolver build(ExpressionsBasedModel model) {
            Optimisation.Options options = model.options;
            if (options.convex().isExtendedPrecision()) {
                ConvexData<Quadruple> data = ConvexSolver.copy(model, GenericStore.R128);
                return new IterativeRefinementSolver(options, data);
            }
            ConvexData<Double> data = ConvexSolver.copy(model, Primitive64Store.FACTORY);
            return BasePrimitiveSolver.newSolver(data, options);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && model.isAnyObjectiveQuadratic() && !model.isAnyConstraintQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            List<Variable> freeVariables = model.getFreeVariables();
            Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
            int nbFreeVars = freeVariables.size();
            int nbModelVars = model.countVariables();
            ArrayR064 modelSolution = ArrayR064.make(nbModelVars);
            for (int i = 0; i < nbFreeVars; ++i) {
                modelSolution.set((long)model.indexOf(freeVariables.get(i)), solverState.doubleValue(i));
            }
            for (Structure1D.IntIndex fixed : fixedVariables) {
                modelSolution.set((long)fixed.index, model.getVariable(fixed.index).getValue());
            }
            return new Optimisation.Result(solverState.getState(), modelSolution);
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            List<Variable> freeVariables = model.getFreeVariables();
            int nbFreeVars = freeVariables.size();
            ArrayR064 solverSolution = ArrayR064.make(nbFreeVars);
            for (int i = 0; i < nbFreeVars; ++i) {
                Variable variable = freeVariables.get(i);
                int modelIndex = model.indexOf(variable);
                solverSolution.set((long)i, modelState.doubleValue(modelIndex));
            }
            return new Optimisation.Result(modelState.getState(), solverSolution);
        }
    }

    public static final class Configuration {
        private boolean myExtendedPrecision = false;
        private NumberContext myIterative = NumberContext.of(10, 14).withMode(RoundingMode.HALF_DOWN);
        private double mySmallDiagonal = PrimitiveMath.RELATIVELY_SMALL + PrimitiveMath.MACHINE_EPSILON;
        private Function<Structure2D, MatrixDecomposition.Solver<Double>> mySolverGeneral = LU.R064::make;
        private Function<Structure2D, MatrixDecomposition.Solver<Double>> mySolverSPD = Cholesky.R064::make;

        public Configuration extendedPrecision(boolean extendedPrecision) {
            this.myExtendedPrecision = extendedPrecision;
            return this;
        }

        public boolean isExtendedPrecision() {
            return this.myExtendedPrecision;
        }

        public NumberContext iterative() {
            return this.myIterative;
        }

        public Configuration iterative(NumberContext accuracy) {
            Objects.requireNonNull(accuracy);
            this.myIterative = accuracy;
            return this;
        }

        public MatrixDecomposition.Solver<Double> newSolverGeneral(Structure2D structure) {
            return this.mySolverGeneral.apply(structure);
        }

        public MatrixDecomposition.Solver<Double> newSolverSPD(Structure2D structure) {
            return this.mySolverSPD.apply(structure);
        }

        public double smallDiagonal() {
            return this.mySmallDiagonal;
        }

        public Configuration smallDiagonal(double factor) {
            this.mySmallDiagonal = factor;
            return this;
        }

        public Configuration solverGeneral(Function<Structure2D, MatrixDecomposition.Solver<Double>> factory) {
            this.mySolverGeneral = factory;
            return this;
        }

        public Configuration solverSPD(Function<Structure2D, MatrixDecomposition.Solver<Double>> factory) {
            this.mySolverSPD = factory;
            return this;
        }
    }

    public static final class Builder
    extends GenericSolver.Builder<Builder, ConvexSolver> {
        @Deprecated
        public Builder() {
        }

        @Deprecated
        public Builder(MatrixStore<Double> C) {
            this.objective(C);
        }

        @Deprecated
        public Builder(MatrixStore<Double> Q, MatrixStore<Double> C) {
            this.objective(Q, C);
        }

        Builder(int nbVariables) {
            this.setNumberOfVariables(nbVariables);
        }

        Builder(MatrixStore<Double>[] matrices) {
            if (matrices.length >= 2 && matrices[0] != null && matrices[1] != null) {
                this.equalities(matrices[0], matrices[1]);
            }
            if (matrices.length >= 4) {
                if (matrices[2] != null) {
                    this.objective(matrices[2], matrices[3]);
                } else if (matrices[3] != null) {
                    this.objective(matrices[3]);
                }
            }
            if (matrices.length >= 6 && matrices[4] != null && matrices[5] != null) {
                this.inequalities(matrices[4], matrices[5]);
            }
        }

        @Override
        public Builder equalities(Access2D<?> mtrxAE, Access1D<?> mtrxBE) {
            return (Builder)super.equalities(mtrxAE, mtrxBE);
        }

        @Override
        public Builder equality(double rhs, double ... factors) {
            return (Builder)super.equality(rhs, factors);
        }

        public ConvexObjectiveFunction<Double> getObjective() {
            ConvexObjectiveFunction<Double> retVal = this.getObjective(ConvexObjectiveFunction.class);
            if (retVal == null) {
                int nbVariables = this.countVariables();
                PhysicalStore mtrxQ = (PhysicalStore)this.getFactory().make(nbVariables, nbVariables);
                PhysicalStore mtrxC = (PhysicalStore)this.getFactory().make(nbVariables, 1);
                retVal = new ConvexObjectiveFunction<Double>(mtrxQ, mtrxC);
                super.setObjective(retVal);
            }
            return retVal;
        }

        @Override
        public Builder inequalities(Access2D<?> mtrxAI, Access1D<?> mtrxBI) {
            return (Builder)super.inequalities(mtrxAI, mtrxBI);
        }

        @Override
        public Builder inequality(double rhs, double ... factors) {
            return (Builder)super.inequality(rhs, factors);
        }

        public Builder linear(Access1D<?> factors) {
            ((ConvexObjectiveFunction)this.getObjective()).linear().fillMatching(factors);
            return this;
        }

        public Builder linear(double ... factors) {
            ((ConvexObjectiveFunction)this.getObjective()).linear().fillMatching((Access1D)this.getFactory().column(factors));
            return this;
        }

        public Builder objective(int index, double value) {
            ((ConvexObjectiveFunction)this.getObjective()).linear().set((long)index, value);
            return this;
        }

        public Builder objective(int row, int col, double value) {
            ((ConvexObjectiveFunction)this.getObjective()).quadratic().set((long)row, (long)col, value);
            return this;
        }

        @Deprecated
        public Builder objective(MatrixStore<?> mtrxC) {
            this.setObjective(BasePrimitiveSolver.toObjectiveFunction(null, mtrxC));
            return this;
        }

        public Builder objective(MatrixStore<?> mtrxQ, MatrixStore<?> mtrxC) {
            this.setObjective(BasePrimitiveSolver.toObjectiveFunction(mtrxQ, mtrxC));
            return this;
        }

        public Builder quadratic(Access2D<?> factors) {
            ((ConvexObjectiveFunction)this.getObjective()).quadratic().fillMatching(factors);
            return this;
        }

        public LinearSolver.GeneralBuilder toFeasibilityChecker() {
            MatrixStore<Double> mtrxAE = this.getAE();
            MatrixStore<Double> mtrxBE = this.getBE();
            MatrixStore<Double> mtrxAI = this.getAI();
            MatrixStore<Double> mtrxBI = this.getBI();
            LinearSolver.GeneralBuilder retVal = LinearSolver.newGeneralBuilder();
            int nbEqus = this.countEqualityConstraints();
            int nbIneq = this.countInequalityConstraints();
            int nbVars = this.countVariables();
            MatrixStore<Double> rhs = Primitive64Store.FACTORY.makeZero(nbVars, 1L);
            if (nbEqus > 0) {
                Matrix2D transpAE = mtrxAE.transpose();
                if (nbIneq > 0) {
                    retVal.objective(mtrxBE.below((Access2D<Double>)mtrxBE.negate()).below((Access2D<Double>)mtrxBI));
                    retVal.equalities((Access2D)transpAE.right(transpAE.negate()).right(mtrxAI.transpose()), rhs);
                } else {
                    retVal.objective(mtrxBE.below((Access2D<Double>)mtrxBE.negate()));
                    retVal.equalities((Access2D)transpAE.right(transpAE.negate()), rhs);
                }
            } else if (nbIneq > 0) {
                retVal.objective(mtrxBI);
                retVal.equalities((Access2D)mtrxAI.transpose(), rhs);
            } else {
                throw new IllegalStateException("The problem is unconstrained!");
            }
            return retVal;
        }

        public LinearSolver.GeneralBuilder toLinearApproximation() {
            return this.toLinearApproximation(ArrayR064.make(this.countVariables()));
        }

        public LinearSolver.GeneralBuilder toLinearApproximation(Access1D<Double> point) {
            MatrixStore<Double> mtrxC = this.getObjective().toFirstOrderApproximation(point).getLinearFactors(false);
            MatrixStore<Double> mtrxAE = this.getAE();
            MatrixStore<Double> mtrxBE = this.getBE();
            MatrixStore<Double> mtrxAI = this.getAI();
            MatrixStore<Double> mtrxBI = this.getBI();
            LinearSolver.GeneralBuilder retVal = LinearSolver.newGeneralBuilder();
            retVal.objective(mtrxC.below((Access2D<Double>)mtrxC.negate()));
            if (mtrxAE != null && mtrxBE != null) {
                retVal.equalities(mtrxAE.right((Access2D<Double>)mtrxAE.negate()), mtrxBE);
            }
            if (mtrxAI != null && mtrxBI != null) {
                retVal.inequalities(mtrxAI.right((Access2D<Double>)mtrxAI.negate()), mtrxBI);
            }
            return retVal;
        }

        @Override
        protected void append(StringBuilder builder) {
            super.append(builder);
            GenericSolver.Builder.append(builder, "Q", this.getQ());
        }

        @Override
        protected ConvexSolver doBuild(Optimisation.Options options) {
            if (options.convex().isExtendedPrecision()) {
                ConvexData<Quadruple> data = this.getConvexData(GenericStore.R128);
                return new IterativeRefinementSolver(options, data);
            }
            ConvexData<Double> data = this.getConvexData(Primitive64Store.FACTORY);
            return BasePrimitiveSolver.newSolver(data, options);
        }

        protected PhysicalStore<Double> getC() {
            return ((ConvexObjectiveFunction)this.getObjective()).linear();
        }

        protected <N extends Comparable<N>> ConvexData<N> getConvexData(PhysicalStore.Factory<N, ?> factory) {
            int i;
            int nbVars = this.countVariables();
            int nbEqus = this.countEqualityConstraints();
            int nbIneq = this.countInequalityConstraints();
            ConvexData<N> retVal = new ConvexData<N>(factory, nbVars, nbEqus, nbIneq);
            ((ConvexObjectiveFunction)retVal.getObjective()).linear().fillMatching(((ConvexObjectiveFunction)this.getObjective()).linear());
            ((ConvexObjectiveFunction)retVal.getObjective()).quadratic().fillMatching(((ConvexObjectiveFunction)this.getObjective()).quadratic());
            for (i = 0; i < nbEqus; ++i) {
                for (SparseArray.NonzeroView nz : this.getAE(i).nonzeros()) {
                    retVal.setAE(i, (int)nz.index(), nz.doubleValue());
                }
                retVal.setBE(i, this.getBE(i));
            }
            for (i = 0; i < nbIneq; ++i) {
                for (SparseArray.NonzeroView nz : this.getAI(i).nonzeros()) {
                    retVal.setAI(i, (int)nz.index(), nz.doubleValue());
                }
                retVal.setBI(i, this.getBI(i));
            }
            return retVal;
        }

        protected PhysicalStore<Double> getQ() {
            return ((ConvexObjectiveFunction)this.getObjective()).quadratic();
        }
    }
}

