/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.Collection;
import java.util.Collections;
import org.ojalgo.array.SparseArray;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ColumnsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.LinearStructure;
import org.ojalgo.optimisation.linear.ProductFormInverse;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.optimisation.linear.SimplexStore;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.type.context.NumberContext;

final class RevisedStore
extends SimplexStore {
    private final PhysicalStore<Double> a;
    private final PhysicalStore<Double> d;
    private final PhysicalStore<Double> l;
    private final MatrixStore<Double> myBasis;
    private final ColumnsSupplier<Double> myConstraintsBody;
    private final ColumnsSupplier.SingleView<Double> myConstraintsColumn;
    private final Primitive64Store myConstraintsRHS;
    private Primitive64Store myCopiedObjective = null;
    private final ProductFormInverse myInvBasis;
    private final Primitive64Store myObjective = RevisedStore.newColumn(this.n);
    private final PhysicalStore<Double> r;
    private final PhysicalStore<Double> x;
    private final PhysicalStore<Double> y;
    private final PhysicalStore<Double> z;

    private static Primitive64Store newColumn(int nbRows) {
        return (Primitive64Store)Primitive64Store.FACTORY.makeDense(nbRows, 1L);
    }

    private static ColumnsSupplier<Double> newMatrix(int nbRows, int nbCols) {
        ColumnsSupplier<Double> retVal = Primitive64Store.FACTORY.makeColumnsSupplier(nbRows);
        retVal.addColumns(nbCols);
        return retVal;
    }

    private static Primitive64Store newRow(int nbCols) {
        return (Primitive64Store)Primitive64Store.FACTORY.makeDense(1L, nbCols);
    }

    static RevisedStore build(ExpressionsBasedModel model) {
        return SimplexStore.build(model, RevisedStore::new);
    }

    static RevisedStore build(LinearSolver.GeneralBuilder builder, int ... basis) {
        return SimplexStore.build(builder, RevisedStore::new, basis);
    }

    RevisedStore(int mm, int nn) {
        this(new LinearStructure(mm, nn));
    }

    RevisedStore(LinearStructure structure) {
        super(structure);
        this.myConstraintsBody = RevisedStore.newMatrix(this.m, this.n);
        this.myConstraintsRHS = RevisedStore.newColumn(this.m);
        this.myConstraintsColumn = this.myConstraintsBody.columns();
        this.x = RevisedStore.newColumn(this.m);
        this.y = RevisedStore.newColumn(this.m);
        this.z = RevisedStore.newColumn(this.m);
        this.l = RevisedStore.newColumn(this.m);
        this.d = RevisedStore.newColumn(this.n - this.m);
        this.a = RevisedStore.newColumn(this.n - this.m);
        this.r = RevisedStore.newColumn(this.n - this.m);
        this.myBasis = this.myConstraintsBody.columns(this.included);
        this.myInvBasis = new ProductFormInverse(this.m, PrimitiveMath.TWO_THIRDS);
    }

    private void doExclTranspMult(MatrixStore<Double> lambda, PhysicalStore<Double> results) {
        for (int je = 0; je < this.excluded.length; ++je) {
            this.myConstraintsColumn.goToColumn(this.excluded[je]);
            results.set((long)je, this.myConstraintsColumn.dot(lambda));
        }
    }

    @Override
    protected void pivot(SimplexSolver.IterDescr iteration) {
        int iterExitInd = iteration.exit.index;
        SparseArray<Double> iterEnterCol = this.myConstraintsBody.getColumn(iteration.enter.column());
        super.pivot(iteration);
        this.myInvBasis.update(this.myBasis, iterExitInd, iterEnterCol);
    }

    @Override
    protected void shiftColumn(int col, double shift) {
        super.shiftColumn(col, shift);
        this.myConstraintsBody.column(col).axpy(-shift, this.myConstraintsRHS);
        this.myInvBasis.ftran(this.myConstraintsRHS, this.x);
    }

    @Override
    void calculateDualDirection(SimplexSolver.ExitInfo exit) {
        this.z.reset();
        this.z.set((long)exit.index, 1.0);
        this.myInvBasis.btran(this.z);
        this.doExclTranspMult(this.z, this.a);
    }

    @Override
    void calculateIteration() {
        this.myInvBasis.btran(this.myObjective.rows(this.included), this.l);
        this.doExclTranspMult(this.l, this.r);
        this.d.fillMatching(this.myObjective.rows(this.excluded), PrimitiveMath.SUBTRACT, this.r);
        this.myInvBasis.ftran(this.myConstraintsRHS, this.x);
    }

    @Override
    void calculateIteration(SimplexSolver.IterDescr iteration) {
        this.myInvBasis.btran(this.myObjective.rows(this.included), this.l);
        this.doExclTranspMult(this.l, this.r);
        this.d.fillMatching(this.myObjective.rows(this.excluded), PrimitiveMath.SUBTRACT, this.r);
        this.myInvBasis.ftran(this.myConstraintsRHS, this.x);
    }

    @Override
    void calculatePrimalDirection(SimplexSolver.EnterInfo enter) {
        this.myConstraintsColumn.goToColumn(enter.column());
        this.myInvBasis.ftran(this.myConstraintsColumn, this.y);
    }

    @Override
    Mutate2D constraintsBody() {
        return this.myConstraintsBody;
    }

    @Override
    Mutate1D constraintsRHS() {
        return this.myConstraintsRHS;
    }

    @Override
    void copyBasicSolution(double[] solution) {
        for (int ji = 0; ji < this.included.length; ++ji) {
            int j = this.included[ji];
            solution[j] = this.x.doubleValue(ji);
        }
    }

    @Override
    void copyObjective() {
        this.myCopiedObjective = this.myObjective.copy();
    }

    @Override
    double extractValue() {
        double retVal = PrimitiveMath.ZERO;
        double[] solution = this.extractSolution();
        for (int i = 0; i < solution.length; ++i) {
            retVal += solution[i] * this.myObjective.doubleValue((long)i);
        }
        return retVal;
    }

    @Override
    double getCost(int j) {
        return this.myObjective.doubleValue((long)j);
    }

    @Override
    double getInfeasibility(int i) {
        int ii = this.included[i];
        double xi = this.x.doubleValue(i);
        double lb = this.getLowerBound(ii);
        double ub = this.getUpperBound(ii);
        if (xi < lb) {
            return xi - lb;
        }
        if (xi > ub) {
            return xi - ub;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    double getReducedCost(int je) {
        return this.d.doubleValue(je);
    }

    @Override
    double getTableauElement(SimplexSolver.ExitInfo exit, int je) {
        return this.a.doubleValue(je);
    }

    @Override
    double getTableauElement(int i, SimplexSolver.EnterInfo enter) {
        return this.y.doubleValue(i);
    }

    @Override
    double getTableauRHS(int i) {
        return this.x.doubleValue(i);
    }

    @Override
    Mutate1D objective() {
        return this.myObjective;
    }

    @Override
    void resetBasis(int[] basis) {
        super.resetBasis(basis);
        this.myInvBasis.reset(this.myBasis);
    }

    @Override
    void restoreObjective() {
        this.myObjective.fillMatching(this.myCopiedObjective);
        this.myCopiedObjective = null;
    }

    @Override
    Collection<Equation> generateCutCandidates(boolean[] integer, NumberContext accuracy, double fractionality) {
        return Collections.emptySet();
    }
}

