/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.SampleSet;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.structure.Access1D;

public interface RandomProcess<D extends Distribution> {
    public D getDistribution(double var1);

    public SimulationResults simulate(int var1, int var2, double var3);

    public static final class SimulationResults {
        private final double myInitialValue;
        private final Array2D<Double> myResults;

        public SimulationResults(double initialValue, Array2D<Double> results) {
            this.myInitialValue = initialValue;
            this.myResults = results;
        }

        public int countSampleSets() {
            return this.myResults.getColDim();
        }

        public int countScenarios() {
            return this.myResults.getRowDim();
        }

        public double getInitialValue() {
            return this.myInitialValue;
        }

        public SampleSet getSampleSet(int sampleSetIndex) {
            return SampleSet.wrap(this.myResults.sliceColumn(sampleSetIndex));
        }

        public PrimitiveSeries getScenario(int scenarioIndex) {
            Access1D slicedRow = this.myResults.sliceRow(scenarioIndex);
            return new PrimitiveSeries((Array1D)slicedRow){
                final /* synthetic */ Array1D val$slicedRow;
                {
                    this.val$slicedRow = array1D;
                }

                @Override
                public int size() {
                    return this.val$slicedRow.size() + 1;
                }

                @Override
                public double value(int index) {
                    if (index == 0) {
                        return myInitialValue;
                    }
                    return this.val$slicedRow.doubleValue(index - 1);
                }
            };
        }
    }
}

