/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ojalgo.type.function.AutoSupplier;

final class SupplierIterator<T>
implements Iterator<T> {
    private transient T myNext;
    private final AutoSupplier<T> mySupplier;

    SupplierIterator(AutoSupplier<T> supplier) {
        this.mySupplier = supplier;
        this.myNext = this.mySupplier.get();
    }

    @Override
    public boolean hasNext() {
        return this.myNext != null;
    }

    @Override
    public T next() {
        if (this.myNext == null) {
            throw new NoSuchElementException();
        }
        T retVal = this.myNext;
        this.myNext = this.mySupplier.get();
        return retVal;
    }
}

