/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command;

import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mgfboost.ui.command.AbstractCommand;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.OutputFilePanel;
import fr.profi.mgfboost.ui.command.ui.PCleanMgfPanel;
import fr.profi.mgfboost.ui.model.MS2Collection;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.MGFProcessing;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCleanMgfCommand
extends AbstractCommand<CommandArguments.PCleanCommand> {
    private static final Logger logger = LoggerFactory.getLogger(PCleanMgfCommand.class);

    public PCleanMgfCommand() {
        this.command = new CommandArguments.PCleanCommand();
    }

    @Override
    public MS2Collection execute(File ... files) throws Exception {
        ((CommandArguments.PCleanCommand)this.command).mgf = files[0].getAbsolutePath();
        String originalOutFilePath = ((CommandArguments.PCleanCommand)this.command).outputFileName;
        if (this.commandType.equals((Object)AbstractCommand.CommandType.BATCH_INPUT)) {
            ((CommandArguments.PCleanCommand)this.command).outputFileName = PCleanMgfCommand.getDestFile(files[0], ((CommandArguments.PCleanCommand)this.command).outputFileName, ".mgf").getAbsolutePath();
        }
        logger.info("Execute command " + this.getCommandName() + " on " + Arrays.stream(files).map(f -> f.getName()).collect(Collectors.joining()));
        logger.info("Command args : " + ToStringBuilder.reflectionToString((Object)this.command));
        MGFProcessing.pCleanMgf((CommandArguments.PCleanCommand)((CommandArguments.PCleanCommand)this.command));
        MS2Collection ms2Collection = new MS2Collection(new File(((CommandArguments.PCleanCommand)this.command).outputFileName), MainPanel.FileType.MGF);
        ((CommandArguments.PCleanCommand)this.command).outputFileName = originalOutFilePath;
        return ms2Collection;
    }

    @Override
    public ICommand.ExecutionMode getExecutionMode() {
        return ICommand.ExecutionMode.BATCH_OF_SINGLE_FILES;
    }

    @Override
    protected AbstractCommandPanel<CommandArguments.PCleanCommand> getConfigurationPanel() {
        if (this.configurationPanel == null) {
            this.configurationPanel = new PCleanMgfPanel().updatePanelFromCommand((CommandArguments.PCleanCommand)this.command);
        }
        return this.configurationPanel;
    }

    @Override
    public AbstractCommandPanel<CommandArguments.PCleanCommand> getConfigurationPanel(List<MS2Collection> selectedCollections) {
        this.commandType = selectedCollections.size() > 1 ? AbstractCommand.CommandType.BATCH_INPUT : AbstractCommand.CommandType.SINGLE_INPUT;
        this.configurationPanel = new PCleanMgfPanel().updatePanelFromCommand((CommandArguments.PCleanCommand)this.command);
        this.configurationPanel.setOutputRootFolder(selectedCollections.get(0).getFile().getParentFile());
        this.configurationPanel.setOutputType(selectedCollections.size() > 1 ? OutputFilePanel.OutputType.FOLDER : OutputFilePanel.OutputType.FILE);
        return this.configurationPanel;
    }
}

