/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command.ui;

import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.OutputFilePanel;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.mgf.MGFECleaner;
import fr.profi.mzknife.mgf.PCleanConfigTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCleanMgfPanel
extends AbstractCommandPanel<CommandArguments.PCleanCommand> {
    private static final Logger logger = LoggerFactory.getLogger(PCleanMgfPanel.class);
    private JTextField iTolTF;
    private JCheckBox aa2Cbx;
    private JCheckBox imonCbx;
    private JComboBox labelMethodCombo;
    private JCheckBox reporterFilterCbx;
    private JCheckBox labelFilterCbx;
    private JCheckBox lowFilterCbx;
    private JCheckBox highFilterCbx;
    private JCheckBox isoReductionCbx;
    private JCheckBox chargeDeconvolutionCbx;
    private JCheckBox mergeIonsCbx;
    private JCheckBox largerThanPrecursorCbx;

    public PCleanMgfPanel() {
        this.initComponents();
    }

    @Override
    public AbstractCommandPanel<CommandArguments.PCleanCommand> updatePanelFromCommand(CommandArguments.PCleanCommand command) {
        this.iTolTF.setText(command.itol.toString());
        this.aa2Cbx.setSelected(command.aa2);
        this.imonCbx.setSelected(command.ionFilter);
        this.reporterFilterCbx.setSelected(command.repFilter);
        this.labelFilterCbx.setSelected(command.labelFilter);
        this.lowFilterCbx.setSelected(command.low);
        this.highFilterCbx.setSelected(command.high);
        this.isoReductionCbx.setSelected(command.isoReduction);
        this.chargeDeconvolutionCbx.setSelected(command.chargeDeconv);
        this.largerThanPrecursorCbx.setSelected(command.largerThanPrecursor);
        this.mergeIonsCbx.setSelected(command.ionsMerge);
        this.labelMethodCombo.setSelectedItem(command.labelMethod == null || command.labelMethod.isEmpty() ? "None" : command.labelMethod);
        return this;
    }

    @Override
    public boolean buildCommand(CommandArguments.PCleanCommand command) {
        command.outputFileName = this.outputFilePanel.getOutputFilepath();
        command.itol = Double.parseDouble(this.iTolTF.getText().trim());
        command.aa2 = this.aa2Cbx.isSelected();
        command.ionFilter = this.imonCbx.isSelected();
        command.repFilter = this.reporterFilterCbx.isSelected();
        command.labelFilter = this.labelFilterCbx.isSelected();
        command.low = this.lowFilterCbx.isSelected();
        command.high = this.highFilterCbx.isSelected();
        command.isoReduction = this.isoReductionCbx.isSelected();
        command.chargeDeconv = this.chargeDeconvolutionCbx.isSelected();
        command.largerThanPrecursor = this.largerThanPrecursorCbx.isSelected();
        command.ionsMerge = this.mergeIonsCbx.isSelected();
        String methodName = (String)this.labelMethodCombo.getSelectedItem();
        command.labelMethod = methodName.equalsIgnoreCase("none") ? null : methodName.toUpperCase();
        return true;
    }

    private void initComponents() {
        JPanel globalParamsPanel = new JPanel();
        this.iTolTF = new JTextField();
        this.aa2Cbx = new JCheckBox();
        this.imonCbx = new JCheckBox();
        JPanel module1ParamsPanel = new JPanel();
        List labelingMethods = Arrays.stream(MGFECleaner.IsobaricTag.values()).map(v -> v.name()).collect(Collectors.toList());
        labelingMethods.add(0, "None");
        String[] labelingMethodValues = (String[])labelingMethods.toArray(String[]::new);
        this.labelMethodCombo = new JComboBox<String>(labelingMethodValues);
        this.reporterFilterCbx = new JCheckBox();
        this.labelFilterCbx = new JCheckBox();
        this.lowFilterCbx = new JCheckBox();
        this.highFilterCbx = new JCheckBox();
        JPanel module2ParamsPanel = new JPanel();
        this.isoReductionCbx = new JCheckBox();
        this.chargeDeconvolutionCbx = new JCheckBox();
        this.mergeIonsCbx = new JCheckBox();
        this.largerThanPrecursorCbx = new JCheckBox();
        this.labelMethodCombo.addActionListener(e -> this.updateModule1ParametersStatus());
        this.labelMethodCombo.setSelectedIndex(0);
        this.setLayout(new GridBagLayout());
        Insets defaultInsets = new Insets(0, 5, 0, 5);
        GridBagConstraints insidePanelGBC = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, defaultInsets, 0, 0);
        GridBagConstraints globalPanelGBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        globalPanelGBC.gridx = 0;
        globalPanelGBC.gridy = 0;
        this.outputFilePanel = new OutputFilePanel();
        this.add((Component)this.outputFilePanel, globalPanelGBC);
        ++globalPanelGBC.gridy;
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        JPanel templatePanel = new JPanel();
        templatePanel.setBorder(new TitledBorder("configuration template"));
        templatePanel.setLayout(new GridBagLayout());
        insidePanelGBC.weightx = 0.0;
        JButton templateBtn = new JButton("load template");
        templateBtn.addActionListener(e -> {
            Object[] templateValues = (String[])Arrays.stream(CommandArguments.CleanConfig.values()).map(v -> v.getDisplayValue()).toArray(String[]::new);
            String selectedOption = (String)JOptionPane.showInputDialog(this, "configuration template :", "Choose configuration template", 3, null, templateValues, templateValues[0]);
            if (selectedOption != null) {
                this.updateCleanConfiguration(CommandArguments.CleanConfig.getConfigFromDisplayValue((String)selectedOption));
            }
        });
        templatePanel.add((Component)templateBtn, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.gridwidth = 2;
        this.add((Component)templatePanel, globalPanelGBC);
        ++globalPanelGBC.gridy;
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        insidePanelGBC.gridwidth = 1;
        insidePanelGBC.weightx = 0.0;
        globalParamsPanel.setBorder(new TitledBorder("global parameters"));
        globalParamsPanel.setLayout(new GridBagLayout());
        JLabel label2 = new JLabel("m/z fragments tolerance (Da):");
        globalParamsPanel.add((Component)label2, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        globalParamsPanel.add((Component)this.iTolTF, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.anchor = 17;
        insidePanelGBC.gridwidth = 2;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 0;
        this.aa2Cbx.setText("consider mass gap of two AA");
        globalParamsPanel.add((Component)this.aa2Cbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.imonCbx.setText("filter immonium ions");
        globalParamsPanel.add((Component)this.imonCbx, insidePanelGBC);
        this.add((Component)globalParamsPanel, globalPanelGBC);
        ++globalPanelGBC.gridy;
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        insidePanelGBC.gridwidth = 1;
        insidePanelGBC.weightx = 0.0;
        module1ParamsPanel.setBorder(new TitledBorder("module1 parameters"));
        module1ParamsPanel.setLayout(new GridBagLayout());
        JLabel label3 = new JLabel("label method:");
        module1ParamsPanel.add((Component)label3, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        module1ParamsPanel.add((Component)this.labelMethodCombo, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.gridwidth = 2;
        insidePanelGBC.anchor = 17;
        this.reporterFilterCbx.setText("filter reporter ions");
        module1ParamsPanel.add((Component)this.reporterFilterCbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.labelFilterCbx.setText("filter label-associated ions");
        module1ParamsPanel.add((Component)this.labelFilterCbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.lowFilterCbx.setText("clear low b/y-ion window");
        module1ParamsPanel.add((Component)this.lowFilterCbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.highFilterCbx.setText("clear high b/y-ions window");
        module1ParamsPanel.add((Component)this.highFilterCbx, insidePanelGBC);
        this.add((Component)module1ParamsPanel, globalPanelGBC);
        ++globalPanelGBC.gridy;
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        module2ParamsPanel.setBorder(new TitledBorder("module2 parameters"));
        module2ParamsPanel.setLayout(new GridBagLayout());
        this.isoReductionCbx.setText("do isotopic reduction");
        module2ParamsPanel.add((Component)this.isoReductionCbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.chargeDeconvolutionCbx.setText("do charge deconvolution");
        module2ParamsPanel.add((Component)this.chargeDeconvolutionCbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.mergeIonsCbx.setText("merge ions of similar masses");
        module2ParamsPanel.add((Component)this.mergeIonsCbx, insidePanelGBC);
        ++insidePanelGBC.gridy;
        this.largerThanPrecursorCbx.setText("filter ions larger than precursor\u2019s mass");
        module2ParamsPanel.add((Component)this.largerThanPrecursorCbx, insidePanelGBC);
        this.add((Component)module2ParamsPanel, globalPanelGBC);
    }

    private void updateCleanConfiguration(CommandArguments.CleanConfig cleanConfig) {
        PCleanConfigTemplate pCleanConfigTemplate = cleanConfig.getPCleanConfigTemplate();
        this.iTolTF.setText(Double.toString(0.05));
        this.aa2Cbx.setSelected(false);
        this.imonCbx.setSelected(pCleanConfigTemplate.getImonFilter());
        this.reporterFilterCbx.setSelected(pCleanConfigTemplate.getRepFilter());
        this.labelFilterCbx.setSelected(pCleanConfigTemplate.getLabelFilter());
        this.lowFilterCbx.setSelected(pCleanConfigTemplate.getLowWinFilter());
        this.highFilterCbx.setSelected(pCleanConfigTemplate.getHighWinFilter());
        this.isoReductionCbx.setSelected(pCleanConfigTemplate.getIsoReduction());
        this.chargeDeconvolutionCbx.setSelected(pCleanConfigTemplate.getChargeDeconv());
        this.largerThanPrecursorCbx.setSelected(pCleanConfigTemplate.getLargerThanPrecursor());
        this.mergeIonsCbx.setSelected(pCleanConfigTemplate.getIonsMerge());
        this.labelMethodCombo.setSelectedItem("None");
    }

    private void updateModule1ParametersStatus() {
        boolean labelMethod = !((String)this.labelMethodCombo.getSelectedItem()).equalsIgnoreCase("none");
        this.reporterFilterCbx.setEnabled(labelMethod);
        this.labelFilterCbx.setEnabled(labelMethod);
        this.lowFilterCbx.setEnabled(labelMethod);
        this.highFilterCbx.setEnabled(labelMethod);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setLayout(new BorderLayout());
        f.getContentPane().add((Component)new PCleanMgfPanel(), "Center");
        f.pack();
        f.setDefaultCloseOperation(3);
        EventQueue.invokeLater(() -> f.setVisible(true));
    }
}

