/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;

public class IsolationWindow
implements SerializationInterface {
    private double minMz;
    private double maxMz;

    public IsolationWindow(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public IsolationWindow(double minMz, double maxMz) {
        this.minMz = minMz;
        this.maxMz = maxMz;
    }

    public double getMinMz() {
        return this.minMz;
    }

    public double getMaxMz() {
        return this.maxMz;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxMz);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minMz);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IsolationWindow other = (IsolationWindow)obj;
        if (Double.doubleToLongBits(this.maxMz) != Double.doubleToLongBits(other.maxMz)) {
            return false;
        }
        return Double.doubleToLongBits(this.minMz) == Double.doubleToLongBits(other.minMz);
    }

    public String toString() {
        return "IsolationWindow [minMz=" + this.minMz + ", maxMz=" + this.maxMz + "]";
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        writer.writeDouble(this.minMz);
        writer.writeDouble(this.maxMz);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        this.minMz = reader.readDouble();
        this.maxMz = reader.readDouble();
    }
}

