/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util;

import fr.profi.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    public static final String LINE_SEPARATOR = StringUtils.getLineSeparator();
    public static final String NULL = "NULL";
    private static final String LINE_SEPARATOR_KEY = "line.separator";

    private StringUtils() {
    }

    public static boolean isEmpty(String s) {
        boolean empty = true;
        if (s != null) {
            int stringLength = s.length();
            for (int index = 0; empty && index < stringLength; ++index) {
                empty = Character.isWhitespace(s.charAt(index));
            }
        }
        return empty;
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean isTerminated(CharSequence cs, char term) {
        boolean terminated = false;
        if (cs != null) {
            int length = cs.length();
            terminated = length > 0 && cs.charAt(length - 1) == term;
        }
        return terminated;
    }

    public static String convertCharResidueToString(char residue) {
        String result = null;
        if (residue != '\u0000') {
            result = Character.toString(residue);
        }
        return result;
    }

    public static char convertStringResidueToChar(String strResidue) {
        char result = '\u0000';
        if (!StringUtils.isEmpty(strResidue)) {
            result = strResidue.charAt(0);
        }
        return result;
    }

    private static String getLineSeparator() {
        String result = null;
        try {
            result = System.getProperty(LINE_SEPARATOR_KEY);
        }
        catch (Exception ex) {
            LOG.error("Unable to retrieve System property \"line.separator\"", (Throwable)ex);
        }
        if (result == null) {
            result = "\n";
        }
        return result;
    }
}

