/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdbconverter;

import fr.profi.mzdb.server.MzdbServerMain;
import fr.profi.mzdbconverter.MzDBConverterMain;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Thermo2Mzdb {
    private static final Logger LOGGER = LoggerFactory.getLogger(MzDBConverterMain.class);

    public static void main(String[] argv) {
        int port = 8090;
        int portSpecifiedIndex = -1;
        for (int i = 0; i < argv.length - 1; ++i) {
            String param = argv[i];
            if (!param.equals("-p") && !param.equals("--port")) continue;
            portSpecifiedIndex = i + 1;
            port = Integer.parseInt(argv[portSpecifiedIndex]);
        }
        int portMax = port + 100;
        boolean available = false;
        while (port <= portMax && !(available = Thermo2Mzdb.isPortAvailable(port))) {
            ++port;
        }
        if (!available) {
            LOGGER.error("No port available between" + port + "and " + portMax);
            return;
        }
        final String[] args = new String[]{Integer.toString(port)};
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                MzdbServerMain.main(args);
            }
        });
        t.setDaemon(false);
        t.start();
        Object dirName = "";
        try {
            Properties properties = new Properties();
            properties.load(MzDBConverterMain.class.getResourceAsStream("mzdbServerConverter.properties"));
            String version = properties.getProperty("thermoaccess.version", "");
            String classifier = properties.getProperty("thermoaccess.classifier", "");
            dirName = "ThermoAccess-" + version + "-" + classifier;
        }
        catch (Exception e) {
            LOGGER.warn("error in addMzdbMetaData : can not get current version");
        }
        File pathFile = new File(".\\target\\unzip-dependencies\\" + (String)dirName + "\\");
        if (!pathFile.exists()) {
            pathFile = new File(".\\" + (String)dirName + "\\");
        }
        String absolutePath = pathFile.getAbsolutePath() + "\\ThermoAccess.exe";
        System.out.println("Thermo Access : " + absolutePath);
        ArrayList<String> cmds = new ArrayList<String>(3 + argv.length);
        cmds.add(absolutePath);
        if (portSpecifiedIndex != -1) {
            argv[portSpecifiedIndex] = String.valueOf(port);
        } else {
            cmds.add("-p");
            cmds.add(String.valueOf(port));
        }
        cmds.addAll(Arrays.asList(argv));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.redirectErrorStream(true);
        pb.directory(pathFile);
        try {
            String line;
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                LOGGER.info(line);
            }
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                LOGGER.error(String.valueOf(cmds) + " abnormally finished with exitCode " + exitCode);
                LOGGER.info("Interrupt socket server");
                MzdbServerMain.interrupt();
                System.exit(exitCode);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(cmds) + " abnormally finished");
            LOGGER.error(e.getMessage(), (Throwable)e);
            LOGGER.info("Interrupt socket server");
            MzdbServerMain.interrupt();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortAvailable(int port) {
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
            datagramSocket = new DatagramSocket(port);
            datagramSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

