/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.DotProductPatternScorer$;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.SpectrumData;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DotProductPatternScorerV1$
implements IIsotopicPatternScorer {
    public static DotProductPatternScorerV1$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DotProductPatternScorerV1$();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypotheses$(this, spectrum, mz, ppmTol);
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypothesesFromCharge(SpectrumData spectrum, double mz, int charge, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypothesesFromCharge$(this, spectrum, mz, charge, ppmTol);
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public final void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    private Logger logger$lzycompute() {
        DotProductPatternScorerV1$ dotProductPatternScorerV1$ = this;
        synchronized (dotProductPatternScorerV1$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(mz, charge);
        double scale = (double)spectrum.getIntensityList()[spectrum.getNearestPeakIndex(initialMz)] / (double)BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[isotopicShift]._2());
        DoubleRef ipMoz = DoubleRef.create((double)mz);
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)rank -> {
            ipMoz$3.elem = rank == 0 ? ipMoz$3.elem : ipMoz$3.elem + 1.0027 / (double)charge;
            int nearestPeakIdx = spectrum.getNearestPeakIndex(ipMoz$3.elem);
            observed$2[rank] = 1000000.0 * Math.abs(spectrum.getMzList()[nearestPeakIdx] - ipMoz$3.elem) / ipMoz$3.elem < ppmTol ? (double)spectrum.getIntensityList()[nearestPeakIdx] : (double)(-BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2())) * scale;
            expected$2[rank] = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2());
        });
        score = this.dotProduct(observed, expected);
        score = 1.0 - score;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)pattern);
    }

    public double dotProduct(double[] observed, double[] expected) {
        double sumObserved = 0.0;
        double sumExpected = 0.0;
        double product = 0.0;
        double[] weights = new double[]{0.25, 0.25, 0.25, 0.08, 0.06, 0.05, 0.04, 0.02};
        for (int k = 0; k < observed.length && expected[k] > 0.1; ++k) {
            double weight = k < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).size() ? weights[k] : 0.0;
            product += weight * observed[k] * expected[k];
            sumExpected += weight * expected[k] * expected[k];
            sumObserved += weight * observed[k] * observed[k];
        }
        return sumExpected == 0.0 || sumObserved == 0.0 ? 0.0 : product / (Math.sqrt(sumExpected) * Math.sqrt(sumObserved));
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        return DotProductPatternScorer$.MODULE$.selectBestPatternHypothese(putativePatterns, deltaScore);
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    private DotProductPatternScorerV1$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        IIsotopicPatternScorer.$init$(this);
    }
}

