/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.server;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.client.MzdbWriterApi;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.serialization.SerializationReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MzdbController.class);
    private MzdbWriterApi m_mzdbWriterApi = null;
    private static long id = -1L;

    public String initializeMzdb(SerializationReader reader) {
        this.m_mzdbWriterApi = new MzdbWriterApi();
        try {
            String path = reader.readString();
            AcquisitionMode srcAcqMode = AcquisitionMode.getEnum((SerializationReader)reader);
            return this.m_mzdbWriterApi.initializeMzdb(path, srcAcqMode);
        }
        catch (Exception e) {
            LOGGER.error("error in initializeMzdb", (Throwable)e);
            return "KO:" + e.getMessage();
        }
    }

    public String addMzdbMetaData(SerializationReader reader) {
        try {
            MzDBMetaData mzDbMetaData = new MzDBMetaData();
            mzDbMetaData.read(reader);
            String version = "";
            try {
                Properties properties = new Properties();
                properties.load(MzdbController.class.getResourceAsStream("mzdbServerWriter.properties"));
                version = properties.getProperty("mzdbServer.version", "");
                System.out.println("Mzdb Server Writer Version : " + version);
            }
            catch (Exception e) {
                LOGGER.warn("error in addMzdbMetaData : can not get current version");
            }
            List softwares = mzDbMetaData.getSoftwares();
            int id = softwares.size() + 1;
            Software software = new Software(id, "MzdbServerWriter", version, new ParamTree());
            mzDbMetaData.getSoftwares().add(software);
            return this.m_mzdbWriterApi.addMzdbMetaData(mzDbMetaData);
        }
        catch (Exception e) {
            LOGGER.error("error in addMzdbMetaData", (Throwable)e);
            return "KO:" + e.getMessage();
        }
    }

    public String addspectrum(SerializationReader reader) throws IOException, SQLiteException {
        try {
            Spectrum spectrum = new Spectrum(reader);
            id = spectrum.getHeader().getSpectrumId();
            DataEncoding dataEncoding = new DataEncoding(reader);
            this.m_mzdbWriterApi.addspectrum(spectrum, dataEncoding);
            reader.resetStream();
        }
        catch (Exception e) {
            LOGGER.error("error in addspectrum " + id, (Throwable)e);
            return "KO:" + e.getMessage();
        }
        return "OK";
    }

    public String closedb() {
        return this.m_mzdbWriterApi.closedb();
    }

    public String test(SerializationReader reader) throws IOException, SQLiteException {
        try {
            String r = reader.readString();
            int value = reader.readInt32();
            return "OK:" + r + value;
        }
        catch (IOException e) {
            LOGGER.error("error in test", (Throwable)e);
            return "KO:" + e.getMessage();
        }
    }
}

