/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.bb;

import fr.profi.mzdb.io.reader.bb.IBlobReader;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlobReader
implements IBlobReader {
    static final int FITTED = 20;
    static final int CENTROID = 12;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int _spectraCount;
    protected int[] _spectrumSliceStartPositions;
    protected int[] _peaksCounts;
    protected Map<Long, SpectrumHeader> _spectrumHeaderById;
    protected Map<Long, DataEncoding> _dataEncodingBySpectrumId;

    protected AbstractBlobReader(long firstSpectrumId, long lastSpectrumId, Map<Long, SpectrumHeader> spectrumHeaderById, Map<Long, DataEncoding> dataEncodingBySpectrumId) {
        if (firstSpectrumId > lastSpectrumId) {
            throw new IllegalArgumentException("lastSpectrumId must be greater or the same than firstSpectrumId");
        }
        this._spectrumHeaderById = spectrumHeaderById;
        this._dataEncodingBySpectrumId = dataEncodingBySpectrumId;
    }

    @Override
    public long[] getAllSpectrumIds() {
        int spectraCount = this.getSpectraCount();
        long[] spectrumIds = new long[spectraCount];
        for (int i = 0; i < spectraCount; ++i) {
            spectrumIds[i] = this.getSpectrumIdAt(i);
        }
        return spectrumIds;
    }

    protected SpectrumData readSpectrumSliceData(ByteBuffer bbByteBuffer, int spectrumSliceStartPos, int peaksBytesLength, DataEncoding de, double minMz, double maxMz) {
        DataMode dataMode = de.getMode();
        PeakEncoding pe = de.getPeakEncoding();
        int structSize = de.getPeakStructSize();
        int peaksCount = 0;
        int peaksStartIdx = 0;
        if (minMz < 0.0 && maxMz < 0.0) {
            peaksCount = peaksBytesLength / structSize;
            peaksStartIdx = spectrumSliceStartPos;
        } else {
            double maxMzThreshold = maxMz;
            if (maxMz < 0.0) {
                maxMzThreshold = Double.MAX_VALUE;
            }
            for (int i = 0; i < peaksBytesLength; i += structSize) {
                int peakStartPos = spectrumSliceStartPos + i;
                double mz = 0.0;
                switch (pe) {
                    case HIGH_RES_PEAK: {
                        mz = bbByteBuffer.getDouble(peakStartPos);
                        break;
                    }
                    case LOW_RES_PEAK: {
                        mz = bbByteBuffer.getFloat(peakStartPos);
                        break;
                    }
                    case NO_LOSS_PEAK: {
                        mz = bbByteBuffer.getDouble(peakStartPos);
                    }
                }
                if (!(mz >= minMz) || !(mz <= maxMzThreshold)) continue;
                ++peaksCount;
                if (!(mz >= minMz) || peaksStartIdx != 0) continue;
                peaksStartIdx = peakStartPos;
            }
        }
        bbByteBuffer.position(peaksStartIdx);
        double[] mzArray = new double[peaksCount];
        float[] intensityArray = new float[peaksCount];
        float[] lwhmArray = new float[peaksCount];
        float[] rwhmArray = new float[peaksCount];
        for (int peakIdx = 0; peakIdx < peaksCount; ++peakIdx) {
            switch (pe) {
                case HIGH_RES_PEAK: {
                    mzArray[peakIdx] = bbByteBuffer.getDouble();
                    intensityArray[peakIdx] = bbByteBuffer.getFloat();
                    break;
                }
                case LOW_RES_PEAK: {
                    mzArray[peakIdx] = bbByteBuffer.getFloat();
                    intensityArray[peakIdx] = bbByteBuffer.getFloat();
                    break;
                }
                case NO_LOSS_PEAK: {
                    mzArray[peakIdx] = bbByteBuffer.getDouble();
                    intensityArray[peakIdx] = (float)bbByteBuffer.getDouble();
                }
            }
            if (dataMode != DataMode.FITTED) continue;
            lwhmArray[peakIdx] = bbByteBuffer.getFloat();
            rwhmArray[peakIdx] = bbByteBuffer.getFloat();
        }
        return new SpectrumData(mzArray, intensityArray, lwhmArray, rwhmArray);
    }

    protected void checkSpectrumIndexRange(int idx) {
        if (idx < 0 || idx >= this.getSpectraCount()) {
            throw new IndexOutOfBoundsException("spectrum index out of bounds (idx=" + idx + "), index counting starts at 0");
        }
    }

    protected void checkDataEncodingIsNotNull(DataEncoding de, long spectrumId) throws StreamCorruptedException {
        if (de == null) {
            throw new StreamCorruptedException("Scared that the mzdb file is corrupted, spectrum id is: " + spectrumId);
        }
    }

    @Override
    public SpectrumSlice[] readAllSpectrumSlices(int runSliceId) {
        int spectraCount = this.getSpectraCount();
        SpectrumSlice[] sl = new SpectrumSlice[spectraCount];
        for (int i = 0; i < spectraCount; ++i) {
            SpectrumSlice s = this.readSpectrumSliceAt(i);
            s.setRunSliceId(runSliceId);
            sl[i] = s;
        }
        return sl;
    }
}

