/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.db.model.AbstractTableModel;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.PrecursorList;
import fr.profi.mzdb.db.model.params.ScanList;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.model.ActivationType;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordOperation;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class SpectrumHeader
extends AbstractTableModel
implements ILcContext {
    protected int initialId;
    protected int cycle;
    protected float time;
    protected int msLevel;
    protected String title;
    protected int peaksCount;
    protected boolean isHighResolution;
    protected float tic;
    protected double basePeakMz;
    protected float basePeakIntensity;
    protected ActivationType activationType;
    protected IsolationWindow isolationWindow;
    protected Double precursorMz;
    protected Integer precursorCharge;
    protected int bbFirstSpectrumId;
    protected ScanList scanList = null;
    protected String scanListAsString;
    protected Precursor precursor = null;
    protected PrecursorList precursorList = null;
    protected String precursorAsString;
    protected String paramTreeAsString;
    public static Comparator<SpectrumHeader> rtComp = new Comparator<SpectrumHeader>(){

        @Override
        public int compare(SpectrumHeader o1, SpectrumHeader o2) {
            if (o1.time < o2.time) {
                return -1;
            }
            if ((double)Math.abs(o1.time - o2.time) < 1.0E-6) {
                return 0;
            }
            return 1;
        }
    };

    public SpectrumHeader(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public SpectrumHeader(long id, int initialId, int cycle, float time, int msLevel, String title, int peaksCount, boolean isHighResolution, float tic, double basePeakMz, float basePeakIntensity, Double precursorMz, Integer precursorCharge, int firstBBSpectrumId, ActivationType activationType) {
        super(id, null);
        this.initialId = initialId;
        this.cycle = cycle;
        this.time = time;
        this.msLevel = msLevel;
        this.title = title;
        this.peaksCount = peaksCount;
        this.isHighResolution = isHighResolution;
        this.tic = tic;
        this.basePeakMz = basePeakMz;
        this.basePeakIntensity = basePeakIntensity;
        this.precursorMz = precursorMz;
        this.precursorCharge = precursorCharge;
        this.bbFirstSpectrumId = firstBBSpectrumId;
        this.activationType = activationType;
        this.isolationWindow = null;
    }

    public int getInitialId() {
        return this.initialId;
    }

    public int getCycle() {
        return this.cycle;
    }

    public float getTime() {
        return this.time;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public int getPeaksCount() {
        return this.peaksCount;
    }

    public boolean isHighResolution() {
        return this.isHighResolution;
    }

    public double getBasePeakMz() {
        return this.basePeakMz;
    }

    public float getBasePeakIntensity() {
        return this.basePeakIntensity;
    }

    public Double getPrecursorMz() {
        return this.precursorMz;
    }

    public Integer getPrecursorCharge() {
        return this.precursorCharge;
    }

    @Override
    public long getSpectrumId() {
        return this.id;
    }

    @Override
    public float getElutionTime() {
        return this.time;
    }

    public String getTitle() {
        return this.title;
    }

    public ActivationType getActivationType() {
        return this.activationType;
    }

    public IsolationWindow getIsolationWindow() {
        return this.isolationWindow;
    }

    public void setIsolationWindow(IsolationWindow isolationWindow) {
        this.isolationWindow = isolationWindow;
    }

    public int getBBFirstSpectrumId() {
        return this.bbFirstSpectrumId;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public void setScanList(ScanList scanList) {
        this.scanList = scanList;
    }

    public void setScanListAsString(String scanListAsString) {
        this.scanListAsString = scanListAsString;
    }

    public Precursor getPrecursor() {
        return this.precursor;
    }

    public void setPrecursor(Precursor precursor) {
        this.precursor = precursor;
    }

    public void setPrecursorAsString(String precursorAsString) {
        this.precursorAsString = precursorAsString;
    }

    public void setParamTreeAsString(String paramTreeAsString) {
        this.paramTreeAsString = paramTreeAsString;
    }

    public float getTIC() {
        return this.tic;
    }

    private static Map<Long, String> _loadXmlFieldBySpectrumId(String sqlString, SQLiteConnection mzDbConnection) {
        final HashMap<Long, String> xmlFieldBySpecId = new HashMap<Long, String>();
        try {
            SQLiteQuery query = new SQLiteQuery(mzDbConnection, sqlString);
            final SQLiteStatement stmt = query.getStatement();
            query.forEachRecord(new ISQLiteRecordOperation(){

                @Override
                public void execute(SQLiteRecord elem, int idx) throws SQLiteException {
                    long id = stmt.columnLong(0);
                    String xmlField = stmt.columnString(1);
                    xmlFieldBySpecId.put(id, xmlField);
                }
            });
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        return xmlFieldBySpecId;
    }

    public static void loadParamTrees(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection) {
        SpectrumHeader.loadParamTrees(spectrumHeaders, mzDbConnection, false);
    }

    public static void loadParamTrees(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection, boolean cacheStringRepresentation) {
        String sqlString = "SELECT id, param_tree FROM spectrum";
        Map<Long, String> paramTreeBySpecId = SpectrumHeader._loadXmlFieldBySpectrumId(sqlString, mzDbConnection);
        for (SpectrumHeader header : spectrumHeaders) {
            String paramTreeAsStr;
            if (header.hasParamTree() || (paramTreeAsStr = paramTreeBySpecId.get(header.getId())) == null) continue;
            header.paramTree = ParamTreeParser.parseParamTree(paramTreeAsStr);
            if (!cacheStringRepresentation) continue;
            header.paramTreeAsString = paramTreeAsStr;
        }
    }

    public static void loadScanLists(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection) {
        SpectrumHeader.loadScanLists(spectrumHeaders, mzDbConnection, false);
    }

    public static void loadScanLists(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection, boolean cacheStringRepresentation) {
        String sqlString = "SELECT id, scan_list FROM spectrum";
        Map<Long, String> scanListBySpecId = SpectrumHeader._loadXmlFieldBySpectrumId(sqlString, mzDbConnection);
        for (SpectrumHeader header : spectrumHeaders) {
            String scanListAsStr;
            if (header.scanList != null || (scanListAsStr = scanListBySpecId.get(header.getId())) == null) continue;
            header.scanList = ParamTreeParser.parseScanList(scanListAsStr);
            if (!cacheStringRepresentation) continue;
            header.scanListAsString = scanListAsStr;
        }
    }

    public static void loadPrecursors(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection) {
        SpectrumHeader.loadPrecursors(spectrumHeaders, mzDbConnection, false);
    }

    public static void loadPrecursors(SpectrumHeader[] spectrumHeaders, SQLiteConnection mzDbConnection, boolean cacheStringRepresentation) {
        String sqlString = "SELECT id, precursor_list FROM spectrum";
        Map<Long, String> precursorBySpecId = SpectrumHeader._loadXmlFieldBySpectrumId(sqlString, mzDbConnection);
        for (SpectrumHeader header : spectrumHeaders) {
            String precursorAsStr;
            if (header.precursor != null || (precursorAsStr = precursorBySpecId.get(header.getId())) == null) continue;
            header.precursor = ParamTreeParser.parsePrecursor(precursorAsStr);
            if (!cacheStringRepresentation) continue;
            header.precursorAsString = precursorAsStr;
        }
    }

    @Override
    public void loadParamTree(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (!this.hasParamTree()) {
            String paramTreeAsStr = this.getParamTreeAsString(mzDbConnection, false);
            this.paramTree = ParamTreeParser.parseParamTree(paramTreeAsStr);
        }
    }

    @Override
    public String getParamTreeAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        return this.getParamTreeAsString(mzDbConnection, true);
    }

    private String getParamTreeAsString(SQLiteConnection mzDbConnection, boolean cacheStringRepresentation) throws SQLiteException {
        String paramTreeAsSt = this.paramTreeAsString;
        if (paramTreeAsSt == null) {
            String sqlString = "SELECT param_tree FROM spectrum WHERE id = ?";
            paramTreeAsSt = new SQLiteQuery(mzDbConnection, sqlString).bind(1, this.getId()).extractSingleString();
            if (cacheStringRepresentation) {
                this.paramTreeAsString = paramTreeAsSt;
            }
        }
        return paramTreeAsSt;
    }

    public String getParamTreeAsString() {
        return this.paramTreeAsString;
    }

    public void loadScanList(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (this.scanList == null) {
            String scanListAsStr = this.getScanListAsString(mzDbConnection, false);
            this.scanList = ParamTreeParser.parseScanList(scanListAsStr);
        }
    }

    public String getScanListAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        return this.getScanListAsString(mzDbConnection, true);
    }

    public boolean hasScanList() {
        return this.scanList != null;
    }

    public ScanList getScanList() {
        return this.scanList;
    }

    private String getScanListAsString(SQLiteConnection mzDbConnection, boolean cacheStringRepresentation) throws SQLiteException {
        String scanListAsStr = this.scanListAsString;
        if (scanListAsStr == null) {
            String sqlString = "SELECT scan_list FROM spectrum WHERE id = ?";
            scanListAsStr = new SQLiteQuery(mzDbConnection, sqlString).bind(1, this.getId()).extractSingleString();
            if (cacheStringRepresentation) {
                this.scanListAsString = scanListAsStr;
            }
        }
        return scanListAsStr;
    }

    public String getScanListAsString() {
        return this.scanListAsString;
    }

    public void loadPrecursorList(SQLiteConnection mzDbConnection) throws SQLiteException {
        if (this.precursor == null) {
            String precursorAsStr = this.getPrecursorListAsString(mzDbConnection, false);
            this.precursor = ParamTreeParser.parsePrecursor(precursorAsStr);
        }
    }

    public String getPrecursorListAsString(SQLiteConnection mzDbConnection) throws SQLiteException {
        return this.getPrecursorListAsString(mzDbConnection, true);
    }

    public boolean hasPrecursorList() {
        return this.precursorList != null;
    }

    public PrecursorList getPrecursorList() {
        return this.precursorList;
    }

    private String getPrecursorListAsString(SQLiteConnection mzDbConnection, boolean cacheStringRepresentation) throws SQLiteException {
        String precursorAsStr = this.precursorAsString;
        if (precursorAsStr == null && this.msLevel != 1) {
            String sqlString = "SELECT precursor_list FROM spectrum WHERE id = ?";
            precursorAsStr = new SQLiteQuery(mzDbConnection, sqlString).bind(1, this.getId()).extractSingleString();
            if (cacheStringRepresentation) {
                this.precursorAsString = precursorAsStr;
            }
        }
        return precursorAsStr;
    }

    public String getPrecursorListAsString() {
        return this.precursorAsString;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt32(this.initialId);
        writer.writeInt32(this.cycle);
        writer.writeFloat(this.time);
        writer.writeInt32(this.msLevel);
        writer.writeString(this.title);
        writer.writeInt32(this.peaksCount);
        writer.writeBoolean(this.isHighResolution);
        writer.writeFloat(this.tic);
        writer.writeDouble(this.basePeakMz);
        writer.writeFloat(this.basePeakIntensity);
        boolean hasData = this.activationType != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.activationType.write(writer);
        }
        hasData = this.isolationWindow != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.isolationWindow.write(writer);
        }
        hasData = this.precursorMz != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeDouble(this.precursorMz);
        }
        hasData = this.precursorCharge != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeInt32(this.precursorCharge);
        }
        writer.writeInt32(this.bbFirstSpectrumId);
        hasData = this.scanList != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.scanList.write(writer);
        }
        hasData = this.scanListAsString != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeString(this.scanListAsString);
        }
        hasData = this.precursor != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.precursor.write(writer);
        }
        hasData = this.precursorList != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.precursorList.write(writer);
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.initialId = reader.readInt32();
        this.cycle = reader.readInt32();
        this.time = reader.readFloat();
        this.msLevel = reader.readInt32();
        this.title = reader.readString();
        this.peaksCount = reader.readInt32();
        this.isHighResolution = reader.readBoolean();
        this.tic = reader.readFloat();
        this.basePeakMz = reader.readDouble();
        this.basePeakIntensity = reader.readFloat();
        boolean hasData = reader.readBoolean();
        this.activationType = hasData ? ActivationType.getEnum(reader) : null;
        hasData = reader.readBoolean();
        this.isolationWindow = hasData ? new IsolationWindow(reader) : null;
        hasData = reader.readBoolean();
        this.precursorMz = hasData ? Double.valueOf(reader.readDouble()) : null;
        hasData = reader.readBoolean();
        this.precursorCharge = hasData ? Integer.valueOf(reader.readInt32()) : null;
        this.bbFirstSpectrumId = reader.readInt32();
        hasData = reader.readBoolean();
        this.scanList = hasData ? new ScanList(reader) : null;
        hasData = reader.readBoolean();
        this.scanListAsString = hasData ? reader.readString() : null;
        hasData = reader.readBoolean();
        this.precursor = hasData ? new Precursor(reader) : null;
        hasData = reader.readBoolean();
        this.precursorList = hasData ? new PrecursorList(reader) : null;
    }
}

