/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.stat;

import fr.profi.util.stat.Bin;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E<Q\u0001D\u0007\t\u0002Y1Q\u0001G\u0007\t\u0002eAQ\u0001I\u0001\u0005\u0002\u00052AAI\u0001\u0001G!AQe\u0001BC\u0002\u0013\u0005a\u0005\u0003\u0005>\u0007\t\u0005\t\u0015!\u0003(\u0011!q4A!b\u0001\n\u0003y\u0004\u0002\u0003$\u0004\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b\u0001\u001aA\u0011A$\t\u000b1\u001bA\u0011A'\t\u000f\t\u001c\u0011\u0013!C\u0001G\"9anAI\u0001\n\u0003y\u0017a\u00029bG.\fw-\u001a\u0006\u0003\u001d=\tAa\u001d;bi*\u0011\u0001#E\u0001\u0005kRLGN\u0003\u0002\u0013'\u0005)\u0001O]8gS*\tA#\u0001\u0002ge\u000e\u0001\u0001CA\f\u0002\u001b\u0005i!a\u00029bG.\fw-Z\n\u0003\u0003i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0017\u0005])e\u000e^5us\"K7\u000f^8he\u0006l7i\\7qkR,'/\u0006\u0002%iM\u00111AG\u0001\tK:$\u0018\u000e^5fgV\tq\u0005E\u0002)_Ir!!\u000b\u0018\u000f\u0005)jS\"A\u0016\u000b\u00051*\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\taA$\u0003\u00021c\t\u00191+Z9\u000b\u00051a\u0002CA\u001a5\u0019\u0001!Q!N\u0002C\u0002Y\u0012\u0011\u0001V\t\u0003oi\u0002\"a\u0007\u001d\n\u0005eb\"a\u0002(pi\"Lgn\u001a\t\u00037mJ!\u0001\u0010\u000f\u0003\u0007\u0005s\u00170A\u0005f]RLG/[3tA\u0005qa/\u00197vK\u0016CHO]1di>\u0014X#\u0001!\u0011\tm\t%gQ\u0005\u0003\u0005r\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005m!\u0015BA#\u001d\u0005\u0019!u.\u001e2mK\u0006ya/\u00197vK\u0016CHO]1di>\u0014\b\u0005F\u0002I\u0015.\u00032!S\u00023\u001b\u0005\t\u0001\"B\u0013\t\u0001\u00049\u0003\"\u0002 \t\u0001\u0004\u0001\u0015!D2bY\u000eD\u0015n\u001d;pOJ\fW\u000eF\u0002O/r\u00032aG(R\u0013\t\u0001FDA\u0003BeJ\f\u0017\u0010\u0005\u0003\u001c%R;\u0013BA*\u001d\u0005\u0019!V\u000f\u001d7feA\u0011q#V\u0005\u0003-6\u00111AQ5o\u0011\u001dA\u0016\u0002%AA\u0002e\u000bQA\u001c2j]N\u0004\"a\u0007.\n\u0005mc\"aA%oi\"9Q,\u0003I\u0001\u0002\u0004q\u0016!\u0002:b]\u001e,\u0007cA\u000e`C&\u0011\u0001\r\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tm\u00116iQ\u0001\u0018G\u0006d7\rS5ti><'/Y7%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001a\u0016\u00033\u0016\\\u0013A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-d\u0012AC1o]>$\u0018\r^5p]&\u0011Q\u000e\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF2bY\u000eD\u0015n\u001d;pOJ\fW\u000e\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0001(F\u00010f\u0001")
public final class package {

    public static class EntityHistogramComputer<T> {
        private final Seq<T> entities;
        private final Function1<T, Object> valueExtractor;

        public Seq<T> entities() {
            return this.entities;
        }

        public Function1<T, Object> valueExtractor() {
            return this.valueExtractor;
        }

        public Tuple2<Bin, Seq<T>>[] calcHistogram(int nbins, Option<Tuple2<Object, Object>> range) {
            Seq sortedEntities;
            Tuple2 tuple2;
            Predef$.MODULE$.require(nbins > 0, (Function0 & Serializable & scala.Serializable)() -> "the histogram must contain at least one bin");
            if (range.isDefined()) {
                Predef$.MODULE$.require(((Tuple2)range.get())._2$mcD$sp() >= ((Tuple2)range.get())._1$mcD$sp(), (Function0 & Serializable & scala.Serializable)() -> "invalid value range");
            }
            if ((tuple2 = new Tuple2((sortedEntities = (Seq)this.entities().sortBy((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)EntityHistogramComputer.$anonfun$calcHistogram$3(this, e)), (Ordering)Ordering.Double$.MODULE$)).head(), sortedEntities.last())) == null) {
                throw new MatchError((Object)tuple2);
            }
            Object lowestEntity = tuple2._1();
            Object highestEntity = tuple2._2();
            Tuple2 tuple22 = new Tuple2(lowestEntity, highestEntity);
            Tuple2 tuple23 = tuple22;
            Object lowestEntity2 = tuple23._1();
            Object highestEntity2 = tuple23._2();
            double minVal = BoxesRunTime.unboxToDouble((Object)this.valueExtractor().apply(lowestEntity2));
            double b = 1.0E-10;
            double binSize = (range.isDefined() ? (((Tuple2)range.get())._2$mcD$sp() - ((Tuple2)range.get())._1$mcD$sp()) / (double)nbins : (BoxesRunTime.unboxToDouble((Object)this.valueExtractor().apply(highestEntity2)) - minVal) / (double)nbins) + b;
            Tuple2[] bins = (Tuple2[])Array$.MODULE$.tabulate(nbins, (Function1 & Serializable & scala.Serializable)i -> EntityHistogramComputer.$anonfun$calcHistogram$4(minVal, binSize, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
            this.entities().foreach((Function1 & Serializable & scala.Serializable)e -> {
                int binIdx = EntityHistogramComputer.binIndex$1(BoxesRunTime.unboxToDouble((Object)this.valueExtractor().apply(e)), minVal, binSize, nbins);
                return ((ArrayBuffer)bins[binIdx]._2()).$plus$eq(e);
            });
            return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins)).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), (Object)((SeqLike)p._2()).toSeq()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        }

        public int calcHistogram$default$1() {
            return (int)package$.MODULE$.sqrt((double)this.entities().length());
        }

        public Option<Tuple2<Object, Object>> calcHistogram$default$2() {
            return None$.MODULE$;
        }

        public static final /* synthetic */ double $anonfun$calcHistogram$3(EntityHistogramComputer $this, Object e) {
            return BoxesRunTime.unboxToDouble((Object)$this.valueExtractor().apply(e));
        }

        private static final int binIndex$1(double v, double minVal$1, double binSize$1, int nbins$1) {
            int tmpBinIdx = (int)package$.MODULE$.floor((v - minVal$1) / binSize$1);
            return package$.MODULE$.min(tmpBinIdx, nbins$1 - 1);
        }

        private static final Bin bin$1(int idx, double minVal$1, double binSize$1) {
            double lowerBound = minVal$1 + (double)idx * binSize$1;
            return new Bin(lowerBound + 0.5 * binSize$1, lowerBound, lowerBound + binSize$1);
        }

        public static final /* synthetic */ Tuple2 $anonfun$calcHistogram$4(double minVal$1, double binSize$1, int i) {
            return new Tuple2((Object)EntityHistogramComputer.bin$1(i, minVal$1, binSize$1), (Object)new ArrayBuffer());
        }

        public EntityHistogramComputer(Seq<T> entities, Function1<T, Object> valueExtractor) {
            this.entities = entities;
            this.valueExtractor = valueExtractor;
        }
    }
}

