/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params.thermo;

import fr.profi.mzdb.db.model.params.thermo.ThermoFragmentationTarget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThermoScanMetaData {
    protected final String acquisitionType;
    protected final String analyzerType;
    protected int msLevel;
    protected final float[] mzRange;
    protected final ThermoFragmentationTarget[] targets;
    String targetPattern = "\\s(\\d+\\.\\d+)@([a-z]+)(\\d+\\.\\d+)";
    String ms2Pattern = "\\d" + this.targetPattern + "\\s\\[(\\d+\\.\\d+)-(\\d+\\.\\d+)\\]";
    String ms3Pattern = "\\d" + this.targetPattern + this.targetPattern + "\\s\\[(\\d+\\.\\d+)-(\\d+\\.\\d+)\\]";

    public ThermoScanMetaData(String spectrumType, String analyzerType, int msLevel, float[] mzRange, ThermoFragmentationTarget[] targets) {
        this.acquisitionType = spectrumType;
        this.analyzerType = analyzerType;
        this.msLevel = msLevel;
        this.mzRange = mzRange;
        this.targets = targets;
    }

    public ThermoScanMetaData(String filterString) {
        String[] stringParts = filterString.split("Full ms");
        String rightString = stringParts[1];
        char msLevelChar = rightString.charAt(0);
        int msLevel = Character.getNumericValue(msLevelChar);
        String spectrumType = stringParts[0] + "Full ms" + msLevelChar;
        String pattern = msLevel == 3 ? this.ms3Pattern : this.ms2Pattern;
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(rightString);
        ThermoFragmentationTarget[] targets = new ThermoFragmentationTarget[msLevel - 1];
        float[] mzRange = new float[]{0.0f, 0.0f};
        if (m.find()) {
            targets[0] = new ThermoFragmentationTarget(1, Double.parseDouble(m.group(1)), m.group(2), Float.parseFloat(m.group(3)));
            if (msLevel == 2) {
                mzRange[0] = Float.parseFloat(m.group(4));
                mzRange[1] = Float.parseFloat(m.group(5));
            } else {
                targets[1] = new ThermoFragmentationTarget(2, Double.parseDouble(m.group(4)), m.group(5), Float.parseFloat(m.group(6)));
                mzRange[0] = Float.parseFloat(m.group(7));
                mzRange[1] = Float.parseFloat(m.group(8));
            }
        }
        this.acquisitionType = spectrumType;
        this.analyzerType = stringParts[0].split("\\s")[0];
        this.msLevel = msLevel;
        this.mzRange = mzRange;
        this.targets = targets;
    }

    public String getAcquisitionType() {
        return this.acquisitionType;
    }

    public String getAnalyzerType() {
        return this.analyzerType;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public float[] getMzRange() {
        return this.mzRange;
    }

    public ThermoFragmentationTarget[] getTargets() {
        return this.targets;
    }
}

