/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.serialization;

import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class SerializationWriter {
    private CodedOutputStream codedOutput;

    public SerializationWriter(OutputStream outputStream, int bufferSize) {
        this.codedOutput = CodedOutputStream.newInstance((OutputStream)outputStream, (int)bufferSize);
    }

    public void flush() throws IOException {
        this.codedOutput.flush();
    }

    public void writeString(String value) throws IOException {
        this.codedOutput.writeStringNoTag(value);
    }

    public void writeInt32(int value) throws IOException {
        this.codedOutput.writeInt32NoTag(value);
    }

    public void writeInt64(long value) throws IOException {
        this.codedOutput.writeInt64NoTag(value);
    }

    public void writeFloat(float value) throws IOException {
        this.codedOutput.writeFixed32NoTag(Float.floatToRawIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.codedOutput.writeFixed64NoTag(Double.doubleToRawLongBits(value));
    }

    public void writeBoolean(boolean value) throws IOException {
        this.codedOutput.writeBoolNoTag(value);
    }

    public void write(String[] values) throws IOException {
        int i;
        this.codedOutput.writeInt32NoTag(values.length);
        int dataSize = 0;
        for (i = 0; i < values.length; ++i) {
            dataSize += CodedOutputStream.computeStringSizeNoTag((String)values[i]);
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (i = 0; i < values.length; ++i) {
            this.codedOutput.writeStringNoTag(values[i]);
        }
    }

    public void write(int[] values) throws IOException {
        int i;
        this.codedOutput.writeInt32NoTag(values.length);
        int dataSize = 0;
        for (i = 0; i < values.length; ++i) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)values[i]);
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (i = 0; i < values.length; ++i) {
            this.codedOutput.writeInt32NoTag(values[i]);
        }
    }

    public void write(long[] values) throws IOException {
        int i;
        this.codedOutput.writeInt32NoTag(values.length);
        int dataSize = 0;
        for (i = 0; i < values.length; ++i) {
            dataSize += CodedOutputStream.computeInt64SizeNoTag((long)values[i]);
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (i = 0; i < values.length; ++i) {
            this.codedOutput.writeInt64NoTag(values[i]);
        }
    }

    public void write(float[] values) throws IOException {
        int i;
        this.codedOutput.writeInt32NoTag(values.length);
        int dataSize = 0;
        for (i = 0; i < values.length; ++i) {
            dataSize += CodedOutputStream.computeFixed32SizeNoTag((int)Float.floatToRawIntBits(values[i]));
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (i = 0; i < values.length; ++i) {
            this.codedOutput.writeFixed32NoTag(Float.floatToRawIntBits(values[i]));
        }
    }

    public void write(double[] values) throws IOException {
        int i;
        this.codedOutput.writeInt32NoTag(values.length);
        int dataSize = 0;
        for (i = 0; i < values.length; ++i) {
            dataSize += CodedOutputStream.computeFixed64SizeNoTag((long)Double.doubleToRawLongBits(values[i]));
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (i = 0; i < values.length; ++i) {
            this.codedOutput.writeFixed64NoTag(Double.doubleToRawLongBits(values[i]));
        }
    }

    public void write(boolean[] values) throws IOException {
        int i;
        this.codedOutput.writeInt32NoTag(values.length);
        int dataSize = 0;
        for (i = 0; i < values.length; ++i) {
            dataSize += CodedOutputStream.computeBoolSizeNoTag((boolean)values[i]);
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (i = 0; i < values.length; ++i) {
            this.codedOutput.writeBoolNoTag(values[i]);
        }
    }

    public void writeMapInt2String(HashMap<Integer, String> values) throws IOException {
        int size = values.size();
        this.codedOutput.writeInt32NoTag(size);
        int dataSize = 0;
        for (Map.Entry<Integer, String> entries : values.entrySet()) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)entries.getKey());
            dataSize += CodedOutputStream.computeStringSizeNoTag((String)entries.getValue());
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (Map.Entry<Integer, String> entries : values.entrySet()) {
            this.codedOutput.writeInt32NoTag(entries.getKey().intValue());
            this.codedOutput.writeStringNoTag(entries.getValue());
        }
    }

    public void writeMapInt2Double(HashMap<Integer, Double> values) throws IOException {
        int size = values.size();
        this.codedOutput.writeInt32NoTag(size);
        int dataSize = 0;
        for (Map.Entry<Integer, Double> entries : values.entrySet()) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)entries.getKey());
            dataSize += CodedOutputStream.computeFixed64SizeNoTag((long)Double.doubleToRawLongBits(entries.getValue()));
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (Map.Entry<Integer, Double> entries : values.entrySet()) {
            this.codedOutput.writeInt32NoTag(entries.getKey().intValue());
            this.codedOutput.writeFixed64NoTag(Double.doubleToRawLongBits(entries.getValue()));
        }
    }

    public void writeMapString2String(HashMap<String, String> values) throws IOException {
        int size = values.size();
        this.codedOutput.writeInt32NoTag(size);
        int dataSize = 0;
        for (Map.Entry<String, String> entries : values.entrySet()) {
            dataSize += CodedOutputStream.computeStringSizeNoTag((String)entries.getKey());
            dataSize += CodedOutputStream.computeStringSizeNoTag((String)entries.getValue());
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (Map.Entry<String, String> entries : values.entrySet()) {
            this.codedOutput.writeStringNoTag(entries.getKey());
            this.codedOutput.writeStringNoTag(entries.getValue());
        }
    }

    public void writeMapString2Int(HashMap<String, Integer> values) throws IOException {
        int size = values.size();
        this.codedOutput.writeInt32NoTag(size);
        int dataSize = 0;
        for (Map.Entry<String, Integer> entries : values.entrySet()) {
            dataSize += CodedOutputStream.computeStringSizeNoTag((String)entries.getKey());
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)entries.getValue());
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (Map.Entry<String, Integer> entries : values.entrySet()) {
            this.codedOutput.writeStringNoTag(entries.getKey());
            this.codedOutput.writeInt32NoTag(entries.getValue().intValue());
        }
    }

    public void writeMapString2Double(HashMap<String, Double> values) throws IOException {
        int size = values.size();
        this.codedOutput.writeInt32NoTag(size);
        int dataSize = 0;
        for (Map.Entry<String, Double> entries : values.entrySet()) {
            dataSize += CodedOutputStream.computeStringSizeNoTag((String)entries.getKey());
            dataSize += CodedOutputStream.computeFixed64SizeNoTag((long)Double.doubleToRawLongBits(entries.getValue()));
        }
        this.codedOutput.writeUInt32NoTag(dataSize);
        for (Map.Entry<String, Double> entries : values.entrySet()) {
            this.codedOutput.writeStringNoTag(entries.getKey());
            this.codedOutput.writeFixed64NoTag(Double.doubleToRawLongBits(entries.getValue()));
        }
    }
}

