/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.server;

import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import fr.profi.mzdb.server.MzdbController;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MzdbServer.class);
    private static Socket m_sockClient = null;
    private static boolean m_interrupt = false;

    public static void processRequests(int port) {
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            MzdbController mzdbController = new MzdbController();
            String version = "";
            try {
                Properties properties = new Properties();
                properties.load(MzdbController.class.getResourceAsStream("mzdbServerWriter.properties"));
                version = properties.getProperty("mzdbServer.version", "");
                System.out.println("Mzdb Server Writer Version : " + version);
            }
            catch (Exception e) {
                LOGGER.warn("error in addMzdbMetaData : can not get current version");
            }
            if (m_interrupt) {
                return;
            }
            Object message = "Listen to " + port;
            LOGGER.info((String)message);
            m_sockClient = serverSocket.accept();
            message = "Client Connected";
            LOGGER.info((String)message);
            InputStream inputStream = m_sockClient.getInputStream();
            SerializationReader reader = new SerializationReader(inputStream);
            OutputStream outputStream = m_sockClient.getOutputStream();
            SerializationWriter writer = new SerializationWriter(outputStream, 1024);
            while (true) {
                String response;
                int methodKey = reader.readInt32();
                switch (methodKey) {
                    case 0: {
                        response = mzdbController.initializeMzdb(reader);
                        break;
                    }
                    case 1: {
                        response = mzdbController.addspectrum(reader);
                        break;
                    }
                    case 2: {
                        response = mzdbController.addMzdbMetaData(reader);
                        break;
                    }
                    case 3: {
                        response = mzdbController.closedb();
                        break;
                    }
                    case -1: {
                        response = mzdbController.test(reader);
                        break;
                    }
                    case 4: {
                        outputStream.close();
                        System.exit(0);
                    }
                    default: {
                        response = "KO:Unknow Request";
                        LOGGER.error(response);
                    }
                }
                writer.writeString(response);
                writer.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error("Server Error", (Throwable)e);
            return;
        }
    }

    public static void interrupt() {
        if (m_sockClient == null) {
            return;
        }
        try {
            m_interrupt = true;
            m_sockClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

