/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteInterruptedException;
import com.almworks.sqlite4java.SQLiteQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLiteJob<T>
implements Future<T> {
    private static final int PENDING = 0;
    private static final int RUNNING = 1;
    private static final int SUCCEEDED = 2;
    private static final int ERROR = 3;
    private static final int CANCELLED = 4;
    private final Object myLock = new Object();
    private int myState = 0;
    private Throwable myError;
    private SQLiteConnection myConnection;
    private SQLiteQueue myQueue;
    private T myResult;

    protected abstract T job(SQLiteConnection var1) throws Throwable;

    protected void jobStarted(SQLiteConnection connection) throws Throwable {
    }

    protected void jobFinished(T result) throws Throwable {
    }

    protected void jobError(Throwable error) throws Throwable {
    }

    protected void jobCancelled() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SQLiteQueue getQueue() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getError() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState == 2 || this.myState == 4 || this.myState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        SQLiteConnection connection;
        Object object = this.myLock;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            if (this.myState == 1 && !mayInterruptIfRunning) {
                return false;
            }
            assert (this.myConnection == null || this.myState == 1) : this.myState + " " + this.myConnection;
            this.myState = 4;
            connection = this.myConnection;
        }
        if (connection != null) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "interrupting");
            }
            try {
                connection.interrupt();
            }
            catch (SQLiteException e) {
                Internal.log(Level.WARNING, this, "exception when interrupting", e);
            }
        } else {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "cancelling");
            }
            this.finishJob(null);
        }
        return true;
    }

    public void cancel() {
        this.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState == 4;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)(e + " cannot happen"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.isDone()) {
                long stop;
                SQLiteQueue queue = this.myQueue;
                if (queue != null && queue.isDatabaseThread()) {
                    throw new IllegalStateException("called from the database thread, would block forever");
                }
                long now = System.currentTimeMillis();
                if (timeout <= 0L) {
                    stop = now - 1L;
                } else {
                    stop = now + unit.toMillis(timeout);
                    if (stop < now) {
                        stop = Long.MAX_VALUE;
                    }
                }
                while (now < stop && !this.isDone()) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.myLock.wait(Math.min(1000L, stop - now));
                    now = System.currentTimeMillis();
                }
            }
            if (this.isDone()) {
                if (this.myState == 3) {
                    throw new ExecutionException(this.myError);
                }
                return this.myResult;
            }
        }
        throw new TimeoutException();
    }

    public T complete() {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Internal.log(Level.WARNING, this, "complete() consumed exception", e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Internal.log(Level.WARNING, this, "complete() consumed exception", e);
            return null;
        }
        catch (TimeoutException e) {
            Internal.log(Level.WARNING, this, "complete() timeout?", e);
            return null;
        }
    }

    public String toString() {
        String r = super.toString();
        int k = r.lastIndexOf(46);
        if (k >= 0) {
            r = r.substring(k + 1);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(SQLiteConnection connection, SQLiteQueue queue) throws Throwable {
        if (!this.startJob(connection, queue)) {
            return;
        }
        T result = null;
        try {
            result = this.job(connection);
        }
        catch (Throwable e) {
            this.processJobError(e);
        }
        finally {
            this.finishJob(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startJob(SQLiteConnection connection, SQLiteQueue queue) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState != 0) {
                if (this.myState != 4) {
                    Internal.logWarn(this, "was already executed");
                }
                return false;
            }
            this.myState = 1;
            this.myConnection = connection;
            this.myQueue = queue;
        }
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "started");
        }
        try {
            this.jobStarted(connection);
        }
        catch (Throwable e) {
            Internal.log(Level.SEVERE, this, "callback exception", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJobError(Throwable e) throws Throwable {
        Object object = this.myLock;
        synchronized (object) {
            if (e instanceof SQLiteInterruptedException) {
                this.myState = 4;
                if (Internal.isFineLogging()) {
                    Internal.log(Level.FINE, this, "cancelled", e);
                }
            } else {
                Internal.log(Level.WARNING, this, "job exception", e);
                this.myError = e;
                this.myState = 3;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishJob(T result) {
        Object object;
        block16: {
            block15: {
                Throwable error;
                int state;
                object = this.myLock;
                synchronized (object) {
                    this.myConnection = null;
                    if (this.myState == 1) {
                        this.myState = 2;
                        this.myResult = result;
                    }
                    state = this.myState;
                    error = this.myError;
                }
                try {
                    if (state == 4) {
                        this.jobCancelled();
                    } else if (state == 3) {
                        this.jobError(error);
                    }
                }
                catch (Throwable e) {
                    Internal.log(Level.WARNING, this, "callback exception", e);
                    if (!(e instanceof ThreadDeath)) break block15;
                    throw (ThreadDeath)e;
                }
            }
            try {
                this.jobFinished(result);
            }
            catch (Throwable e) {
                Internal.log(Level.WARNING, this, "callback exception", e);
                if (!(e instanceof ThreadDeath)) break block16;
                throw (ThreadDeath)e;
            }
        }
        object = this.myLock;
        synchronized (object) {
            this.myQueue = null;
            this.myLock.notifyAll();
        }
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "finished");
        }
    }
}

