/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model.params;

import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.db.model.params.ScanWindow;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;

@XmlRootElement(name="scanWindowList")
public class ScanWindowList
extends AbstractXMLParamTree {
    @XmlAttribute(required=true)
    @XmlSchemaType(name="nonNegativeInteger")
    protected int count;
    @XmlElementWrapper(name="scanWindow")
    protected List<ScanWindow> scanWindows;

    public ScanWindowList() {
    }

    public ScanWindowList(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public ScanWindowList(int c) {
        this.count = c;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt32(this.count);
        boolean hasData = this.scanWindows != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeInt32(this.scanWindows.size());
            for (SerializationInterface serializationInterface : this.scanWindows) {
                serializationInterface.write(writer);
            }
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        super.read(reader);
        this.count = reader.readInt32();
        boolean hasData = reader.readBoolean();
        if (hasData) {
            int size = reader.readInt32();
            this.scanWindows = new ArrayList<ScanWindow>(size);
            for (int i = 0; i < size; ++i) {
                ScanWindow element = new ScanWindow(reader);
                this.scanWindows.add(element);
            }
        } else {
            this.scanWindows = null;
        }
    }
}

