/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.cache;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.db.table.RunSliceTable;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCacheContainer;
import fr.profi.mzdb.model.RunSliceHeader;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRunSliceHeaderReader
extends MzDbEntityCacheContainer {
    private RunSliceHeaderExtractor _runSliceHeaderExtractor = new RunSliceHeaderExtractor();

    public AbstractRunSliceHeaderReader(AbstractMzDbReader mzDbReader) {
        super(mzDbReader);
    }

    protected RunSliceHeader[] getRunSliceHeaders(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().runSliceHeaders != null) {
            return this.getEntityCache().runSliceHeaders;
        }
        String queryStr = "SELECT * FROM run_slice";
        List<RunSliceHeader> rshList = new SQLiteQuery(connection, queryStr).extractRecordList(this._runSliceHeaderExtractor);
        RunSliceHeader[] runSliceHeaders = rshList.toArray(new RunSliceHeader[rshList.size()]);
        if (this.getEntityCache() != null) {
            this.getEntityCache().runSliceHeaders = runSliceHeaders;
        }
        return runSliceHeaders;
    }

    protected RunSliceHeader[] getRunSliceHeaders(int msLevel, SQLiteConnection connection) throws SQLiteException {
        ArrayList rshList = new ArrayList();
        if (this.getEntityCache() != null && this.getEntityCache().runSliceHeaders != null) {
            RunSliceHeader[] runSliceHeaders;
            for (RunSliceHeader rsh : runSliceHeaders = this.getEntityCache().runSliceHeaders) {
                if (rsh.getMsLevel() != msLevel) continue;
                rshList.add(rsh);
            }
        } else {
            String queryStr = "SELECT * FROM run_slice WHERE ms_level=? ORDER BY begin_mz ";
            SQLiteQuery query = new SQLiteQuery(connection, queryStr).bind(1, msLevel);
            rshList = (ArrayList)query.extractRecordList(this._runSliceHeaderExtractor);
        }
        return rshList.toArray(new RunSliceHeader[rshList.size()]);
    }

    private HashMap<Integer, RunSliceHeader> _getRunSliceHeaderById(RunSliceHeader[] runSliceHeaders) {
        HashMap<Integer, RunSliceHeader> runSliceHeaderById = new HashMap<Integer, RunSliceHeader>(runSliceHeaders.length);
        for (RunSliceHeader runSlice : runSliceHeaders) {
            runSliceHeaderById.put(runSlice.getId(), runSlice);
        }
        return runSliceHeaderById;
    }

    public HashMap<Integer, RunSliceHeader> getRunSliceHeaderById(int msLevel, SQLiteConnection connection) throws SQLiteException {
        RunSliceHeader[] runSliceHeaders = this.getRunSliceHeaders(msLevel, connection);
        return this._getRunSliceHeaderById(runSliceHeaders);
    }

    protected Map<Integer, RunSliceHeader> getRunSliceHeaderById(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().runSliceHeaderById != null) {
            return this.getEntityCache().runSliceHeaderById;
        }
        HashMap<Integer, RunSliceHeader> runSliceHeaderById = this._getRunSliceHeaderById(this.getRunSliceHeaders(connection));
        if (this.getEntityCache() != null) {
            this.getEntityCache().runSliceHeaderById = runSliceHeaderById;
        }
        return runSliceHeaderById;
    }

    protected RunSliceHeader getRunSliceHeader(int id, SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null) {
            return this.getRunSliceHeaderById(connection).get(id);
        }
        String queryStr = "SELECT * FROM run_slice WHERE id = ?";
        return new SQLiteQuery(connection, queryStr).bind(1, id).extractRecord(this._runSliceHeaderExtractor);
    }

    protected RunSliceHeader getRunSliceForMz(double mz, int msLevel, SQLiteConnection connection) throws SQLiteException {
        String queryStr = "SELECT * FROM run_slice WHERE ms_level = ? AND begin_mz <= ? AND end_mz > ?";
        return new SQLiteQuery(connection, queryStr).bind(1, msLevel).bind(2, mz).bind(3, mz).extractRecord(this._runSliceHeaderExtractor);
    }

    protected int[] getRunSliceIdsForMzRange(double minMz, double maxMz, int msLevel, SQLiteConnection connection) throws SQLiteException {
        RunSliceHeader firstRunSlice = this.getRunSliceForMz(minMz, msLevel, connection);
        RunSliceHeader lastRunSlice = this.getRunSliceForMz(maxMz, msLevel, connection);
        double mzHeight = msLevel == 1 ? this.getMzDbReader().getBBSizes().BB_MZ_HEIGHT_MS1 : this.getMzDbReader().getBBSizes().BB_MZ_HEIGHT_MSn;
        int bufferLength = 1 + (int)((maxMz - minMz) / mzHeight);
        String queryStr = "SELECT id FROM run_slice WHERE ms_level = ? AND begin_mz >= ? AND end_mz <= ?";
        return new SQLiteQuery(connection, queryStr).bind(1, msLevel).bind(2, firstRunSlice.getBeginMz()).bind(3, lastRunSlice.getEndMz()).extractInts(bufferLength);
    }

    private class RunSliceHeaderExtractor
    implements ISQLiteRecordExtraction<RunSliceHeader> {
        private RunSliceHeaderExtractor() {
        }

        @Override
        public RunSliceHeader extract(SQLiteRecord record) throws SQLiteException {
            return new RunSliceHeader(record.columnInt(RunSliceTable.ID), record.columnInt(RunSliceTable.MS_LEVEL), record.columnInt(RunSliceTable.NUMBER), record.columnDouble(RunSliceTable.BEGIN_MZ), record.columnDouble(RunSliceTable.END_MZ), record.columnInt(RunSliceTable.RUN_ID));
        }
    }
}

