/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.table.SpectrumTable;
import fr.profi.mzdb.io.reader.iterator.SpectrumIterator;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.DefaultSpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.ISpectrumProcessor;
import fr.profi.mzdb.io.writer.mgf.MgfField;
import fr.profi.mzdb.io.writer.mgf.MgfPrecursor;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordOperation;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgfWriter {
    public static String LINE_SPERATOR = System.getProperty("line.separator");
    final Logger logger = LoggerFactory.getLogger(MgfWriter.class);
    private static String titleQuery = "SELECT id, title FROM spectrum WHERE ms_level=?";
    private final String mzDBFilePath;
    private final int msLevel;
    private MzDbReader mzDbReader;
    private Map<Long, String> titleBySpectrumId = new HashMap<Long, String>();
    private List<String> headerComments = null;
    private String prolineTitleSeparator = ";";

    public MgfWriter(String mzDBFilePath, int msLevel, String prolineSpectraTitleSeparator) throws SQLiteException, FileNotFoundException {
        this(mzDBFilePath, msLevel);
        this.prolineTitleSeparator = prolineSpectraTitleSeparator;
    }

    public MgfWriter(String mzDBFilePath, int msLevel) throws SQLiteException, FileNotFoundException {
        if (msLevel < 2 || msLevel > 3) {
            throw new IllegalArgumentException("msLevel must be 2 or 3");
        }
        this.mzDBFilePath = mzDBFilePath;
        this.msLevel = msLevel;
        this.initReader();
    }

    public MgfWriter(String mzDBFilePath) throws SQLiteException, FileNotFoundException {
        this(mzDBFilePath, 2);
    }

    private void initReader() throws FileNotFoundException, SQLiteException {
        this.mzDbReader = new MzDbReader(this.mzDBFilePath, true);
        this.mzDbReader.enablePrecursorListLoading();
        this.mzDbReader.enableParamTreeLoading();
        this.titleBySpectrumId.clear();
        this._fillTitleBySpectrumId();
        this.logger.info("Number of loaded spectra titles: " + this.titleBySpectrumId.size());
    }

    public MzDbReader getMzDbReader() {
        if (!this.mzDbReader.getConnection().isOpen()) {
            try {
                this.initReader();
            }
            catch (SQLiteException | FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mzDbReader;
    }

    public void setHeaderComments(List<String> headerComments) {
        this.headerComments = headerComments;
    }

    private void _fillTitleBySpectrumId() throws SQLiteException {
        final class TitleByIdFiller
        implements ISQLiteRecordOperation {
            private Map<Long, String> titleById;

            TitleByIdFiller(Map<Long, String> t) {
                this.titleById = t;
            }

            @Override
            public void execute(SQLiteRecord elem, int idx) throws SQLiteException {
                long id = elem.columnLong(SpectrumTable.ID);
                String title = elem.columnString(SpectrumTable.TITLE);
                this.titleById.put(id, title);
            }
        }
        TitleByIdFiller f = new TitleByIdFiller(this.titleBySpectrumId);
        new SQLiteQuery(this.mzDbReader.getConnection(), titleQuery).bind(1, this.msLevel).forEachRecord(f);
    }

    public void write(String mgfFile, PrecursorMzComputationEnum precComp, float mzTolPPM, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException, IOException {
        this.write(mgfFile, new DefaultPrecursorComputer(precComp, mzTolPPM), null, intensityCutoff, exportProlineTitle);
    }

    public void write(String mgfFile, IPrecursorComputation precComp, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException, IOException {
        this.write(mgfFile, precComp, new DefaultSpectrumProcessor(), intensityCutoff, exportProlineTitle);
    }

    public void write(String mgfFile, IPrecursorComputation precComp, ISpectrumProcessor spectrumProcessor, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException, IOException {
        if (!this.mzDbReader.getConnection().isOpen()) {
            this.initReader();
        }
        if (((String)mgfFile).isEmpty()) {
            mgfFile = this.mzDBFilePath + ".mgf";
        }
        this.mzDbReader.enablePrecursorListLoading();
        this.mzDbReader.enableScanListLoading();
        SpectrumIterator spectrumIterator = new SpectrumIterator(this.mzDbReader, this.mzDbReader.getConnection(), this.msLevel);
        PrintWriter mgfWriter = new PrintWriter(new BufferedWriter(new FileWriter((String)mgfFile)));
        Map<Long, DataEncoding> dataEncodingBySpectrumId = this.mzDbReader.getDataEncodingBySpectrumId();
        if (this.headerComments != null && !this.headerComments.isEmpty()) {
            this.headerComments.forEach(l -> mgfWriter.println("# " + l));
            mgfWriter.println();
        }
        int spectraCount = 0;
        while (spectrumIterator.hasNext()) {
            Spectrum s = (Spectrum)spectrumIterator.next();
            long spectrumId = s.getHeader().getId();
            DataEncoding dataEnc = dataEncodingBySpectrumId.get(spectrumId);
            MgfPrecursor[] precursors = precComp.getMgfPrecursors(this.mzDbReader, s.getHeader());
            for (int k = 0; k < precursors.length; ++k) {
                String spectrumAsStr = this.stringifySpectrum(precursors[k], s, dataEnc, spectrumProcessor, intensityCutoff, exportProlineTitle);
                mgfWriter.println(spectrumAsStr);
                mgfWriter.println();
                ++spectraCount;
            }
        }
        this.logger.info(String.format("MGF file successfully created: %d spectra exported.", spectraCount));
        mgfWriter.flush();
        mgfWriter.close();
        this.mzDbReader.close();
    }

    protected String stringifySpectrum(MgfPrecursor mgfPrecursor, Spectrum spectrum, DataEncoding dataEnc, ISpectrumProcessor spectrumProcessor, float intensityCutoff, boolean exportProlineTitle) throws SQLiteException {
        String title;
        String mzFragFormat = null;
        mzFragFormat = dataEnc.getPeakEncoding() == PeakEncoding.LOW_RES_PEAK ? "%.1f" : "%.3f";
        SpectrumHeader spectrumHeader = spectrum.getHeader();
        if (!exportProlineTitle) {
            title = this.titleBySpectrumId.get(spectrumHeader.getSpectrumId());
        } else {
            float timeInMinutes = spectrumHeader.getTime() / 60.0f;
            StringBuilder titleTemplate = new StringBuilder();
            titleTemplate.append("first_cycle:%d").append(this.prolineTitleSeparator);
            titleTemplate.append("last_cycle:%d").append(this.prolineTitleSeparator);
            titleTemplate.append("first_scan:%d").append(this.prolineTitleSeparator);
            titleTemplate.append("last_scan:%d").append(this.prolineTitleSeparator);
            titleTemplate.append("first_time:%.3f").append(this.prolineTitleSeparator);
            titleTemplate.append("last_time:%.3f").append(this.prolineTitleSeparator);
            if (mgfPrecursor.hasAnnotation("source")) {
                titleTemplate.append("source:").append(mgfPrecursor.getAnnotation("source")).append(this.prolineTitleSeparator);
            }
            if (mgfPrecursor.hasAnnotation("precursor.signal.total.sw")) {
                titleTemplate.append("pif:").append(mgfPrecursor.getAnnotation("precursor.signal.total.sw")).append(this.prolineTitleSeparator);
            }
            if (mgfPrecursor.hasAnnotation("mgf.id")) {
                titleTemplate.append("mgf_id:").append(mgfPrecursor.getAnnotation("mgf.id")).append(this.prolineTitleSeparator);
            }
            titleTemplate.append("raw_file_identifier:%s").append(this.prolineTitleSeparator);
            title = String.format(titleTemplate.toString(), spectrumHeader.getCycle(), spectrumHeader.getCycle(), spectrumHeader.getInitialId(), spectrumHeader.getInitialId(), Float.valueOf(timeInMinutes), Float.valueOf(timeInMinutes), this.mzDbReader.getFirstSourceFileName().split("\\.")[0]);
        }
        StringBuilder spectrumStringBuilder = new StringBuilder();
        if (spectrumStringBuilder.length() > 0) {
            spectrumStringBuilder.append(LINE_SPERATOR).append(LINE_SPERATOR);
        }
        spectrumStringBuilder.append((Object)MgfField.BEGIN_IONS).append(LINE_SPERATOR);
        spectrumStringBuilder.append((Object)MgfField.TITLE).append("=").append(title).append(LINE_SPERATOR);
        spectrumStringBuilder.append((Object)MgfField.SCANS).append("=").append(spectrumHeader.getInitialId()).append(LINE_SPERATOR);
        mgfPrecursor.appendToStringBuilder(spectrumStringBuilder);
        SpectrumData data = spectrumProcessor.processSpectrum(mgfPrecursor, spectrum.getData());
        double[] mzs = data.getMzList();
        float[] ints = data.getIntensityList();
        int intsLength = ints.length;
        for (int i = 0; i < intsLength; ++i) {
            float intensity = ints[i];
            if (!(intensity >= intensityCutoff)) continue;
            double mz = mzs[i];
            spectrumStringBuilder.append(String.format(mzFragFormat, mz)).append(" ").append(String.format("%.0f", Float.valueOf(intensity))).append(LINE_SPERATOR);
        }
        spectrumStringBuilder.append((Object)MgfField.END_IONS);
        return spectrumStringBuilder.toString();
    }
}

