/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.signal.filtering;

import fr.profi.mzdb.algo.signal.filtering.BaselineRemover$;
import fr.profi.mzdb.model.Peak;
import fr.profi.util.stat.Bin;
import fr.profi.util.stat.package;
import java.io.Serializable;
import org.apache.commons.math3.stat.StatUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0005\n\u0001?!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d1\u0005!%A\u0005\u0002\u001dCQA\u0015\u0001\u0005\nMCQ!\r\u0001\u0005\u0002\u0001DQ!\r\u0001\u0005\u0002\tDQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQA\u001c\u0001\u0005\n=<q\u0001\u001e\n\u0002\u0002#\u0005QOB\u0004\u0012%\u0005\u0005\t\u0012\u0001<\t\u000b-jA\u0011A<\t\u000fal\u0011\u0013!C\u0001s\"910DI\u0001\n\u0003I(a\u0004\"bg\u0016d\u0017N\\3SK6|g/\u001a:\u000b\u0005M!\u0012!\u00034jYR,'/\u001b8h\u0015\t)b#\u0001\u0004tS\u001et\u0017\r\u001c\u0006\u0003/a\tA!\u00197h_*\u0011\u0011DG\u0001\u0005[j$'M\u0003\u0002\u001c9\u0005)\u0001O]8gS*\tQ$\u0001\u0002ge\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u0006aq-\u00199U_2,'/\u00198dKB\u0011\u0011\u0005K\u0005\u0003S\t\u00121!\u00138u\u00035i\u0017N\u001c)fC.\u001c8i\\;oi\u00061A(\u001b8jiz\"2!L\u00181!\tq\u0003!D\u0001\u0013\u0011\u001d13\u0001%AA\u0002\u001dBqAK\u0002\u0011\u0002\u0003\u0007q%\u0001\bsK6|g/\u001a\"bg\u0016d\u0015N\\3\u0015\u0007Mbd\bE\u0002\"iYJ!!\u000e\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eB\u0012!B7pI\u0016d\u0017BA\u001e9\u0005\u0011\u0001V-Y6\t\u000bu\"\u0001\u0019A\u001a\u0002\u000bA,\u0017m[:\t\u000f}\"\u0001\u0013!a\u0001\u0001\u0006\tbn\\5tKRC'/Z:i_2$w\n\u001d;\u0011\u0007\u0005\n5)\u0003\u0002CE\t1q\n\u001d;j_:\u0004\"!\t#\n\u0005\u0015\u0013#A\u0002#pk\ndW-\u0001\rsK6|g/\u001a\"bg\u0016d\u0015N\\3%I\u00164\u0017-\u001e7uII*\u0012\u0001\u0013\u0016\u0003\u0001&[\u0013A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005=\u0013\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011\u000b\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD0sK6|g/\u001a\"bg\u0016d\u0015N\\3\u0015\tM\"VK\u0018\u0005\u0006{\u0019\u0001\ra\r\u0005\u0006-\u001a\u0001\raV\u0001\u000beRLe\u000e\u001e)bSJ\u001c\bcA\u001151B!\u0011%W.D\u0013\tQ&E\u0001\u0004UkBdWM\r\t\u0003CqK!!\u0018\u0012\u0003\u000b\u0019cw.\u0019;\t\u000b}3\u0001\u0019A\"\u0002\u001d9|\u0017n]3UQJ,7\u000f[8mIR\u0011q+\u0019\u0005\u0006-\u001e\u0001\ra\u0016\u000b\u0004/\u000e$\u0007\"\u0002,\t\u0001\u00049\u0006\"B0\t\u0001\u0004\u0019\u0015A\b4j]\u0012tu.[:f\rJ,W\rU3bW\u001e\u0013x.\u001e9t\u0013:$\u0017nY3t)\r9\u0017N\u001b\t\u0004CQB\u0007\u0003B\u0011ZO\u001dBQAV\u0005A\u0002]CQaX\u0005A\u0002\r\u000b!cY1mG:{\u0017n]3UQJ,7\u000f[8mIR\u00111)\u001c\u0005\u0006-*\u0001\raV\u0001\u000f?\u000e\fGnY'fC:\fe\u000eZ*e)\t\u0001\u0018\u000f\u0005\u0003\"3\u000e\u001b\u0005\"\u0002:\f\u0001\u0004\u0019\u0018A\u0002<bYV,7\u000fE\u0002\"i\r\u000bqBQ1tK2Lg.\u001a*f[>4XM\u001d\t\u0003]5\u0019\"!\u0004\u0011\u0015\u0003U\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#\u0001>+\u0005\u001dJ\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007")
public class BaselineRemover {
    private final int gapTolerance;
    private final int minPeaksCount;

    public static int $lessinit$greater$default$2() {
        return BaselineRemover$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$1() {
        return BaselineRemover$.MODULE$.$lessinit$greater$default$1();
    }

    public Peak[] removeBaseLine(Peak[] peaks, Option<Object> noiseThresholdOpt) {
        Predef$.MODULE$.require(peaks != null, (Function0 & Serializable & scala.Serializable)() -> "peaks is null");
        Tuple2[] rtIntPairs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).map((Function1 & Serializable & scala.Serializable)peak -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToFloat((float)peak.getLcContext().getElutionTime())), (Object)BoxesRunTime.boxToDouble((double)peak.getIntensity())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        double noiseThreshold = BoxesRunTime.unboxToDouble((Object)noiseThresholdOpt.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.calcNoiseThreshold(rtIntPairs)));
        return this._removeBaseLine(peaks, rtIntPairs, noiseThreshold);
    }

    private Peak[] _removeBaseLine(Peak[] peaks, Tuple2<Object, Object>[] rtIntPairs, double noiseThreshold) {
        Tuple2<Object, Object>[] noiseFreePeakGroupsIndices = this.findNoiseFreePeakGroupsIndices(rtIntPairs, noiseThreshold);
        ArrayBuffer peaksAboveThreshold = new ArrayBuffer(peaks.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])noiseFreePeakGroupsIndices)).foreach((Function1 & Serializable & scala.Serializable)noiseFreePeakGroupIndices -> {
            Tuple2 tuple2 = noiseFreePeakGroupIndices;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int firstIndex = tuple2._1$mcI$sp();
            int lastIndex = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(firstIndex, lastIndex);
            Tuple2.mcII.sp sp3 = sp2;
            int firstIndex2 = sp3._1$mcI$sp();
            int lastIndex2 = sp3._2$mcI$sp();
            return peaksAboveThreshold.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).slice(firstIndex2, lastIndex2 + 1))));
        });
        return (Peak[])peaksAboveThreshold.toArray(ClassTag$.MODULE$.apply(Peak.class));
    }

    public Tuple2<Object, Object>[] removeBaseLine(Tuple2<Object, Object>[] rtIntPairs) {
        Predef$.MODULE$.require(rtIntPairs != null, (Function0 & Serializable & scala.Serializable)() -> "rtIntPairs is null");
        return this.removeBaseLine(rtIntPairs, this.calcNoiseThreshold(rtIntPairs));
    }

    public Tuple2<Object, Object>[] removeBaseLine(Tuple2<Object, Object>[] rtIntPairs, double noiseThreshold) {
        Tuple2<Object, Object>[] noiseFreePeakGroupsIndices = this.findNoiseFreePeakGroupsIndices(rtIntPairs, noiseThreshold);
        ArrayBuffer rtIntPairsAboveThreshold = new ArrayBuffer(rtIntPairs.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])noiseFreePeakGroupsIndices)).foreach((Function1 & Serializable & scala.Serializable)noiseFreePeakGroupIndices -> {
            Tuple2 tuple2 = noiseFreePeakGroupIndices;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int firstIndex = tuple2._1$mcI$sp();
            int lastIndex = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(firstIndex, lastIndex);
            Tuple2.mcII.sp sp3 = sp2;
            int firstIndex2 = sp3._1$mcI$sp();
            int lastIndex2 = sp3._2$mcI$sp();
            return rtIntPairsAboveThreshold.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rtIntPairs)).slice(firstIndex2, lastIndex2 + 1))));
        });
        return (Tuple2[])rtIntPairsAboveThreshold.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Option<Object> removeBaseLine$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Object, Object>[] findNoiseFreePeakGroupsIndices(Tuple2<Object, Object>[] rtIntPairs, double noiseThreshold) {
        Predef$.MODULE$.require(rtIntPairs != null, (Function0 & Serializable & scala.Serializable)() -> "rtIntPairs is null");
        ArrayBuffer groupedRtIntPairIndices = new ArrayBuffer();
        ObjectRef rtIntPairGroupIndices = ObjectRef.create((Object)new ArrayBuffer());
        IntRef underThresholdCount = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rtIntPairs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BaselineRemover.$anonfun$findNoiseFreePeakGroupsIndices$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            BaselineRemover.$anonfun$findNoiseFreePeakGroupsIndices$3(this, noiseThreshold, underThresholdCount, groupedRtIntPairIndices, rtIntPairGroupIndices, x$3);
            return BoxedUnit.UNIT;
        });
        groupedRtIntPairIndices.$plus$eq((Object)((ArrayBuffer)rtIntPairGroupIndices.elem));
        int rtIntPairsCount = rtIntPairs.length;
        ArrayBuffer rtIntPairsIndicesAboveThreshold = new ArrayBuffer();
        groupedRtIntPairIndices.withFilter((Function1 & Serializable & scala.Serializable)rtIntPairIndices -> BoxesRunTime.boxToBoolean((boolean)BaselineRemover.$anonfun$findNoiseFreePeakGroupsIndices$4(this, rtIntPairIndices))).foreach((Function1 & Serializable & scala.Serializable)rtIntPairIndices -> {
            int firstIndex = BoxesRunTime.unboxToInt((Object)rtIntPairIndices.head());
            int lastIndex = BoxesRunTime.unboxToInt((Object)rtIntPairIndices.last());
            int extendedFirstIndex = firstIndex == 0 ? firstIndex : firstIndex - 1;
            int extendedLastIndex = lastIndex == rtIntPairsCount - 1 ? lastIndex : lastIndex + 1;
            return rtIntPairsIndicesAboveThreshold.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)extendedFirstIndex)), (Object)BoxesRunTime.boxToInteger((int)extendedLastIndex)));
        });
        return (Tuple2[])rtIntPairsIndicesAboveThreshold.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double calcNoiseThreshold(Tuple2<Object, Object>[] rtIntPairs) {
        Predef$.MODULE$.require(rtIntPairs != null, (Function0 & Serializable & scala.Serializable)() -> "rtIntPairs is null");
        package.EntityHistogramComputer intensityHistoComputer = new package.EntityHistogramComputer((Seq)Predef$.MODULE$.wrapRefArray((Object[])rtIntPairs), (Function1 & Serializable & scala.Serializable)rtIntPair -> BoxesRunTime.boxToDouble((double)rtIntPair._2$mcD$sp()));
        Tuple2[] intensityHisto = intensityHistoComputer.calcHistogram(20, intensityHistoComputer.calcHistogram$default$2());
        Tuple2[] indexedHisto = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])intensityHisto)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Option firstTupleWithMinimumFreqOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexedHisto)).sliding(3).find((Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToBoolean((boolean)BaselineRemover.$anonfun$calcNoiseThreshold$3(buffer)));
        if (firstTupleWithMinimumFreqOpt.isEmpty()) {
            return 0.0;
        }
        Tuple2 firstMinimumFreq = ((Tuple2[])firstTupleWithMinimumFreqOpt.get())[1];
        int maxFreqAfterFirstMinimum = ((SeqLike)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])intensityHisto)).slice(firstMinimumFreq._2$mcI$sp(), intensityHisto.length))).maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BaselineRemover.$anonfun$calcNoiseThreshold$4(x$4)), (Ordering)Ordering.Int$.MODULE$))._2()).length();
        return ((Bin)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])intensityHisto)).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)BaselineRemover.$anonfun$calcNoiseThreshold$5(maxFreqAfterFirstMinimum, x$5))).get())._1()).lowerBound();
    }

    private Tuple2<Object, Object> _calcMeanAndSd(double[] values) {
        double mean = StatUtils.mean((double[])values);
        double variance = StatUtils.variance((double[])values, (double)mean);
        return new Tuple2.mcDD.sp(mean, package$.MODULE$.sqrt(variance));
    }

    public static final /* synthetic */ boolean $anonfun$findNoiseFreePeakGroupsIndices$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$findNoiseFreePeakGroupsIndices$3(BaselineRemover $this, double noiseThreshold$1, IntRef underThresholdCount$1, ArrayBuffer groupedRtIntPairIndices$1, ObjectRef rtIntPairGroupIndices$1, Tuple2 x$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            boolean isUnderThreshold;
            Tuple2 rtIntPair = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            boolean bl = isUnderThreshold = rtIntPair._2$mcD$sp() < noiseThreshold$1;
            if (isUnderThreshold) {
                ++underThresholdCount$1.elem;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (underThresholdCount$1.elem > $this.gapTolerance) {
                    groupedRtIntPairIndices$1.$plus$eq((Object)((ArrayBuffer)rtIntPairGroupIndices$1.elem));
                    rtIntPairGroupIndices$1.elem = new ArrayBuffer();
                }
                ((ArrayBuffer)rtIntPairGroupIndices$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)index));
                underThresholdCount$1.elem = 0;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findNoiseFreePeakGroupsIndices$4(BaselineRemover $this, ArrayBuffer rtIntPairIndices) {
        return rtIntPairIndices.length() >= $this.minPeaksCount;
    }

    public static final /* synthetic */ boolean $anonfun$calcNoiseThreshold$3(Tuple2[] buffer) {
        int freq1 = ((SeqLike)((Tuple2)buffer[0]._1())._2()).length();
        int freq2 = ((SeqLike)((Tuple2)buffer[1]._1())._2()).length();
        int freq3 = ((SeqLike)((Tuple2)buffer[2]._1())._2()).length();
        return freq2 < freq1 && freq3 >= freq2;
    }

    public static final /* synthetic */ int $anonfun$calcNoiseThreshold$4(Tuple2 x$4) {
        return ((SeqLike)x$4._2()).length();
    }

    public static final /* synthetic */ boolean $anonfun$calcNoiseThreshold$5(int maxFreqAfterFirstMinimum$1, Tuple2 x$5) {
        return ((SeqLike)x$5._2()).length() <= maxFreqAfterFirstMinimum$1;
    }

    public BaselineRemover(int gapTolerance, int minPeaksCount) {
        this.gapTolerance = gapTolerance;
        this.minPeaksCount = minPeaksCount;
        Predef$.MODULE$.require(gapTolerance >= 1, (Function0 & Serializable & scala.Serializable)() -> "gapTolerance must be strictly positive");
    }
}

