/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.math;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class VectorSimilarity$ {
    public static VectorSimilarity$ MODULE$;

    static {
        new VectorSimilarity$();
    }

    public <T> double dot(Iterable<T> as, Iterable<T> bs, Function2<T, T, Object> f) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)as.zip(bs, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)VectorSimilarity$.$anonfun$dot$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)VectorSimilarity$.$anonfun$dot$2(f, x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double dotProduct(double[] vector1, double[] vector2) {
        return this.dot((Iterable)Predef$.MODULE$.wrapDoubleArray(vector1), (Iterable)Predef$.MODULE$.wrapDoubleArray(vector2), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 * x$3);
    }

    public double dotProduct(float[] vector1, float[] vector2) {
        return this.dot((Iterable)Predef$.MODULE$.wrapFloatArray(vector1), (Iterable)Predef$.MODULE$.wrapFloatArray(vector2), (Function2)(Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToDouble((double)VectorSimilarity$.$anonfun$dotProduct$2(BoxesRunTime.unboxToFloat((Object)x$4), BoxesRunTime.unboxToFloat((Object)x$5))));
    }

    public double dotProduct(int[] vector1, int[] vector2) {
        return this.dot((Iterable)Predef$.MODULE$.wrapIntArray(vector1), (Iterable)Predef$.MODULE$.wrapIntArray(vector2), (Function2)(JFunction2.mcDII.sp & Serializable & scala.Serializable)(x$6, x$7) -> x$6 * x$7);
    }

    public double magnitude(double[] vector) {
        return package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector)).fold((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x2Sum, x) -> x2Sum + x * x)));
    }

    public double cosineSimilarity(double[] vector1, double[] vector2) {
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector1)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector2)).size(), (Function0 & Serializable & scala.Serializable)() -> "vectors must have same length");
        return this.dotProduct(vector1, vector2) / (this.magnitude(vector1) * this.magnitude(vector2));
    }

    public double uncenteredCorrelation(double[] vector1, double[] vector2) {
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector1)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector2)).size(), (Function0 & Serializable & scala.Serializable)() -> "vectors must have same length");
        int N = vector1.length;
        double sum_coproduct = 0.0;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        int i = -1;
        while (i < N) {
            double x = vector1[++i];
            double y = vector2[i];
            sum_coproduct += x * y;
            sum_sq_x += x * x;
            sum_sq_y += y * y;
        }
        return sum_coproduct / package$.MODULE$.sqrt(sum_sq_x * sum_sq_y);
    }

    public double squaredPearsonCorrelation(float[] vector1, float[] vector2) {
        return package$.MODULE$.pow(this.pearsonCorrelation(vector1, vector2), 2.0);
    }

    public double squaredPearsonCorrelation(double[] vector1, double[] vector2) {
        return package$.MODULE$.pow(this.pearsonCorrelation(vector1, vector2), 2.0);
    }

    public double pearsonCorrelation(float[] vector1, float[] vector2) {
        return this.pearsonCorrelation((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vector1)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$8 -> x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vector2)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$9 -> x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public double pearsonCorrelation(double[] vector1, double[] vector2) {
        int N = vector1.length;
        Predef$.MODULE$.require(N == vector2.length, (Function0 & Serializable & scala.Serializable)() -> "vectors must have same length");
        Predef$.MODULE$.require(N > 0, (Function0 & Serializable & scala.Serializable)() -> "vectors must contain data");
        DoubleRef sum_sq_x = DoubleRef.create((double)0.0);
        DoubleRef sum_sq_y = DoubleRef.create((double)0.0);
        DoubleRef sum_coproduct = DoubleRef.create((double)0.0);
        DoubleRef mean_x = DoubleRef.create((double)vector1[0]);
        DoubleRef mean_y = DoubleRef.create((double)vector2[0]);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double sweep = ((double)i - 1.0) / (double)i;
            double delta_x = vector1[i - 1] - mean_x$1.elem;
            double delta_y = vector2[i - 1] - mean_y$1.elem;
            sum_sq_x$1.elem += delta_x * delta_x * sweep;
            sum_sq_y$1.elem += delta_y * delta_y * sweep;
            sum_coproduct$1.elem += delta_x * delta_y * sweep;
            mean_x$1.elem += delta_x / (double)i;
            mean_y$1.elem += delta_y / (double)i;
        });
        double pop_sd_x = package$.MODULE$.sqrt(sum_sq_x.elem / (double)N);
        double pop_sd_y = package$.MODULE$.sqrt(sum_sq_y.elem / (double)N);
        double cov_x_y = sum_coproduct.elem / (double)N;
        return cov_x_y / (pop_sd_x * pop_sd_y);
    }

    public double rmsd(double[] vector1, double[] vector2) {
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector1)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector2)).size(), (Function0 & Serializable & scala.Serializable)() -> "vectors must have same length");
        double sumSquare = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)vector1, (Object)vector2)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs))), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.pow(y - x, 2.0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return package$.MODULE$.sqrt(sumSquare / (double)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector1)).size());
    }

    public static final /* synthetic */ boolean $anonfun$dot$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$dot$2(Function2 f$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object a = tuple2._1();
        Object b = tuple2._2();
        double d = BoxesRunTime.unboxToDouble((Object)f$1.apply(a, b));
        return d;
    }

    public static final /* synthetic */ double $anonfun$dotProduct$2(float x$4, float x$5) {
        return x$4 * x$5;
    }

    private VectorSimilarity$() {
        MODULE$ = this;
    }
}

