/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.bruker.timstof.model;

import com.sun.jna.Pointer;
import fr.profi.bruker.timstof.TDFLibrary;
import java.util.HashMap;
import java.util.Map;

public class MsMsCallbacks {

    public static class MsMsSpectrum {
        public double[] mz_values;
        public float[] intensity_values;
        public int nbPeaks;
    }

    public static class MultipleMsMsData
    implements TDFLibrary.MsMsCallback {
        Map<Long, MsMsSpectrum> msmsSpectraByPrecursorId = new HashMap<Long, MsMsSpectrum>();

        @Override
        public void invoke(long precursor_id, int num_peaks, Pointer pMz, Pointer pIntensites) {
            MsMsSpectrum msMsSpectrum = new MsMsSpectrum();
            msMsSpectrum.nbPeaks = num_peaks;
            msMsSpectrum.mz_values = pMz.getDoubleArray(0L, num_peaks);
            msMsSpectrum.intensity_values = pIntensites.getFloatArray(0L, num_peaks);
            this.msmsSpectraByPrecursorId.put(precursor_id, msMsSpectrum);
        }

        public Map<Long, MsMsSpectrum> getMsMsSpectra() {
            return new HashMap<Long, MsMsSpectrum>(this.msmsSpectraByPrecursorId);
        }
    }

    public static class MsMsData
    implements TDFLibrary.MsMsCallback {
        long precursorId = 0L;
        int numPeaks = 0;
        double[] mz_values;
        float[] intensity_values;

        @Override
        public void invoke(long precursor_id, int num_peaks, Pointer pMz, Pointer pIntensites) {
            this.precursorId = precursor_id;
            this.numPeaks = num_peaks;
            this.mz_values = pMz.getDoubleArray(0L, num_peaks);
            this.intensity_values = pIntensites.getFloatArray(0L, num_peaks);
        }
    }
}

