/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.almworks.sqlite4java.SQLiteConnection;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumSlice;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MzDbPatternPredictor$
implements IIsotopicPatternPredictor {
    public static MzDbPatternPredictor$ MODULE$;
    private final IIsotopicPatternScorer isotopicPatternScorer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MzDbPatternPredictor$();
    }

    @Override
    public boolean isMatchReliable(SpectrumData spectrumData, double ppm, double moz, int charge, double mozTolInDa) {
        return IIsotopicPatternPredictor.isMatchReliable$(this, spectrumData, ppm, moz, charge, mozTolInDa);
    }

    @Override
    public IIsotopicPatternScorer isotopicPatternScorer() {
        return this.isotopicPatternScorer;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternPredictor$_setter_$isotopicPatternScorer_$eq(IIsotopicPatternScorer x$1) {
        this.isotopicPatternScorer = x$1;
    }

    private Logger logger$lzycompute() {
        MzDbPatternPredictor$ mzDbPatternPredictor$ = this;
        synchronized (mzDbPatternPredictor$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Tuple2<Object, TheoreticalIsotopePattern> getBestExplanation(MzDbReader reader, SQLiteConnection sqliteConn, Peakel peakel, double mozTolInDa) {
        double apexMz = peakel.getApexMz();
        float apexRt = peakel.getApexElutionTime();
        SpectrumSlice[] slices = reader.getMsSpectrumSlices(apexMz - (double)5, apexMz + (double)5, apexRt - 0.1f, apexRt + 0.1f);
        Option sliceOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slices)).find((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MzDbPatternPredictor$.$anonfun$getBestExplanation$1(peakel, x$1)));
        float ppmTol = peakel.getLeftHwhmMean() == 0.0f ? (float)(1000000.0 * mozTolInDa / peakel.getApexMz()) : (float)(1000000.0 * (double)peakel.getLeftHwhmMean() / apexMz);
        Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = this.isotopicPatternScorer().calcIsotopicPatternHypotheses(((Spectrum)sliceOpt.get()).getData(), peakel.getApexMz(), ppmTol);
        return this.isotopicPatternScorer().selectBestPatternHypothese(putativePatterns, this.isotopicPatternScorer().selectBestPatternHypothese$default$2());
    }

    public ArrayBuffer<Tuple2<Peakel, Object>> assessReliability(MzDbReader reader, SQLiteConnection sqliteConn, Peakel[] matchingPeakels, int charge, double mozTolInDa) {
        ArrayBuffer filteredPeakels = new ArrayBuffer(matchingPeakels.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingPeakels)).foreach((Function1 & java.io.Serializable & Serializable)matchingPeakel -> {
            BoxedUnit boxedUnit;
            float apexRt;
            double apexMz = matchingPeakel.getApexMz();
            SpectrumSlice[] slices = reader.getMsSpectrumSlices(apexMz - (double)5, apexMz + (double)5, (apexRt = matchingPeakel.getApexElutionTime()) - 0.1f, apexRt + 0.1f);
            Option sliceOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slices)).find((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MzDbPatternPredictor$.$anonfun$assessReliability$2(matchingPeakel, x$2)));
            if (sliceOpt.isDefined()) {
                float ppm = matchingPeakel.getLeftHwhmMean() == 0.0f ? (float)(1000000.0 * mozTolInDa / matchingPeakel.getApexMz()) : (float)(1000000.0 * (double)matchingPeakel.getLeftHwhmMean() / apexMz);
                boolean isReliable = MODULE$.isMatchReliable(((Spectrum)sliceOpt.get()).getData(), ppm, matchingPeakel.getApexMz(), charge, mozTolInDa);
                boxedUnit = filteredPeakels.$plus$eq((Object)new Tuple2(matchingPeakel, (Object)BoxesRunTime.boxToBoolean((boolean)isReliable)));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return filteredPeakels;
    }

    public static final /* synthetic */ boolean $anonfun$getBestExplanation$1(Peakel peakel$1, SpectrumSlice x$1) {
        return x$1.getHeader().getSpectrumId() == peakel$1.getApexSpectrumId();
    }

    public static final /* synthetic */ boolean $anonfun$assessReliability$2(Peakel matchingPeakel$1, SpectrumSlice x$2) {
        return x$2.getHeader().getSpectrumId() == matchingPeakel$1.getApexSpectrumId();
    }

    private MzDbPatternPredictor$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        IIsotopicPatternPredictor.$init$(this);
    }
}

