/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.feature.extraction;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternInterpolator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.feature.extraction.AbstractSupervisedFtExtractor;
import fr.profi.mzdb.algo.feature.extraction.DetectionAlgorithm$;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.OverlappingFeaturesExtractor$;
import fr.profi.mzdb.algo.feature.extraction.OverlappingStatus;
import fr.profi.mzdb.algo.feature.extraction.PeakelDetectionConfig;
import fr.profi.mzdb.algo.feature.scoring.FeatureScorer$;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.FeatureOverlapProperties;
import fr.profi.mzdb.model.FeatureOverlapProperties$;
import fr.profi.mzdb.model.OverlappingFeature;
import fr.profi.mzdb.model.PeakListTree;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.SpectrumHeader;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\f\u0019\u0011\u0003)c!B\u0014\u0019\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0001\u0004%\tA\r\u0005\b\u007f\u0005\u0001\r\u0011\"\u0001A\u0011\u00191\u0015\u0001)Q\u0005g!9q)AI\u0001\n\u0003Ae\u0001B\u0014\u0019\u0001yC\u0001\"[\u0004\u0003\u0006\u0004%\tA\u001b\u0005\te\u001e\u0011\t\u0011)A\u0005W\"A1o\u0002BC\u0002\u0013\u0005A\u000f\u0003\u0005v\u000f\t\u0005\t\u0015!\u0003K\u0011!1xA!b\u0001\n\u00039\b\u0002C>\b\u0005\u0003\u0005\u000b\u0011\u0002=\t\u000b=:A\u0011\u0001?\t\u0013\u0005\rqA1A\u0005\u0002\u0005\u0015\u0001\u0002CA\u0007\u000f\u0001\u0006I!a\u0002\t\u0013\u0005=qA1A\u0005\u0002\u0005E\u0001\u0002CA\r\u000f\u0001\u0006I!a\u0005\t\u000f\u0005mq\u0001\"\u0001\u0002\u001e!9\u00111J\u0004\u0005\n\u00055\u0003bBA2\u000f\u0011%\u0011Q\r\u0005\b\u0003[:A\u0011BA8\u0003qye/\u001a:mCB\u0004\u0018N\\4GK\u0006$XO]3t\u000bb$(/Y2u_JT!!\u0007\u000e\u0002\u0015\u0015DHO]1di&|gN\u0003\u0002\u001c9\u00059a-Z1ukJ,'BA\u000f\u001f\u0003\u0011\tGnZ8\u000b\u0005}\u0001\u0013\u0001B7{I\nT!!\t\u0012\u0002\u000bA\u0014xNZ5\u000b\u0003\r\n!A\u001a:\u0004\u0001A\u0011a%A\u0007\u00021\tarJ^3sY\u0006\u0004\b/\u001b8h\r\u0016\fG/\u001e:fg\u0016CHO]1di>\u00148CA\u0001*!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!J\u0001\r]>tWj\u001c8p\u0007>,h\u000e^\u000b\u0002gA\u0011A'P\u0007\u0002k)\u0011agN\u0001\u0007CR|W.[2\u000b\u0005aJ\u0014AC2p]\u000e,(O]3oi*\u0011!hO\u0001\u0005kRLGNC\u0001=\u0003\u0011Q\u0017M^1\n\u0005y*$AC!u_6L7\rT8oO\u0006\u0001bn\u001c8N_:|7i\\;oi~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"A\u000b\"\n\u0005\r[#\u0001B+oSRDq!\u0012\u0003\u0002\u0002\u0003\u00071'A\u0002yIE\nQB\\8o\u001b>twnQ8v]R\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001JU\tQU\u000bE\u0002L!Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bq!\\;uC\ndWM\u0003\u0002PW\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ec%a\u0002'p]\u001el\u0015\r\u001d\t\u0003UMK!\u0001V\u0016\u0003\u000b\u0019cw.\u0019;,\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0013Ut7\r[3dW\u0016$'BA.,\u0003)\tgN\\8uCRLwN\\\u0005\u0003;b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f'\r9\u0011f\u0018\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\fAb]2bY\u0006dwnZ4j]\u001eT!\u0001Z3\u0002\u0011QL\b/Z:bM\u0016T\u0011AZ\u0001\u0004G>l\u0017B\u00015b\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002%M\u0004Xm\u0019;sk6DU-\u00193fe\nK\u0018\nZ\u000b\u0002WB\u00191\n\u00157\u0011\u00055\u0004X\"\u00018\u000b\u0005=t\u0012!B7pI\u0016d\u0017BA9o\u00059\u0019\u0006/Z2ueVl\u0007*Z1eKJ\f1c\u001d9fGR\u0014X/\u001c%fC\u0012,'OQ=JI\u0002\naB\u001c4CsN\u0003Xm\u0019;sk6LE-F\u0001K\u0003=qgMQ=Ta\u0016\u001cGO];n\u0013\u0012\u0004\u0013a\u00034u\u000bb$(/Y2u_J,\u0012\u0001\u001f\t\u0003MeL!A\u001f\r\u0003;\u0005\u00137\u000f\u001e:bGR\u001cV\u000f]3sm&\u001cX\r\u001a$u\u000bb$(/Y2u_J\fAB\u001a;FqR\u0014\u0018m\u0019;pe\u0002\"R! @\u0000\u0003\u0003\u0001\"AJ\u0004\t\u000b%t\u0001\u0019A6\t\u000fMt\u0001\u0013!a\u0001\u0015\")aO\u0004a\u0001q\u0006a\u0001\u0010\u001e:bGR\u001cuN\u001c4jOV\u0011\u0011q\u0001\t\u0004M\u0005%\u0011bAA\u00061\t1b)Z1ukJ,W\t\u001f;sC\u000e$xN]\"p]\u001aLw-A\u0007yiJ\f7\r^\"p]\u001aLw\rI\u0001\u0014_Z,'\u000f\\1q1R\u0014\u0018m\u0019;D_:4\u0017nZ\u000b\u0003\u0003'\u00012AJA\u000b\u0013\r\t9\u0002\u0007\u0002\"\u001fZ,'\u000f\\1qa&twMR3biV\u0014X-\u0012=ue\u0006\u001cGo\u001c:D_:4\u0017nZ\u0001\u0015_Z,'\u000f\\1q1R\u0014\u0018m\u0019;D_:4\u0017n\u001a\u0011\u00025\u0015DHO]1di>3XM\u001d7baBLgn\u001a$fCR,(/Z:\u0015\u0011\u0005}\u0011QEA\u0018\u0003\u0003\u00022AJA\u0011\u0013\r\t\u0019\u0003\u0007\u0002\u0012\u001fZ,'\u000f\\1qa&twm\u0015;biV\u001c\bbBA\u0014'\u0001\u0007\u0011\u0011F\u0001\u0003MR\u00042!\\A\u0016\u0013\r\tiC\u001c\u0002\b\r\u0016\fG/\u001e:f\u0011\u001d\t\td\u0005a\u0001\u0003g\ta\u0001\u001e5f_&\u0003\u0006\u0003BA\u001b\u0003{i!!a\u000e\u000b\u0007=\fIDC\u0002\u0002<\u0001\n!!\\:\n\t\u0005}\u0012q\u0007\u0002\u001a)\",wN]3uS\u000e\fG.S:pi>\u0004X\rU1ui\u0016\u0014h\u000eC\u0004\u0002DM\u0001\r!!\u0012\u0002\u000fA\\G\u000e\u0016:fKB\u0019Q.a\u0012\n\u0007\u0005%cN\u0001\u0007QK\u0006\\G*[:u)J,W-A\u000e`Kb$(/Y2u\u001fZ,'\u000f\\1qa&twMR3biV\u0014Xm\u001d\u000b\t\u0003\u001f\n)&a\u0016\u0002bA)!&!\u0015\u0002*%\u0019\u00111K\u0016\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005\u001dB\u00031\u0001\u0002*!9\u0011\u0011\f\u000bA\u0002\u0005m\u0013a\u00014u5B\u0019!&!\u0018\n\u0007\u0005}3FA\u0002J]RDq!a\u0011\u0015\u0001\u0004\t)%\u0001\u000e`KZ\fG.^1uK>3XM\u001d7baBLgnZ*uCR,8\u000f\u0006\u0004\u0002 \u0005\u001d\u0014\u0011\u000e\u0005\b\u0003O)\u0002\u0019AA\u0015\u0011\u001d\tY'\u0006a\u0001\u0003\u001f\n1b\u001c<m\r\u0016\fG/\u001e:fg\u0006qrl]3mK\u000e$()Z:u\u001fZ,'\u000f\\1qa&twMR3biV\u0014Xm\u001d\u000b\u0007\u0003c\nI(a\u001f\u0011\u000b)\n\t&a\u001d\u0011\u00075\f)(C\u0002\u0002x9\u0014!c\u0014<fe2\f\u0007\u000f]5oO\u001a+\u0017\r^;sK\"9\u0011q\u0005\fA\u0002\u0005%\u0002bBA?-\u0001\u0007\u0011qJ\u0001\u0007_Zdg\t^:")
public class OverlappingFeaturesExtractor
implements LazyLogging {
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final LongMap<Object> nfBySpectrumId;
    private final AbstractSupervisedFtExtractor ftExtractor;
    private final FeatureExtractorConfig xtractConfig;
    private final OverlappingFeatureExtractorConfig overlapXtractConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static LongMap<Object> $lessinit$greater$default$2() {
        return OverlappingFeaturesExtractor$.MODULE$.$lessinit$greater$default$2();
    }

    public static void nonMonoCount_$eq(AtomicLong atomicLong) {
        OverlappingFeaturesExtractor$.MODULE$.nonMonoCount_$eq(atomicLong);
    }

    public static AtomicLong nonMonoCount() {
        return OverlappingFeaturesExtractor$.MODULE$.nonMonoCount();
    }

    private Logger logger$lzycompute() {
        OverlappingFeaturesExtractor overlappingFeaturesExtractor = this;
        synchronized (overlappingFeaturesExtractor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    public LongMap<Object> nfBySpectrumId() {
        return this.nfBySpectrumId;
    }

    public AbstractSupervisedFtExtractor ftExtractor() {
        return this.ftExtractor;
    }

    public FeatureExtractorConfig xtractConfig() {
        return this.xtractConfig;
    }

    public OverlappingFeatureExtractorConfig overlapXtractConfig() {
        return this.overlapXtractConfig;
    }

    public OverlappingStatus extractOverlappingFeatures(Feature ft, TheoreticalIsotopePattern theoIP, PeakListTree pklTree) {
        Predef$.MODULE$.require(!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ft.indexedPeakels())).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "can not extract overlapping features of an empty feature. Returning Error");
        Feature[] ovlFeatures = this._extractOverlappingFeatures(ft, ft.charge(), pklTree);
        return this._evaluateOverlappingStatus(ft, ovlFeatures);
    }

    private Feature[] _extractOverlappingFeatures(Feature ft, int ftZ, PeakListTree pklTree) {
        int minZ = 2;
        int maxZ = 3;
        int maxIpShift = this.overlapXtractConfig().extractAllOvlFts() ? this.overlapXtractConfig().maxIpShift() : 1;
        float mzTolPPM = this.xtractConfig().mzTolPPM();
        Predef$.MODULE$.require(maxZ > 0, (Function0 & Serializable & scala.Serializable)() -> "maximum charge must be strictly positive");
        Predef$.MODULE$.require(maxIpShift > 0, (Function0 & Serializable & scala.Serializable)() -> "maximum IP shift must be strictly positive");
        Peakel firstFtPeakel = ft.getFirstPeakel();
        double firstFtMz = firstFtPeakel.getMz();
        long maxSpectrumId = firstFtPeakel.getApexSpectrumId();
        Predef$.MODULE$.require(maxSpectrumId != 0L);
        ArrayBuffer ovlFts = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minZ), maxZ).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)z -> Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-maxIpShift), 0).foreach((Function1 & Serializable & scala.Serializable)ipShift -> OverlappingFeaturesExtractor.$anonfun$_extractOverlappingFeatures$5(this, firstFtMz, z, maxSpectrumId, pklTree, ovlFts, BoxesRunTime.unboxToInt((Object)ipShift)))));
        return (Feature[])ovlFts.toArray(ClassTag$.MODULE$.apply(Feature.class));
    }

    private OverlappingStatus _evaluateOverlappingStatus(Feature ft, Feature[] ovlFeatures) {
        FeatureOverlapProperties featureOverlapProperties;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ovlFeatures)).isEmpty()) {
            return new OverlappingStatus(false, false, null, null);
        }
        boolean overlapEvidence = true;
        OverlappingFeature[] bestOvlFts = this._selectBestOverlappingFeatures(ft, ovlFeatures);
        if (ft.overlapProperties() != null) {
            featureOverlapProperties = ft.overlapProperties();
        } else {
            ft.overlapProperties_$eq(new FeatureOverlapProperties(FeatureOverlapProperties$.MODULE$.apply$default$1(), FeatureOverlapProperties$.MODULE$.apply$default$2(), FeatureOverlapProperties$.MODULE$.apply$default$3(), FeatureOverlapProperties$.MODULE$.apply$default$4()));
            featureOverlapProperties = ft.overlapProperties();
        }
        FeatureOverlapProperties ftOverlapProperties = featureOverlapProperties;
        ftOverlapProperties.overlappingFeatures_$eq(bestOvlFts);
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bestOvlFts)).isEmpty()) {
            OverlappingFeature[] sortedOvlFts = (OverlappingFeature[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bestOvlFts)).sortBy((Function1 & Serializable & scala.Serializable)ovlFt -> BoxesRunTime.boxToFloat((float)OverlappingFeaturesExtractor.$anonfun$_evaluateOverlappingStatus$1(ovlFt)), (Ordering)Ordering.Float$.MODULE$);
            ftOverlapProperties.bestOverlappingFeature_$eq((OverlappingFeature)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedOvlFts)).last());
        }
        return new OverlappingStatus(true, !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bestOvlFts)).isEmpty(), ovlFeatures, bestOvlFts);
    }

    private OverlappingFeature[] _selectBestOverlappingFeatures(Feature ft, Feature[] ovlFts) {
        ArrayBuffer bestOvlFeatures = new ArrayBuffer();
        Peakel monoFtPeakel = ft.getFirstPeakel();
        double currFtMonoMz = monoFtPeakel.getMz();
        float minCorr = this.overlapXtractConfig().minPeakelCorrToMono();
        float minApexDistance = this.overlapXtractConfig().minApexDistance();
        float minAveragineRatio = this.overlapXtractConfig().minAveragineRatio();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ovlFts)).foreach((Function1 & Serializable & scala.Serializable)ovlFt -> {
            BoxedUnit boxedUnit;
            float quotient;
            Tuple2 prevOvlFtPeakelWithIdx = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ovlFt.indexedPeakels())).minBy((Function1 & Serializable & scala.Serializable)pWithIdx -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(((Peakel)pWithIdx._1()).getMz() + 1.0027 / (double)ovlFt.getCharge() - currFtMonoMz)), (Ordering)Ordering.Double$.MODULE$);
            Tuple2 tuple2 = prevOvlFtPeakelWithIdx;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Peakel prevOvlFtPeakel = (Peakel)tuple2._1();
            int prevOvlFtPeakelIdx = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)prevOvlFtPeakel, (Object)BoxesRunTime.boxToInteger((int)prevOvlFtPeakelIdx));
            Tuple2 tuple23 = tuple22;
            Peakel prevOvlFtPeakel2 = (Peakel)tuple23._1();
            int prevOvlFtPeakelIdx2 = tuple23._2$mcI$sp();
            int monoisotopicIndex = 0;
            int apexDistanceInCycle = package$.MODULE$.abs(((SpectrumHeader)this.spectrumHeaderById().apply(prevOvlFtPeakel2.getApexSpectrumId())).getCycle() - ((SpectrumHeader)this.spectrumHeaderById().apply(monoFtPeakel.getApexSpectrumId())).getCycle());
            float correlation = (float)FeatureScorer$.MODULE$.calcPeakelCorrelation(prevOvlFtPeakel2, monoFtPeakel);
            TheoreticalIsotopePattern theoIP = IsotopePatternInterpolator$.MODULE$.getTheoreticalPattern(ovlFt.mz(), ovlFt.charge());
            float[] abundances = theoIP.abundances();
            float theoriticalQuotient = abundances[monoisotopicIndex] / abundances[monoisotopicIndex + 1];
            float observedQuotient = prevOvlFtPeakel2.area() / monoFtPeakel.area();
            float f = quotient = observedQuotient > theoriticalQuotient ? observedQuotient / theoriticalQuotient : theoriticalQuotient / observedQuotient;
            if ((float)apexDistanceInCycle <= minApexDistance && (double)correlation != Double.NaN && correlation > minCorr && quotient < minAveragineRatio && (double)quotient > 0.75) {
                BoxedUnit boxedUnit2;
                ft.hasMonoPeakel_$eq(false);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(" apexDist {}, correlation: {}, average ratio: {}", new Object[]{BoxesRunTime.boxToInteger((int)apexDistanceInCycle), BoxesRunTime.boxToFloat((float)correlation), BoxesRunTime.boxToFloat((float)quotient)});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                OverlappingFeaturesExtractor$.MODULE$.nonMonoCount().incrementAndGet();
                boxedUnit = bestOvlFeatures.$plus$eq((Object)new OverlappingFeature((Feature)ovlFt, 0, prevOvlFtPeakelIdx2, apexDistanceInCycle, correlation, quotient));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return (OverlappingFeature[])bestOvlFeatures.toArray(ClassTag$.MODULE$.apply(OverlappingFeature.class));
    }

    public static final /* synthetic */ Object $anonfun$_extractOverlappingFeatures$5(OverlappingFeaturesExtractor $this, double firstFtMz$1, int z$1, long maxSpectrumId$1, PeakListTree pklTree$1, ArrayBuffer ovlFts$1, int ipShift) {
        BoxedUnit boxedUnit;
        if (ipShift != 0) {
            double mzToExtract = firstFtMz$1 + ((double)ipShift + (double)ipShift * 0.0027) / (double)z$1;
            PutativeFeature putativeFt = new PutativeFeature(-1, mzToExtract, z$1, maxSpectrumId$1, 1);
            PeakelDetectionConfig ftXtractAlgoConfig = $this.ftExtractor().peakelDetectionConfig().copy(DetectionAlgorithm$.MODULE$.BASIC(), true, $this.ftExtractor().peakelDetectionConfig().copy$default$3());
            PutativeFeature x$1 = putativeFt;
            PeakListTree x$2 = pklTree$1;
            PeakelDetectionConfig x$3 = ftXtractAlgoConfig;
            FeatureExtractorConfig x$4 = $this.ftExtractor().searchAndExtractFeature$default$3();
            Option<Feature> featureAsOpt = $this.ftExtractor().searchAndExtractFeature(x$1, x$2, x$4, x$3);
            if (featureAsOpt.isDefined()) {
                Feature ovlFt = (Feature)featureAsOpt.get();
                boxedUnit = ovlFts$1.$plus$eq((Object)ovlFt);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ float $anonfun$_evaluateOverlappingStatus$1(OverlappingFeature ovlFt) {
        return ovlFt.feature().getPeakel(package$.MODULE$.max(ovlFt.overlappingPeakelIndex() - 1, 0)).area();
    }

    public OverlappingFeaturesExtractor(LongMap<SpectrumHeader> spectrumHeaderById, LongMap<Object> nfBySpectrumId, AbstractSupervisedFtExtractor ftExtractor) {
        this.spectrumHeaderById = spectrumHeaderById;
        this.nfBySpectrumId = nfBySpectrumId;
        this.ftExtractor = ftExtractor;
        LazyLogging.$init$((LazyLogging)this);
        this.xtractConfig = ftExtractor.xtractConfig();
        this.overlapXtractConfig = ftExtractor.overlapXtractConfig();
    }
}

