/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdbconverter;

import fr.profi.mzdbconverter.Thermo2Mzdb;
import fr.profi.timstof.Timstof2Mzdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDBConverterMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(MzDBConverterMain.class);
    private static final String ThermoFormat = "thermo";
    private static final String BruckerFormat = "brucker";

    public static void main(String[] argv) {
        if (argv == null || argv.length < 2) {
            MzDBConverterMain.printBasicUsage();
            System.exit(1);
        }
        String[] newArgs = new String[argv.length - 1];
        System.arraycopy(argv, 1, newArgs, 0, argv.length - 1);
        switch (argv[0]) {
            case "thermo": {
                Thermo2Mzdb.main(newArgs);
                break;
            }
            case "brucker": {
                Timstof2Mzdb.main(newArgs);
            }
        }
    }

    public static void printBasicUsage() {
        System.out.println(" ----------- MzDBConverterMain Usage : ------------- ");
        System.out.println(" mzdbConverter.bat thermo XXXX : convert Thermo raw file to mzdb. To get specific option run ");
        System.out.println(" mzdbConverter.bat thermo --help");
        System.out.println(" mzdbConverter.bat brucker XXXX : convert Brucker .d file to mzdb. To get specific option run ");
        System.out.println(" mzdbConverter.bat brucker --help");
    }
}

