/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.timstof;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import fr.profi.bruker.timstof.io.TimstofReader;
import fr.profi.bruker.timstof.model.AbstractTimsFrame;
import fr.profi.bruker.timstof.model.Precursor;
import fr.profi.bruker.timstof.model.SpectrumGeneratingMethod;
import fr.profi.bruker.timstof.model.TimsPASEFFrame;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDbHeader;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.model.params.Activation;
import fr.profi.mzdb.db.model.params.ComponentList;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.db.model.params.ReferencableParamGroup;
import fr.profi.mzdb.db.model.params.SelectedIon;
import fr.profi.mzdb.db.model.params.SelectedIonList;
import fr.profi.mzdb.db.model.params.SourceComponent;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.db.model.params.param.UserText;
import fr.profi.mzdb.io.writer.MzDBWriter;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.model.ProcessingMethod;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumMetaData;
import fr.profi.timstof.ConverterArguments;
import fr.profi.timstof.MobilityRepresentationMethod;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timstof2Mzdb {
    public static final float RT_EPSILON = 0.005f;
    private static final Logger LOG = LoggerFactory.getLogger(Timstof2Mzdb.class);
    protected File m_ttFile;
    protected SpectrumGeneratingMethod m_ms1Method;
    protected long m_fileHdl;
    protected TimstofReader m_ttReader;
    private Int2IntMap m_spectra2FrameIndex;
    private Int2IntMap m_frame2FirstSpectraIndex;
    private Int2IntMap m_frame2ReadSpectraCount;
    private Int2ObjectMap<AbstractTimsFrame> m_frameById;
    protected Int2ObjectMap<Precursor> m_precursorByIds;
    DataEncoding m_profileDataEncoding;
    DataEncoding m_centroidDataEncoding;
    DataEncoding m_fittedDataEncoding;

    public Timstof2Mzdb(File ttFile, SpectrumGeneratingMethod ms1Method) {
        this.m_ttFile = ttFile;
        this.m_ms1Method = ms1Method;
        this.m_ttReader = TimstofReader.getTimstofReader();
        this.m_fileHdl = this.m_ttReader.openTimstofFile(this.m_ttFile);
        this.initFramesData();
        this.m_profileDataEncoding = new DataEncoding(-1L, DataMode.PROFILE, PeakEncoding.HIGH_RES_PEAK, "none", ByteOrder.LITTLE_ENDIAN);
        this.m_centroidDataEncoding = new DataEncoding(-1L, DataMode.CENTROID, PeakEncoding.HIGH_RES_PEAK, "none", ByteOrder.LITTLE_ENDIAN);
        this.m_fittedDataEncoding = new DataEncoding(-1L, DataMode.FITTED, PeakEncoding.HIGH_RES_PEAK, "none", ByteOrder.LITTLE_ENDIAN);
    }

    protected void closeFile() {
        this.m_ttReader.closeTimstofFile(this.m_fileHdl);
    }

    protected void initFramesData() {
        long start = System.currentTimeMillis();
        List frames = this.m_ttReader.getFullTimsFrames(this.m_fileHdl);
        Collections.sort(frames);
        int spectrumIndex = 1;
        this.m_spectra2FrameIndex = new Int2IntOpenHashMap();
        this.m_frame2FirstSpectraIndex = new Int2IntOpenHashMap(frames.size() * 4 / 3 + 1);
        this.m_frameById = new Int2ObjectOpenHashMap(frames.size() * 4 / 3 + 1);
        for (AbstractTimsFrame tf : frames) {
            int nbrSpectrum = tf.getSpectrumCount();
            this.m_frame2FirstSpectraIndex.put(tf.getId(), spectrumIndex);
            for (int i = 0; i < nbrSpectrum; ++i) {
                this.m_spectra2FrameIndex.put(spectrumIndex, tf.getId());
                ++spectrumIndex;
            }
            this.m_frameById.put(tf.getId(), (Object)tf);
        }
        this.m_frame2ReadSpectraCount = new Int2IntOpenHashMap(frames.size() * 4 / 3 + 1);
        this.m_precursorByIds = this.m_ttReader.getPrecursorInfoById(this.m_fileHdl);
        long end = System.currentTimeMillis();
        LOG.info("Read meta data for " + frames.size() + " frames and " + this.m_spectra2FrameIndex.size() + " spectrum. Duration : " + (end - start) + " ms");
    }

    protected MzDBMetaData createMzDbMetaData() {
        String fileName;
        int pos;
        ParamTree pt = new ParamTree();
        ArrayList<UserParam> ups = new ArrayList<UserParam>();
        ups.add(new UserParam("origin_file_format", "Timstof Brucker", "xsd:string", null));
        pt.setUserParams(ups);
        int currentTime = Long.valueOf(System.currentTimeMillis()).intValue();
        MzDbHeader mzdbHeader = new MzDbHeader("0.7", currentTime, pt, null);
        ArrayList<DataEncoding> des = new ArrayList<DataEncoding>();
        des.add(this.m_profileDataEncoding);
        des.add(this.m_centroidDataEncoding);
        des.add(this.m_fittedDataEncoding);
        Map globalProperties = this.m_ttReader.readGlobalProperties(this.m_fileHdl);
        ArrayList<SourceComponent> compos = new ArrayList<SourceComponent>();
        SourceComponent srcCompo = new SourceComponent();
        ArrayList<CVParam> params = new ArrayList<CVParam>();
        params.add(this.buildCVParam("MS:1000398", "nanoelectrospray", "", "MS"));
        params.add(this.buildCVParam("MS:1000485", "nanospray inlet", "", "MS"));
        srcCompo.setCvParams(params);
        compos.add(srcCompo);
        ComponentList compList = new ComponentList();
        compList.setComponents(compos);
        InstrumentConfiguration iconf = new InstrumentConfiguration(-1L, "test", 1, new ParamTree(), compList);
        ArrayList<InstrumentConfiguration> iConfList = new ArrayList<InstrumentConfiguration>();
        iConfList.add(iconf);
        int indexSoft = 1;
        ArrayList<Software> softList = new ArrayList<Software>();
        ParamTree processMethodParamTree = new ParamTree();
        ArrayList<ProcessingMethod> pmList = new ArrayList<ProcessingMethod>();
        if (globalProperties.containsKey("AcquisitionSoftware")) {
            String name = (String)globalProperties.get("AcquisitionSoftware");
            String version = globalProperties.getOrDefault("AcquisitionSoftwareVersion", "Unknown");
            Software soft = new Software(indexSoft++, name, version, new ParamTree());
            softList.add(soft);
        }
        ProcessingMethod pm = new ProcessingMethod(1L, processMethodParamTree, 0, "TimsTof_2_mzdb_conversion", Integer.valueOf(indexSoft));
        pmList.add(pm);
        softList.add(new Software(indexSoft++, AbstractMzDbReader.TimsTofConverterName, "0.1", new ParamTree()));
        pm = new ProcessingMethod(2L, processMethodParamTree, 1, "TimsTof_2_mzdb_conversion", Integer.valueOf(indexSoft));
        pmList.add(pm);
        softList.add(new Software(indexSoft, "mzDB", "0.9.10", new ParamTree()));
        String acqDateStr = (String)globalProperties.get("AcquisitionDateTime");
        Date acqDate = Calendar.getInstance().getTime();
        if (acqDateStr != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            try {
                acqDate = sdf.parse(acqDateStr);
            }
            catch (ParseException e) {
                acqDate = Calendar.getInstance().getTime();
            }
        }
        if ((pos = (fileName = this.m_ttFile.getName()).lastIndexOf(".")) > 0 && pos < fileName.length() - 1) {
            fileName = fileName.substring(0, pos);
        }
        Run run = new Run(-1, fileName, acqDate);
        ParamTree runParamTree = new ParamTree();
        params = new ArrayList();
        params.add(this.buildCVParam("MS:1001954", "acquisition parameter", "DDA", "MS"));
        params.add(this.buildCVParam("MS:1003219", "ion mobility separation", "TIMS", "MS"));
        runParamTree.setCvParams(params);
        run.setParamTree(runParamTree);
        SharedParamTree runSharedParamTree = new SharedParamTree();
        ReferencableParamGroup mobilityGroup = new ReferencableParamGroup("IonMobilityParams");
        runSharedParamTree.setData(mobilityGroup);
        runSharedParamTree.setSchemaName("IonMobilityParams");
        ArrayList<UserText> userTexts = new ArrayList<UserText>();
        UserText userText = new UserText();
        userText.setType("xsd:string");
        userText.setName("ion_mobility_indexes");
        List ionMobilityIndexes = this.m_ttReader.getIonMobilityIndexes(this.m_fileHdl);
        String mobilities = ionMobilityIndexes.stream().map(p -> Integer.toString((Integer)p.getKey()) + ";" + Double.toString((Double)p.getValue())).collect(Collectors.joining("\n"));
        userText.setText(mobilities);
        userTexts.add(userText);
        mobilityGroup.setUserTexts(userTexts);
        ArrayList<SharedParamTree> sharedParamTreeList = new ArrayList<SharedParamTree>();
        sharedParamTreeList.add(runSharedParamTree);
        ArrayList<Run> rList = new ArrayList<Run>();
        rList.add(run);
        String splName = (String)((Object)globalProperties.getOrDefault("SampleName", this.m_ttFile.getName() + "_Sample"));
        Sample s = new Sample(-1, splName, new ParamTree());
        ArrayList<Sample> sList = new ArrayList<Sample>();
        sList.add(s);
        SourceFile sFile = new SourceFile(1, this.m_ttFile.getName(), this.m_ttFile.getAbsolutePath(), new ParamTree());
        ArrayList<SourceFile> sFileList = new ArrayList<SourceFile>();
        sFileList.add(sFile);
        LOG.info("Created MzDbMetaData.");
        MzDBMetaData metaData = new MzDBMetaData();
        metaData.setMzdbHeader(mzdbHeader);
        metaData.setDataEncodings(des);
        metaData.setInstrumentConfigurations(iConfList);
        metaData.setProcessingMethods(pmList);
        metaData.setRuns(rList);
        metaData.setSamples(sList);
        metaData.setSoftwares(softList);
        metaData.setSourceFiles(sFileList);
        metaData.setSharedParamTrees(sharedParamTreeList);
        Map properties = this.m_ttReader.readGlobalProperties(this.m_fileHdl);
        long mzAcqRangeLower = Math.round(Double.parseDouble((String)properties.get("MzAcqRangeLower")));
        metaData.setLowestMS1Mz((double)mzAcqRangeLower);
        return metaData;
    }

    private CVParam buildCVParam(String accession, String name, String value, String cvRef) {
        CVParam param = new CVParam();
        param.setAccession(accession);
        param.setName(name);
        param.setValue(value);
        param.setCvRef(cvRef);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMZdBData() {
        MzDBWriter writer = null;
        try {
            int spId;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH_mm_ss");
            String date = dateFormat.format(Calendar.getInstance().getTime());
            String outFilePath = this.m_ttFile.getAbsolutePath() + "_" + date + ".mzdb";
            File outFile = new File(outFilePath);
            BBSizes defaultBBsize = new BBSizes(5.0, 10000.0, 15.0f, 0.0f);
            MzDBMetaData mzDbMetaData = this.createMzDbMetaData();
            writer = new MzDBWriter(outFile, false, mzDbMetaData, defaultBBsize, Boolean.valueOf(false));
            writer.initialize();
            int mzDBSpId = spId = 1;
            int cycle = 0;
            int nbrSp = this.m_spectra2FrameIndex.size();
            long time_readFrame = 0L;
            long time_ms2 = 0L;
            long time_ms1 = 0L;
            long time_write = 0L;
            while (spId <= nbrSp) {
                long step2;
                long start = System.currentTimeMillis();
                int frameId = this.m_spectra2FrameIndex.get(spId);
                int nbrScanForFrame = this.m_frame2ReadSpectraCount.getOrDefault(frameId, 0);
                this.m_frame2ReadSpectraCount.put(frameId, ++nbrScanForFrame);
                AbstractTimsFrame timsFrame = (AbstractTimsFrame)this.m_frameById.get(frameId);
                if (timsFrame == null) {
                    LOG.warn("#### NO FRAME " + frameId + " for spectra " + spId);
                    ++spId;
                    continue;
                }
                if (!timsFrame.spectrumRead()) {
                    List<AbstractTimsFrame> tfs = Collections.singletonList(timsFrame);
                    this.m_ttReader.fillFramesWithSpectrumData(Long.valueOf(this.m_fileHdl), tfs);
                }
                fr.profi.mzdb.db.model.params.Precursor mzdbPrecursor = null;
                fr.profi.bruker.timstof.model.Spectrum ttSpectrum = null;
                Double preMz = null;
                Integer preCharge = null;
                long step1 = System.currentTimeMillis();
                time_readFrame += step1 - start;
                float rtInSec = (float)timsFrame.getTime();
                int mslevel = 0;
                boolean errFound = false;
                switch (timsFrame.getMsmsType()) {
                    case MS: {
                        mslevel = 1;
                        ++cycle;
                        ttSpectrum = timsFrame.getSingleSpectrum(this.m_ms1Method);
                        step2 = System.currentTimeMillis();
                        time_ms1 += step2 - step1;
                        break;
                    }
                    case PASEF: {
                        mslevel = 2;
                        if (((TimsPASEFFrame)timsFrame).getPrecursorIds() != null) {
                            IntArrayList precursorIds = ((TimsPASEFFrame)timsFrame).getPrecursorIds();
                            Collections.sort(precursorIds);
                            int indexInFrameSpectra = spId - this.m_frame2FirstSpectraIndex.get(timsFrame.getId());
                            if (indexInFrameSpectra >= precursorIds.size() || indexInFrameSpectra < 0) {
                                LOG.warn("#### WARNING #### can't found precursor id  for spectra " + spId + " Index in frame : " + indexInFrameSpectra + ". TimsFrame index" + timsFrame.getId());
                                errFound = true;
                                break;
                            }
                            rtInSec = indexInFrameSpectra == 0 ? rtInSec : rtInSec + (float)indexInFrameSpectra * 0.005f;
                            int precursorId = (Integer)precursorIds.get(indexInFrameSpectra);
                            ttSpectrum = ((TimsPASEFFrame)timsFrame).getPrecursorSpectrum(precursorId);
                            if (ttSpectrum == null) {
                                LOG.warn("#### WARNING #### No precursor spectrum was defined for frame  " + timsFrame.getId() + "; precursorId : " + precursorId + ". Spectrum index " + spId);
                                errFound = true;
                            } else {
                                Precursor timstofPrecursor = (Precursor)this.m_precursorByIds.get(precursorId);
                                mzdbPrecursor = new fr.profi.mzdb.db.model.params.Precursor();
                                mzdbPrecursor.setSpectrumRef(ttSpectrum.getTitle());
                                if (timstofPrecursor != null) {
                                    preMz = timstofPrecursor.getMonoIsotopicMz();
                                    preCharge = timstofPrecursor.getCharge();
                                }
                            }
                            step2 = System.currentTimeMillis();
                            time_ms2 += step2 - step1;
                            break;
                        }
                        LOG.warn("#### WARNING ####  UNSUPPORTED Frame type. Only MS1 and PASEF are supported actually. Frame " + timsFrame.getId() + " is getMsmsType " + String.valueOf(timsFrame.getMsmsType()));
                        errFound = true;
                        break;
                    }
                    default: {
                        LOG.warn("#### WARNING ####  UNSUPPORTED Frame type. Only MS1 and PASEF are supported actually. Frame " + timsFrame.getId() + " is getMsmsType " + String.valueOf(timsFrame.getMsmsType()));
                        errFound = true;
                    }
                }
                if (errFound) {
                    if (timsFrame.getSpectrumCount() == nbrScanForFrame) {
                        timsFrame.clearSpectraData();
                    }
                    ++spId;
                    continue;
                }
                step2 = System.currentTimeMillis();
                Spectrum mzdbSp = this.buildMzdbSpectrum(ttSpectrum, mzDBSpId, cycle, rtInSec, mslevel, timsFrame.getSummedIntensity(), preMz, preCharge, mzdbPrecursor);
                if (mzdbSp != null) {
                    SpectrumMetaData spectrumMetaData = new SpectrumMetaData(Long.valueOf(mzDBSpId), "", "", "");
                    DataEncoding spectrumEncoding = this.m_centroidDataEncoding;
                    if (timsFrame.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.MS)) {
                        switch (this.m_ms1Method) {
                            case FULL: 
                            case MERGED: {
                                spectrumEncoding = this.m_profileDataEncoding;
                            }
                        }
                    }
                    writer.insertSpectrum(mzdbSp, spectrumMetaData, spectrumEncoding);
                    long step4 = System.currentTimeMillis();
                    time_write += step4 - step2;
                }
                if (timsFrame.getSpectrumCount() == nbrScanForFrame) {
                    timsFrame.clearSpectraData();
                }
                ++mzDBSpId;
                if (++spId % 1000 != 0 && spId != nbrSp) continue;
                LOG.info("Already written {} ({} in mzdb) spectra over {} ", new Object[]{spId, mzDBSpId, nbrSp});
                LOG.debug("Time used to read Frame: " + time_readFrame);
                LOG.debug("Time used to create MS2: " + time_ms2);
                LOG.debug("Time used to create MS1: " + time_ms1);
                LOG.debug("Time used to write data: " + time_write);
                time_readFrame = 0L;
                time_ms2 = 0L;
                time_ms1 = 0L;
                time_write = 0L;
            }
        }
        catch (Exception e) {
            LOG.error("Exception in Spectrum iterator ", (Throwable)e);
            e.printStackTrace();
        }
        catch (Throwable t) {
            LOG.error("Throwable in Spectrum iterator ", t);
            t.printStackTrace();
        }
        finally {
            LOG.debug("Finally  close writer.");
            writer.close();
        }
    }

    protected Spectrum buildMzdbSpectrum(fr.profi.bruker.timstof.model.Spectrum ttSpectrum, int mzDBSpId, int cycle, float rtInSec, int mslevel, float tic, Double precMz, Integer precCharge, fr.profi.mzdb.db.model.params.Precursor precursor) {
        float[] intensities = ttSpectrum.getIntensities();
        int nbPeaks = intensities.length;
        if (nbPeaks > 0) {
            int maxIndex = 0;
            float prevIntensity = intensities[0];
            for (int index = 1; index < nbPeaks; ++index) {
                float intAtIndex = intensities[index];
                if (!(intAtIndex > prevIntensity)) continue;
                maxIndex = index;
                prevIntensity = intAtIndex;
            }
            SpectrumHeader spH = new SpectrumHeader((long)mzDBSpId, mzDBSpId, cycle, rtInSec, mslevel, ttSpectrum.getTitle(), nbPeaks, false, tic, ttSpectrum.getMasses()[maxIndex], intensities[maxIndex], precMz, precCharge, mzDBSpId, null);
            spH.setPrecursor(precursor);
            SpectrumData spData = new SpectrumData(ttSpectrum.getMasses(), ttSpectrum.getIntensities());
            return new Spectrum(spH, spData);
        }
        LOG.info("mzdb scan id {} has no peaks ! It will not be written in the mzdb outputfile", (Object)mzDBSpId);
        return null;
    }

    private void testFrameAndQuit(int spId) {
        int frameId = this.m_spectra2FrameIndex.get(spId);
        int nbrScanForFrame = this.m_frame2ReadSpectraCount.getOrDefault(frameId, 0);
        ++nbrScanForFrame;
        AbstractTimsFrame timsFrame = (AbstractTimsFrame)this.m_frameById.get(frameId);
        if (timsFrame != null) {
            if (!timsFrame.spectrumRead()) {
                List<AbstractTimsFrame> tfs = Collections.singletonList(timsFrame);
                this.m_ttReader.fillFramesWithSpectrumData(Long.valueOf(this.m_fileHdl), tfs);
            }
        } else {
            LOG.warn("#### NO FRAME " + frameId + " for spectra " + spId);
        }
        fr.profi.bruker.timstof.model.Spectrum ttSpectrum = timsFrame.getSingleSpectrum(this.m_ms1Method);
        LOG.info("spectrum {}  contains {} peaks", (Object)spId, (Object)ttSpectrum.getMasses().length);
        System.exit(0);
    }

    protected void fillmzDBPrecursor(fr.profi.mzdb.db.model.params.Precursor mzdbPrecursor, Precursor timstofPrecursor, String collEnergy) {
        long start = System.currentTimeMillis();
        IsolationWindowParamTree isolationParams = new IsolationWindowParamTree();
        ArrayList<CVParam> isolationParamsList = new ArrayList<CVParam>();
        isolationParamsList.add(this.buildCVParam("MS:1000827", "isolation window target m/z", String.valueOf(timstofPrecursor.getMonoIsotopicMz()), "MS"));
        isolationParams.setCvParams(isolationParamsList);
        mzdbPrecursor.setIsolationWindow(isolationParams);
        Activation activation = new Activation();
        ArrayList<CVParam> params = new ArrayList<CVParam>();
        params.add(this.buildCVParam("MS:1000133", "collision-induced dissociation", "", "MS"));
        params.add(this.buildCVParam("MS:1000045", "collision energy", collEnergy, "MS"));
        activation.setCvParams(params);
        mzdbPrecursor.setActivation(activation);
        SelectedIonList ionList = new SelectedIonList();
        ionList.setCount(1);
        SelectedIon ion = new SelectedIon();
        ArrayList<SelectedIon> selectedIons = new ArrayList<SelectedIon>();
        ArrayList<CVParam> ionParams = new ArrayList<CVParam>();
        ionParams.add(this.buildCVParam("MS:1000744", "selected ion m/z", String.valueOf(timstofPrecursor.getMonoIsotopicMz()), "MS"));
        ionParams.add(this.buildCVParam("MS:1000041", "charge state", String.valueOf(timstofPrecursor.getCharge()), "MS"));
        ionParams.add(this.buildCVParam("MS:1000042", "peak intensity", String.valueOf(timstofPrecursor.getIntensity()), "MS"));
        ion.setCvParams(ionParams);
        selectedIons.add(ion);
        ionList.setSelectedIons(selectedIons);
        mzdbPrecursor.setSelectedIonList(ionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Timstof2Mzdb inst = null;
        ConverterArguments convertArgs = new ConverterArguments();
        JCommander cmd = JCommander.newBuilder().addObject((Object)convertArgs).build();
        try {
            File ttDir;
            cmd.parse(args);
            SpectrumGeneratingMethod ms1Method = SpectrumGeneratingMethod.SMOOTH;
            LOG.info("File to convert: " + convertArgs.filename);
            String fileToConvert = convertArgs.filename;
            if (convertArgs.ms1 != null) {
                LOG.info("Ms1 set to " + String.valueOf(convertArgs.ms1));
                ms1Method = convertArgs.ms1;
            } else {
                LOG.info("NO specific ms1 conversion mode set, use default {} mode.", (Object)ms1Method);
            }
            if (convertArgs.mobilityMethod != null && !convertArgs.mobilityMethod.equals((Object)MobilityRepresentationMethod.NONE)) {
                LOG.error(" !! Ion mobility representation method Not Supported Yet ! should not be specified or set to NONE. !!");
                System.exit(1);
            }
            if (!(ttDir = new File(fileToConvert)).exists()) {
                LOG.error("File " + fileToConvert + " does not exist !! ");
                System.exit(1);
            }
            inst = new Timstof2Mzdb(ttDir, ms1Method);
            inst.createMZdBData();
        }
        catch (ParameterException pe) {
            LOG.info("Error parsing arguments: " + pe.getMessage());
            cmd.usage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inst != null) {
                LOG.info("Close file");
                inst.closeFile();
            }
        }
    }
}

