/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.timstof;

import com.almworks.sqlite4java.SQLiteException;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import fr.profi.bruker.timstof.model.AbstractTimsFrame;
import fr.profi.bruker.timstof.model.Precursor;
import fr.profi.bruker.timstof.model.SpectrumGeneratingMethod;
import fr.profi.bruker.timstof.model.TimsMSFrame;
import fr.profi.bruker.timstof.model.TimsPASEFFrame;
import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.io.writer.MzDBWriter;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumMetaData;
import fr.profi.timstof.ConverterArguments;
import fr.profi.timstof.MobilityRepresentationMethod;
import fr.profi.timstof.Timstof2Mzdb;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timstof2MzdbExt
extends Timstof2Mzdb {
    private static final Logger LOG = LoggerFactory.getLogger(Timstof2MzdbExt.class);
    private static final StopWatch readFrameSW = new StopWatch("read frame");
    DataEncoding m_centroid3dDataEncoding;
    private final MobilityRepresentationMethod mobilityMethod;

    public Timstof2MzdbExt(File ttFile, SpectrumGeneratingMethod ms1Method, MobilityRepresentationMethod mobilityMethod) {
        super(ttFile, ms1Method);
        this.mobilityMethod = mobilityMethod;
    }

    @Override
    protected void initFramesData() {
        this.m_precursorByIds = this.m_ttReader.getPrecursorInfoById(this.m_fileHdl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createMZdBData() {
        MzDBWriter writer = null;
        try {
            int spId;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH_mm_ss");
            String date = dateFormat.format(Calendar.getInstance().getTime());
            String outFilePath = this.m_ttFile.getAbsolutePath() + "_" + date + ".mzdb";
            File outFile = new File(outFilePath);
            BBSizes defaultBBsize = new BBSizes(5.0, 10000.0, 15.0f, 0.0f);
            MzDBMetaData mzDbMetaData = this.createMzDbMetaData();
            writer = new MzDBWriter(outFile, false, mzDbMetaData, defaultBBsize, Boolean.valueOf(false));
            writer.initialize();
            int mzDBSpId = spId = 1;
            int cycle = 0;
            long time_readFrame = 0L;
            long time_ms2 = 0L;
            long time_ms1 = 0L;
            long time_write = 0L;
            DataEncoding ms1Encoding = this.m_centroidDataEncoding;
            switch (this.mobilityMethod) {
                case NONE: 
                case PER_SCAN: {
                    ms1Encoding = this.m_centroidDataEncoding;
                    break;
                }
                case PER_PEAK: {
                    ms1Encoding = this.m_centroid3dDataEncoding;
                }
            }
            List frames = this.m_ttReader.getFullTimsFrames(this.m_fileHdl);
            Collections.sort(frames);
            block15: for (int frameIdx = 0; frameIdx < frames.size(); ++frameIdx) {
                AbstractTimsFrame timsFrame = (AbstractTimsFrame)frames.get(frameIdx);
                long start = System.currentTimeMillis();
                if (!timsFrame.spectrumRead()) {
                    List<AbstractTimsFrame> tfs = Collections.singletonList(timsFrame);
                    this.m_ttReader.fillFramesWithSpectrumData(Long.valueOf(this.m_fileHdl), tfs);
                }
                fr.profi.mzdb.db.model.params.Precursor mzdbPrecursor = null;
                fr.profi.bruker.timstof.model.Spectrum ttSpectrum = null;
                Double preMz = null;
                Integer preCharge = null;
                Spectrum mzdbSp = null;
                long step1 = System.currentTimeMillis();
                time_readFrame += step1 - start;
                float rtInSec = (float)timsFrame.getTime();
                switch (timsFrame.getMsmsType()) {
                    case MS: {
                        long step2;
                        ++cycle;
                        if (this.mobilityMethod == MobilityRepresentationMethod.NONE) {
                            ttSpectrum = timsFrame.getSingleSpectrum(this.m_ms1Method);
                            step2 = System.currentTimeMillis();
                            time_ms1 += step2 - step1;
                            mzdbSp = this.buildMzdbSpectrum(ttSpectrum, mzDBSpId, cycle, rtInSec, 1, timsFrame.getSummedIntensity(), null, null, null);
                            if (mzdbSp == null) break;
                            mzDBSpId = this.writeMzdbSpectrum(writer, timsFrame.getMsmsType(), mzdbSp, ms1Encoding);
                            long step4 = System.currentTimeMillis();
                            time_write += step4 - step2;
                            break;
                        }
                        if (this.mobilityMethod == MobilityRepresentationMethod.PER_SCAN) {
                            for (int scanIdx = 1; scanIdx < timsFrame.getNbrScans(); ++scanIdx) {
                                double deltaRt;
                                ttSpectrum = ((TimsMSFrame)timsFrame).getScanSpectrum(scanIdx);
                                double d = deltaRt = frameIdx < frames.size() - 1 ? (((AbstractTimsFrame)frames.get(frameIdx + 1)).getTime() - timsFrame.getTime()) / (double)timsFrame.getNbrScans() : 1.0 / (double)timsFrame.getNbrScans();
                                if (ttSpectrum == null) continue;
                                step2 = System.currentTimeMillis();
                                time_ms1 += step2 - step1;
                                mzdbSp = this.buildMzdbSpectrum(ttSpectrum, mzDBSpId, cycle, (float)((double)rtInSec + (double)scanIdx * deltaRt), 1, timsFrame.getSummedIntensity(), null, null, null);
                                if (mzdbSp == null) continue;
                                mzDBSpId = this.writeMzdbSpectrum(writer, timsFrame.getMsmsType(), mzdbSp, ms1Encoding);
                                long step4 = System.currentTimeMillis();
                                time_write += step4 - step2;
                            }
                            break;
                        }
                        if (this.mobilityMethod != MobilityRepresentationMethod.PER_PEAK) break;
                        break;
                    }
                    case PASEF: {
                        long step2;
                        if (((TimsPASEFFrame)timsFrame).getPrecursorIds() != null) {
                            IntArrayList precursorIds = ((TimsPASEFFrame)timsFrame).getPrecursorIds();
                            Collections.sort(precursorIds);
                            for (int precursorIdx = 0; precursorIdx < precursorIds.size(); ++precursorIdx) {
                                int precursorId = (Integer)precursorIds.get(precursorIdx);
                                ttSpectrum = ((TimsPASEFFrame)timsFrame).getPrecursorSpectrum(precursorId);
                                if (ttSpectrum == null) {
                                    LOG.warn("#### WARNING #### No precursor spectrum was defined for frame  " + timsFrame.getId() + "; precursorId : " + precursorId + ". Spectrum index " + spId);
                                    continue;
                                }
                                Precursor timstofPrecursor = (Precursor)this.m_precursorByIds.get(precursorId);
                                mzdbPrecursor = new fr.profi.mzdb.db.model.params.Precursor();
                                mzdbPrecursor.setSpectrumRef(ttSpectrum.getTitle());
                                if (timstofPrecursor != null) {
                                    preMz = timstofPrecursor.getMonoIsotopicMz();
                                    preCharge = timstofPrecursor.getCharge();
                                }
                                step2 = System.currentTimeMillis();
                                time_ms2 += step2 - step1;
                                mzdbSp = this.buildMzdbSpectrum(ttSpectrum, mzDBSpId, cycle, rtInSec + (float)precursorIdx * 0.005f, 2, timsFrame.getSummedIntensity(), preMz, preCharge, mzdbPrecursor);
                                if (mzdbSp == null) continue;
                                mzDBSpId = this.writeMzdbSpectrum(writer, timsFrame.getMsmsType(), mzdbSp, this.m_centroidDataEncoding);
                                long step4 = System.currentTimeMillis();
                                time_write += step4 - step2;
                            }
                            break;
                        }
                        LOG.warn("#### WARNING ####  UNSUPPORTED Frame type. Only MS1 and PASEF are supported actually. Frame " + timsFrame.getId() + " is getMsmsType " + String.valueOf(timsFrame.getMsmsType()));
                        timsFrame.clearSpectraData();
                        continue block15;
                    }
                    default: {
                        LOG.warn("#### WARNING ####  UNSUPPORTED Frame type. Only MS1 and PASEF are supported actually. Frame " + timsFrame.getId() + " is getMsmsType " + String.valueOf(timsFrame.getMsmsType()));
                        timsFrame.clearSpectraData();
                        continue block15;
                    }
                }
                timsFrame.clearSpectraData();
                if (++spId % 1000 != 0) continue;
                LOG.info("Already written {} ({} in mzdb) spectra over {?} ", (Object)spId, (Object)mzDBSpId);
                LOG.debug("Time used to read Frame: " + time_readFrame);
                LOG.debug("Time used to create MS2: " + time_ms2);
                LOG.debug("Time used to create MS1: " + time_ms1);
                LOG.debug("Time used to write data: " + time_write);
                time_readFrame = 0L;
                time_ms2 = 0L;
                time_ms1 = 0L;
                time_write = 0L;
            }
        }
        catch (Exception e) {
            LOG.error("Exception in Spectrum iterator ", (Throwable)e);
            e.printStackTrace();
        }
        catch (Throwable t) {
            LOG.error("Throwable in Spectrum iterator ", t);
            t.printStackTrace();
        }
        finally {
            LOG.debug("Finally  close writer.");
            writer.close();
        }
    }

    private int writeMzdbSpectrum(MzDBWriter writer, AbstractTimsFrame.MsMsType msmsType, Spectrum mzdbSp, DataEncoding encoding) throws SQLiteException {
        long mzdbSpId = mzdbSp.getHeader().getSpectrumId();
        SpectrumMetaData spectrumMetaData = new SpectrumMetaData(Long.valueOf(mzdbSpId), "", "", "");
        writer.insertSpectrum(mzdbSp, spectrumMetaData, encoding);
        return (int)(++mzdbSpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Timstof2Mzdb inst = null;
        ConverterArguments convertArgs = new ConverterArguments();
        JCommander cmd = JCommander.newBuilder().addObject((Object)convertArgs).build();
        try {
            cmd.parse(args);
            File ttDir = new File(convertArgs.filename);
            if (!ttDir.exists()) {
                LOG.error("File " + convertArgs.filename + " does not exist !! ");
                System.exit(1);
            }
            inst = new Timstof2MzdbExt(ttDir, convertArgs.ms1, convertArgs.mobilityMethod);
            ((Timstof2MzdbExt)inst).createMZdBData();
        }
        catch (ParameterException pe) {
            LOG.info("Error parsing arguments: " + pe.getMessage());
            cmd.usage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inst != null) {
                LOG.info("Close file");
                inst.closeFile();
            }
        }
    }
}

