/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatDHT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatDHT() {
    }

    public static void checkAccuracyDHT_1D() {
        System.out.println("Checking accuracy of 1D DHT...");
        for (int i = 0; i < sizes1D.length; ++i) {
            FloatDHT_1D dht = new FloatDHT_1D(sizes1D[i]);
            double err = 0.0;
            float[] a = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            float[] b = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], b);
            dht.forward(a);
            dht.inverse(a, true);
            err = AccuracyCheckFloatDHT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dht = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_2D() {
        Object b;
        Object a;
        double err;
        FloatDHT_2D dht2;
        int i;
        System.out.println("Checking accuracy of 2D DHT (float[] input)...");
        for (i = 0; i < sizes2D.length; ++i) {
            dht2 = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], a);
            b = new float[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], b);
            dht2.forward((float[])a);
            dht2.inverse((float[])a, true);
            err = AccuracyCheckFloatDHT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dht2 = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DHT (float[][] input)...");
        for (i = 0; i < sizes2D.length; ++i) {
            dht2 = new FloatDHT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (float[][])a);
            b = new float[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (float[][])b);
            dht2.forward((float[][])a);
            dht2.inverse((float[][])a, true);
            err = AccuracyCheckFloatDHT.computeRMSE((float[][])a, (float[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dht2 = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_3D() {
        Object b;
        Object a;
        double err;
        FloatDHT_3D dht3;
        int i;
        System.out.println("Checking accuracy of 3D DHT (float[] input)...");
        for (i = 0; i < sizes3D.length; ++i) {
            dht3 = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], a);
            b = new float[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], b);
            dht3.forward((float[])a);
            dht3.inverse((float[])a, true);
            err = AccuracyCheckFloatDHT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dht3 = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DHT (float[][][] input)...");
        for (i = 0; i < sizes3D.length; ++i) {
            dht3 = new FloatDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (float[][][])a);
            b = new float[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (float[][][])b);
            dht3.forward((float[][][])a);
            dht3.inverse((float[][][])a, true);
            err = AccuracyCheckFloatDHT.computeRMSE((float[][][])a, (float[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dht3 = null;
            System.gc();
        }
    }

    private static double computeRMSE(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double tmp = a[i] - b[i];
            rms += tmp * tmp;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(float[][] a, float[][] b) {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int r = 0; r < a.length; ++r) {
            for (int c = 0; c < a[0].length; ++c) {
                double tmp = a[r][c] - b[r][c];
                rms += tmp * tmp;
            }
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(float[][][] a, float[][][] b) {
        if (a.length != b.length || a[0].length != b[0].length || a[0][0].length != b[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int s = 0; s < a.length; ++s) {
            for (int r = 0; r < a[0].length; ++r) {
                for (int c = 0; c < a[0][0].length; ++c) {
                    double tmp = a[s][r][c] - b[s][r][c];
                    rms += tmp * tmp;
                }
            }
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckFloatDHT.checkAccuracyDHT_1D();
        AccuracyCheckFloatDHT.checkAccuracyDHT_2D();
        AccuracyCheckFloatDHT.checkAccuracyDHT_3D();
        System.exit(0);
    }
}

