/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.java2d.pipe;

import sun.java2d.SunGraphics2D;

/**
 * This interface defines the set of calls that pipeline objects
 * can use to pass on responsibility for drawing arbitrary
 * parallelogram shapes.
 * Six floating point numbers are provided and the parallelogram
 * is defined as the quadrilateral with the following vertices:
 * <pre>
 *     origin: (x, y)
 *          => (x+dx1, y+dy1)
 *          => (x+dx1+dx2, y+dy1+dy2)
 *          => (x+dx2, y+dy2)
 *          => origin
 * </pre>
 * The four u[xy][12] parameters are the unsorted extreme coordinates
 * of the primitive in user space.  They may have been generated by a
 * line or a rectangle so they could have u[xy]2 < u[xy]1 in some cases.
 * They should be sorted before calculating the bounds of the original
 * primitive (such as for calculating the user space bounds for the
 * Paint.createContext() method).
 */
public interface ParallelogramPipe {
    public void fillParallelogram(SunGraphics2D sg,
                                  double ux1, double uy1,
                                  double ux2, double uy2,
                                  double x, double y,
                                  double dx1, double dy1,
                                  double dx2, double dy2);

    /**
     * Draw a Parallelogram with the indicated line widths
     * assuming a standard BasicStroke with MITER joins.
     * lw1 specifies the width of the stroke along the dx1,dy1
     * vector and lw2 specifies the width of the stroke along
     * the dx2,dy2 vector.
     * This is equivalent to outsetting the indicated
     * parallelogram by lw/2 pixels, then insetting the
     * same parallelogram by lw/2 pixels and filling the
     * difference between the outer and inner parallelograms.
     */
    public void drawParallelogram(SunGraphics2D sg,
                                  double ux1, double uy1,
                                  double ux2, double uy2,
                                  double x, double y,
                                  double dx1, double dy1,
                                  double dx2, double dy2,
                                  double lw1, double lw2);
}
