/*
 * Copyright (c) 1997, 2021, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources.ext;

import sun.util.resources.TimeZoneNamesBundle;

public final class TimeZoneNames_ko extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"\uc5d0\uc774\ucee4 \uc2dc\uac04", "ACT",
                                     "\uc5d0\uc774\ucee4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ACST",
                                     "\uc5d0\uc774\ucee4 \uc2dc\uac04", "ACT"};
        String ADELAIDE[] = new String[] {"\uC911\uBD80 \uD45C\uC900\uC2DC(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACST",
                                          "\uC911\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACDT",
                                          "\uC911\uBD80 \uD45C\uC900\uC2DC(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACT"};
        String AGT[] = new String[] {"\uc544\ub974\ud5e8\ud2f0\ub098 \uc2dc\uac04", "ART",
                                     "\uc544\ub974\ud5e8\ud2f0\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ARST",
                                     "\uC544\uB974\uD5E8\uD2F0\uB098 \uD45C\uC900\uC2DC", "ART"};
        String AKST[] = new String[] {"\uc54c\ub798\uc2a4\uce74 \ud45c\uc900\uc2dc", "AKST",
                                      "\uc54c\ub798\uc2a4\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AKDT",
                                      "\uC54C\uB798\uC2A4\uCE74 \uD45C\uC900\uC2DC", "AKT"};
        String AMT[] = new String[] {"\uc544\ub9c8\uc874 \uc2dc\uac04", "AMT",
                                     "\uc544\ub9c8\uc874 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AMST",
                                     "\uC544\uB9C8\uC874 \uD45C\uC900\uC2DC", "AMT"};
        String ARAST[] = new String[] {"\uc544\ub78d \ud45c\uc900\uc2dc", "AST",
                                       "\uc544\ub78d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ADT",
                                       "\uC544\uB77C\uBE44\uC544 \uD45C\uC900\uC2DC", "AT"};
        String ARMT[] = new String[] {"\uc544\ub974\uba54\ub2c8\uc544 \uc2dc\uac04", "AMT",
                                      "\uc544\ub974\uba54\ub2c8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AMST",
                                      "\uC544\uB974\uBA54\uB2C8\uC544 \uD45C\uC900\uC2DC", "AMT"};
        String AST[] = new String[] {"\ub300\uc11c\uc591 \ud45c\uc900\uc2dc", "AST",
                                     "\ub300\uc11c\uc591 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ADT",
                                     "\uB300\uC11C\uC591 \uD45C\uC900\uC2DC", "AT"};
        String BDT[] = new String[] {"\ubc29\uae00\ub77c\ub370\uc2dc \uc2dc\uac04", "BDT",
                                     "\ubc29\uae00\ub77c\ub370\uc2dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BDST",
                                     "\uBC29\uAE00\uB77C\uB370\uC2DC \uD45C\uC900\uC2DC", "BDT"};
        String BRISBANE[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uD038\uC990\uB79C\uB4DC)", "AEST",
                                          "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uD038\uC990\uB79C\uB4DC)", "AEDT",
                                          "\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uD038\uC990\uB79C\uB4DC)", "AET"};
        String BROKEN_HILL[] = new String[] {"\uC911\uBD80 \uD45C\uC900\uC2DC(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544/\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "ACST",
                                             "\uC911\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544/\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "ACDT",
                                             "\uC911\uBD80 \uD45C\uC900\uC2DC(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544/\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "ACT"};
        String BRT[] = new String[] {"\ube0c\ub77c\uc9c8\ub9ac\uc544 \uc2dc\uac04", "BRT",
                                     "\ube0c\ub77c\uc9c8\ub9ac\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BRST",
                                     "\uBE0C\uB77C\uC9C8\uB9AC\uC544 \uD45C\uC900\uC2DC", "BRT"};
        String BTT[] = new String[] {"\ubd80\ud0c4 \uc2dc\uac04", "BTT",
                                     "\ubd80\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BTST",
                                     "\uBD80\uD0C4 \uD45C\uC900\uC2DC", "BTT"};
        String CAT[] = new String[] {"\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uc2dc\uac04", "CAT",
                                     "\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CAST",
                                     "\uC911\uC559 \uC544\uD504\uB9AC\uCE74 \uD45C\uC900\uC2DC", "CAT"};
        String CET[] = new String[] {"\uc911\uc559 \uc720\ub7fd \uc2dc\uac04", "CET",
                                     "\uc911\uc559 \uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CEST",
                                     "\uC911\uC559 \uC720\uB7FD \uD45C\uC900\uC2DC", "CET"};
        String CHAST[] = new String[] {"Chatham \ud45c\uc900\uc2dc", "CHAST",
                                       "Chatham \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CHADT",
                                       "\uCC44\uD140 \uD45C\uC900\uC2DC", "CHAT"};
        String CHUT[] = new String[] {"\uCD94\uD06C \uD45C\uC900\uC2DC", "CHUT",
                                      "\uCD94\uD06C \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "CHUST",
                                      "\uCD94\uD06C \uD45C\uC900\uC2DC", "CHUT"};
        String CIT[] = new String[] {"\uc911\uc559 \uc778\ub3c4\ub124\uc2dc\uc544 \uc2dc\uac04", "WITA",
                                     "\uc911\uc559 \uc778\ub3c4\ub124\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CIST",
                                     "\uC911\uBD80 \uC778\uB3C4\uB124\uC2DC\uC544 \uD45C\uC900\uC2DC", "WITA"};
        String CLT[] = new String[] {"\uce60\ub808 \uc2dc\uac04", "CLT",
                                     "\uce60\ub808 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CLST",
                                     "\uCE60\uB808 \uD45C\uC900\uC2DC", "CLT"};
        String CST[] = new String[] {"\uc911\ubd80 \ud45c\uc900\uc2dc", "CST",
                                     "\uc911\ubd80 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CDT",
                                     "\uC911\uBD80 \uD45C\uC900\uC2DC", "CT"};
        String CTT[] = new String[] {"\uc911\uad6d \ud45c\uc900\uc2dc", "CST",
                                     "\uc911\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CDT",
                                     "\uC911\uAD6D \uD45C\uC900\uC2DC", "CT"};
        String CUBA[] = new String[] {"\ucfe0\ubc14 \ud45c\uc900\uc2dc", "CST",
                                      "\ucfe0\ubc14 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CDT",
                                      "\uCFE0\uBC14 \uD45C\uC900\uC2DC", "CT"};
        String DARWIN[] = new String[] {"\uC911\uBD80 \uD45C\uC900\uC2DC(\uBD81\uBD80 \uC9C0\uC5ED)", "ACST",
                                        "\uC911\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uBD81\uBD80 \uC9C0\uC5ED)", "ACDT",
                                        "\uC911\uBD80 \uD45C\uC900\uC2DC(\uBD81\uBD80 \uC9C0\uC5ED)", "ACT"};
        String DUBLIN[] = new String[] {"\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                        "\uc544\uc77c\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IST",
                                        "\uC544\uC77C\uB79C\uB4DC \uD45C\uC900\uC2DC", "IT"};
        String EAT[] = new String[] {"\ub3d9\ubd80 \uc544\ud504\ub9ac\uce74 \uc2dc\uac04", "EAT",
                                     "\ub3d9\ubd80 \uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EAST",
                                     "\uB3D9\uBD80 \uC544\uD504\uB9AC\uCE74 \uD45C\uC900\uC2DC", "EAT"};
        String EASTER[] = new String[] {"Easter Is. \uc2dc\uac04", "EAST",
                                        "Easter Is. \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EASST",
                                        "\uC774\uC2A4\uD130 \uC12C \uD45C\uC900\uC2DC", "EAST"};
        String EET[] = new String[] {"\ub3d9\uc720\ub7fd \uc2dc\uac04", "EET",
                                     "\ub3d9\uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EEST",
                                     "\ub3d9\ubd80 \uc720\ub7fd \ud45c\uc900\uc2dc", "EET"};
        String EGT[] = new String[] {"\ub3d9\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc2dc\uac04", "EGT",
                                     "\ub3d9\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EGST",
                                     "\uB3D9\uBD80 \uADF8\uB9B0\uB780\uB4DC \uD45C\uC900\uC2DC", "EGT"};
        String EST[] = new String[] {"\ub3d9\ubd80 \ud45c\uc900\uc2dc", "EST",
                                     "\ub3d9\ubd80 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EDT",
                                     "\uB3D9\uBD80 \uD45C\uC900\uC2DC", "ET"};
        String EST_NSW[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "AEST",
                                         "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "AEDT",
                                         "\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "AET"};
        String FET[] = new String[] {"\uADF9\uB3D9 \uC720\uB7FD \uD45C\uC900\uC2DC", "FET",
                                     "\uADF9\uB3D9 \uC720\uB7FD \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "FEST",
                                     "\uADF9\uB3D9 \uC720\uB7FD \uD45C\uC900\uC2DC", "FET"};
        String GHMT[] = new String[] {"\uac00\ub098 \ud45c\uc900\uc2dc", "GMT",
                                     "\uac00\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GHST",
                                     "\uAC00\uB098 \uD45C\uC900\uC2DC", "GMT"};
        String GAMBIER[] =  new String[] {"\uac10\ube44\uc544 \uc2dc\uac04", "GAMT",
                                          "\uac10\ube44\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GAMST",
                                          "\uC7A0\uBE44\uC544 \uD45C\uC900\uC2DC", "GAMT"};
        String GMT[] = new String[] {"\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                     "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                     "\uADF8\uB9AC\uB2C8\uCE58 \uD45C\uC900\uC2DC", "GMT"};
        String GMTBST[] = new String[] {"\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                        "\uc601\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BST",
                                        "\uC601\uAD6D \uD45C\uC900\uC2DC", "BT"};
        String GST[] = new String[] {"\uac78\ud504\ub9cc \ud45c\uc900\uc2dc", "GST",
                                     "\uac78\ud504\ub9cc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GDT",
                                     "\uAC78\uD504\uB9CC \uD45C\uC900\uC2DC", "GT"};
        String HKT[] =  new String[] {"\ud64d\ucf69 \uc2dc\uac04", "HKT",
                                      "\ud64d\ucf69 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "HKST",
                                      "\uD64D\uCF69 \uD45C\uC900\uC2DC", "HKT"};
        String HST[] = new String[] {"\ud558\uc640\uc774 \ud45c\uc900\uc2dc", "HST",
                                     "\ud558\uc640\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "HDT",
                                     "\uD558\uC640\uC774 \uD45C\uC900\uC2DC", "HT"};
        String ICT[] = new String[] {"\uc778\ub3c4\ucc28\uc774\ub098 \ubc18\ub3c4 \uc2dc\uac04", "ICT",
                                     "\uc778\ub3c4\ucc28\uc774\ub098 \ubc18\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ICST",
                                     "\uC778\uB3C4\uCC28\uC774\uB098 \uBC18\uB3C4 \uD45C\uC900\uC2DC", "ICT"};
        String IRKT[] =  new String[] {"\uc774\ub974\ucfe0\uce20\ud06c \uc2dc\uac04", "IRKT",
                                       "\uc774\ub974\ucfe0\uce20\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IRKST",
                                       "\uC774\uB974\uCFE0\uCE20\uD06C \uD45C\uC900\uC2DC", "IRKT"};
        String IRT[] = new String[] {"\uc774\ub780 \ud45c\uc900\uc2dc", "IRST",
                                     "\uc774\ub780 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IRDT",
                                     "\uC774\uB780 \uD45C\uC900\uC2DC", "IRT"};
        String ISRAEL[] = new String[] {"\uc774\uc2a4\ub77c\uc5d8 \ud45c\uc900\uc2dc", "IST",
                                        "\uc774\uc2a4\ub77c\uc5d8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IDT",
                                        "\uC544\uC2A4\uB77C\uC5D8 \uD45C\uC900\uC2DC", "IT"};
        String IST[] = new String[] {"\uc778\ub3c4 \ud45c\uc900\uc2dc", "IST",
                                     "\uc778\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IDT",
                                     "\uC778\uB3C4 \uD45C\uC900\uC2DC", "IT"};
        String JST[] = new String[] {"\uc77c\ubcf8 \ud45c\uc900\uc2dc", "JST",
                                     "\uc77c\ubcf8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "JDT",
                                     "\uC77C\uBCF8 \uD45C\uC900\uC2DC", "JT"};
        String KRAT[] = new String[] {"\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \uc2dc\uac04", "KRAT",
                                      "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KRAST",
                                      "\uD06C\uB77C\uC2A4\uB178\uC57C\uB974\uC2A4\uD06C \uD45C\uC900\uC2DC", "KRAT"};
        String KST[] = new String[] {"\ud55c\uad6d \ud45c\uc900\uc2dc", "KST",
                                     "\ud55c\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KDT",
                                     "\uB300\uD55C\uBBFC\uAD6D \uD45C\uC900\uC2DC", "KT"};
        String LORD_HOWE[] = new String[] {"\ub85c\ub4dc \ud558\uc6b0 \ud45c\uc900\uc2dc", "LHST",
                                           "\ub85c\ub4dc \ud558\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "LHDT",
                                           "\uB85C\uB4DC\uD558\uC6B0 \uD45C\uC900\uC2DC", "LHT"};
        String MHT[] = new String[] {"\ub9c8\uc15c\uc81c\ub3c4 \uc2dc\uac04", "MHT",
                                     "\ub9c8\uc15c\uc81c\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MHST",
                                     "\uB9C8\uC15C \uC81C\uB3C4 \uD45C\uC900\uC2DC", "MHT"};
        String MMT[] = new String[] {"\ubbf8\uc580\ub9c8 \uc2dc\uac04", "MMT",
                                     "\ubbf8\uc580\ub9c8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MMST",
                                     "\uBBF8\uC580\uB9C8 \uD45C\uC900\uC2DC", "MMT"};
        String MSK[] = new String[] {"\ubaa8\uc2a4\ud06c\ubc14 \ud45c\uc900\uc2dc", "MSK",
                                     "\ubaa8\uc2a4\ud06c\ubc14 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MSD",
                                     "\uBAA8\uC2A4\uD06C\uBC14 \uD45C\uC900\uC2DC", "MT"};
        String MST[] = new String[] {"\uc0b0\uc9c0 \ud45c\uc900\uc2dc", "MST",
                                     "\uc0b0\uc9c0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MDT",
                                     "\uC0B0\uC9C0 \uD45C\uC900\uC2DC", "MT"};
        String MYT[] = new String[] {"\ub9d0\ub808\uc774\uc2dc\uc544 \uc2dc\uac04", "MYT",
                                     "\ub9d0\ub808\uc774\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MYST",
                                     "\uB9D0\uB808\uC774\uC2DC\uC544 \uD45C\uC900\uC2DC", "MYT"};
        String NORONHA[] = new String[] {"Fernando de Noronha \uc2dc\uac04", "FNT",
                                         "Fernando de Noronha \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "FNST",
                                         "\uD398\uB974\uB09C\uB3C4 \uB4DC \uB178\uB85C\uD558 \uD45C\uC900\uC2DC", "FNT"};
        String NOVT[] = new String[] {"\ub178\ube0c\uc2dc\ube4c\uc2a4\ud06c \uc2dc\uac04", "NOVT",
                                      "\ub178\ube0c\uc2dc\ube4c\uc2a4\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NOVST",
                                      "\uB178\uBCF4\uC2DC\uBE44\uB974\uC2A4\uD06C \uD45C\uC900\uC2DC", "NOVT"};
        String NPT[] = new String[] {"\ub124\ud314 \uc2dc\uac04", "NPT",
                                      "\ub124\ud314 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NPST",
                                      "\uB124\uD314 \uD45C\uC900\uC2DC", "NPT"};
        String NST[] = new String[] {"\ub274\ud380\ub4e4\ub79c\ub4dc \ud45c\uc900\uc2dc", "NST",
                                     "\ub274\ud380\ub4e4\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NDT",
                                     "\uB274\uD380\uB4E4\uB79C\uB4DC \uD45C\uC900\uC2DC", "NT"};
        String NZST[] = new String[] {"\ub274\uc9c8\ub79c\ub4dc \ud45c\uc900\uc2dc", "NZST",
                                      "\ub274\uc9c8\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NZDT",
                                      "\uB274\uC9C8\uB79C\uB4DC \uD45C\uC900\uC2DC", "NZT"};
        String PITCAIRN[] = new String[] {"Pitcairn \ud45c\uc900\uc2dc", "PST",
                                          "Pitcairn \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PDT",
                                          "\uD54F\uCF00\uC5B8 \uD45C\uC900\uC2DC", "PT"};
        String PKT[] = new String[] {"\ud30c\ud0a4\uc2a4\ud0c4 \uc2dc\uac04", "PKT",
                                     "\ud30c\ud0a4\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PKST",
                                     "\uD30C\uD0A4\uC2A4\uD0C4 \uD45C\uC900\uC2DC", "PKT"};
        String PONT[] = new String[] {"\uD3F0\uD398\uC774 \uD45C\uC900\uC2DC", "PONT",
                                      "\uD3F0\uD398\uC774 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "PONST",
                                      "\uD3EC\uB098\uD398 \uD45C\uC900\uC2DC", "PONT"};
        String PST[] = new String[] {"\ud0dc\ud3c9\uc591 \ud45c\uc900\uc2dc", "PST",
                                     "\ud0dc\ud3c9\uc591 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PDT",
                                     "\uD0DC\uD3C9\uC591 \uD45C\uC900\uC2DC", "PT"};
        String SAST[] = new String[] {"\ub0a8\uc544\ud504\ub9ac\uce74 \ud45c\uc900\uc2dc", "SAST",
                                      "\ub0a8\uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SAST",
                                      "\uB0A8\uC544\uD504\uB9AC\uCE74 \uD45C\uC900\uC2DC", "SAT"};
        String SBT[] = new String[] {"\uc194\ub85c\ubaac \uad70\ub3c4 \uc2dc\uac04", "SBT",
                                     "\uc194\ub85c\ubaac \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SBST",
                                     "\uC194\uB85C\uBAAC \uC81C\uB3C4 \uD45C\uC900\uC2DC", "SBT"};
        String SGT[] = new String[] {"\uc2f1\uac00\ud3ec\ub974 \uc2dc\uac04", "SGT",
                                     "\uc2f1\uac00\ud3ec\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SGST",
                                     "\uC2F1\uAC00\uD3EC\uB974 \uD45C\uC900\uC2DC", "SGT"};
        String TASMANIA[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uD0DC\uC988\uBA54\uC774\uB2C8\uC544)", "AEST",
                                          "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uD0DC\uC988\uBA54\uC774\uB2C8\uC544)", "AEDT",
                                          "\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uD0DC\uC988\uBA54\uC774\uB2C8\uC544)", "AET"};
        String TMT[] = new String[] {"\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \uc2dc\uac04", "TMT",
                                     "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TMST",
                                     "\uD22C\uB974\uD06C\uBA54\uB2C8\uC2A4\uD0C4 \uD45C\uC900\uC2DC", "TMT"};
        String ULAT[]= new String[] {"\uc6b8\ub780\ubc14\ud0c0\ub974 \uc2dc\uac04", "ULAT",
                                     "\uc6b8\ub780\ubc14\ud0c0\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ULAST",
                                     "\uC6B8\uB780\uBC14\uD1A0\uB974 \uD45C\uC900\uC2DC", "ULAT"};
        String WAT[] = new String[] {"\uc11c\ubd80 \uc544\ud504\ub9ac\uce74 \uc2dc\uac04", "WAT",
                                     "\uc11c\ubd80 \uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WAST",
                                     "\uC11C\uBD80 \uC544\uD504\uB9AC\uCE74 \uD45C\uC900\uC2DC", "WAT"};
        String WET[] = new String[] {"\uc11c\uc720\ub7fd \uc2dc\uac04", "WET",
                                     "\uc11c\uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WEST",
                                     "\uC11C\uBD80 \uC720\uB7FD \uD45C\uC900\uC2DC", "WET"};
        String WGT[] = new String[] {"\uc11c\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc2dc\uac04", "WGT",
                                     "\uc11c\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WGST",
                                     "\uC11C\uBD80 \uADF8\uB9B0\uB780\uB4DC \uD45C\uC900\uC2DC", "WGT"};
        String WIT[] = new String[] {"\uc11c\uc778\ub3c4\ub124\uc2dc\uc544 \uc2dc\uac04", "WIB",
                                     "\uc11c\uc778\ub3c4\ub124\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WIST",
                                     "\uC11C\uBD80 \uC778\uB3C4\uB124\uC2DC\uC544 \uD45C\uC900\uC2DC", "WIB"};
        String WST_AUS[] = new String[] {"\uC11C\uBD80 \uD45C\uC900\uC2DC(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "AWST",
                                         "\uC11C\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "AWDT",
                                         "\uC11C\uBD80 \uD45C\uC900\uC2DC(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "AWT"};
        String SAMOA[] = new String[] {"\uc0ac\ubaa8\uc544 \ud45c\uc900\uc2dc", "SST",
                                       "\uc0ac\ubaa8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SDT",
                                       "\uC0AC\uBAA8\uC544 \uD45C\uC900\uC2DC", "ST"};
        String WST_SAMOA[] = new String[] {"\uc11c\uc0ac\ubaa8\uc544 \uc2dc\uac04", "WSST",
                                           "\uc11c\uc0ac\ubaa8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WSDT",
                                           "\uC11C\uC0AC\uBAA8\uC544 \uD45C\uC900\uC2DC", "WST"};
        String ChST[] = new String[] {"\ucc28\ubaa8\ub85c \ud45c\uc900\uc2dc", "ChST",
                                      "\ucc28\ubaa8\ub85c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ChDT",
                                      "\uCC28\uBAA8\uB974 \uD45C\uC900\uC2DC", "ChT"};
        String VICTORIA[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uBE45\uD1A0\uB9AC\uC544)", "AEST",
                                          "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uBE45\uD1A0\uB9AC\uC544)", "AEDT",
                                          "\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uBE45\uD1A0\uB9AC\uC544)", "AET"};
        String UTC[] = new String[] {"\uc138\uacc4 \ud45c\uc900\uc2dc", "UTC",
                                     "\uc138\uacc4 \ud45c\uc900\uc2dc", "UTC",
                                     "\uC9C0\uC5ED \uD45C\uC900\uC2DC", "UTC"};
        String UZT[] = new String[] {"\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc2dc\uac04", "UZT",
                                     "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "UZST",
                                     "\uC6B0\uC988\uBCA0\uD0A4\uC2A4\uD0C4 \uD45C\uC900\uC2DC", "UZT"};
        String XJT[] = new String[] {"\uc911\uad6d \ud45c\uc900\uc2dc", "XJT",
                                     "\uc911\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "XJDT",
                                     "\uC911\uAD6D \uD45C\uC900\uC2DC", "XJT"};
        String YAKT[] = new String[] {"\uc57c\uce20\ud06c \uc2dc\uac04", "YAKT",
                                      "\uc57c\uce20\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "YAKST",
                                      "\uC57C\uCFE0\uCE20\uD06C \uD45C\uC900\uC2DC", "YAKT"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            {"UTC", UTC},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", GMT},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", CAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", CAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", new String[] {"Central African Time", "CAT",
                                              "Western African Time", "WAT",
                                              "Central African Time", "CAT"}},
            {"America/Adak", HST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"\ud30c\ub77c\uacfc\uc774 \uc2dc\uac04", "PYT",
                                               "\ud30c\ub77c\uacfc\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PYST",
                                               "\uD30C\uB77C\uACFC\uC774 \uD45C\uC900\uC2DC", "PYT"}},
            {"America/Atikokan", EST},
            {"America/Atka", HST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"\ucf5c\ub86c\ube44\uc544 \uc2dc\uac04", "COT",
                                              "\ucf5c\ub86c\ube44\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "COST",
                                              "\uCF5C\uB86C\uBE44\uC544 \uD45C\uC900\uC2DC", "COT"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", EST},
            {"America/Caracas", new String[] {"\ubca0\ub124\uc218\uc5d8\ub77c \uc2dc\uac04", "VET",
                                              "\ubca0\ub124\uc218\uc5d8\ub77c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VEST",
                                              "\uBCA0\uB124\uC218\uC5D8\uB77C \uD45C\uC900\uC2DC", "VET"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098 \uc2dc\uac04", "GFT",
                                              "\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GFST",
                                              "\uD504\uB791\uC2A4\uB839 \uAE30\uC544\uB098 \uD45C\uC900\uC2DC", "GFT"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", MST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Nelson", MST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", WGT},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"\uc5d0\ucfe0\uc544\ub3c4\ub974 \uc2dc\uac04", "ECT",
                                                "\uc5d0\ucfe0\uc544\ub3c4\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ECST",
                                                "\uC5D0\uCF70\uB3C4\uB974 \uD45C\uC900\uC2DC", "ECT"}},
            {"America/Guyana", new String[] {"\uac00\uc774\uc544\ub098 \uc2dc\uac04", "GYT",
                                             "\uac00\uc774\uc544\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GYST",
                                             "\uAC00\uC774\uC544\uB098 \uD45C\uC900\uC2DC", "GYT"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"\ubcfc\ub9ac\ube44\uc544 \uc2dc\uac04", "BOT",
                                            "\ubcfc\ub9ac\ube44\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BOST",
                                            "\uBCFC\uB9AC\uBE44\uC544 \uD45C\uC900\uC2DC", "BOT"}},
            {"America/Lima", new String[] {"\ud398\ub8e8 \uc2dc\uac04", "PET",
                                            "\ud398\ub8e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PEST",
                                            "\uD398\uB8E8 \uD45C\uC900\uC2DC", "PET"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", AKST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"\ud53c\uc5d0\ub974 \ubbf8\ud06c\ub860 \ud45c\uc900\uc2dc", "PMST",
                                               "\ud53c\uc5d0\ub974 \ubbf8\ud06c\ub860 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PMDT",
                                               "\uD53C\uC5D0\uB974 \uBBF8\uD074\uB871 \uD45C\uC900\uC2DC", "PMT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"\uc6b0\ub8e8\uacfc\uc774 \uc2dc\uac04", "UYT",
                                                 "\uc6b0\ub8e8\uacfc\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "UYST",
                                                 "\uC6B0\uB8E8\uACFC\uC774 \uD45C\uC900\uC2DC", "UYT"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Nuuk", WGT},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"\uc218\ub9ac\ub0a8 \uc2dc\uac04", "SRT",
                                                 "\uc218\ub9ac\ub0a8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SRST",
                                                 "\uC218\uB9AC\uB0A8 \uD45C\uC900\uC2DC", "SRT"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", MST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"Davis \uc2dc\uac04", "DAVT",
                                               "Davis \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "DAVST",
                                               "\uB370\uC774\uBE44\uC2A4 \uD45C\uC900\uC2DC", "DAVT"}},
            {"Antarctica/DumontDUrville", new String[] {"\ub4a4\ubabd \ub4a4\ub974\ube4c \uc2dc\uac04", "DDUT",
                                                        "\ub4a4\ubabd \ub4a4\ub974\ube4c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "DDUST",
                                                        "\uB450\uBAAC\uD2B8\uC6B0\uB974\uBE4C \uD45C\uC900\uC2DC", "DDUT"}},
            {"Antarctica/Macquarie", new String[] {"Australian Eastern Standard Time (Macquarie)", "AEST",
                                                   "Australian Eastern Daylight Time (Macquarie)", "AEDT",
                                                   "Australian Eastern Time (Macquarie)", "AET"}},
            {"Antarctica/Mawson", new String[] {"\ubaa8\uc2a8 \uc2dc\uac04", "MAWT",
                                                "\ubaa8\uc2a8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MAWST",
                                                "\uB9C8\uC2A8 \uD45C\uC900\uC2DC", "MAWT"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"\ub85c\uc81c\ub77c \ud45c\uc900\uc2dc", "ROTT",
                                                 "\ub85c\uc81c\ub77c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ROTST",
                                                 "\uB85C\uB354\uB77C \uD45C\uC900\uC2DC", "ROTT"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa \uc2dc\uac04", "SYOT",
                                               "Syowa \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SYOST",
                                               "\uC1FC\uC640 \uD45C\uC900\uC2DC", "SYOT"}},
            {"Antarctica/Troll", new String[] {"\uc138\uacc4 \ud45c\uc900\uc2dc", "UTC",
                                               "\uc911\uc559 \uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CEST",
                                               "Troll Time", "ATT"}},
            {"Antarctica/Vostok", new String[] {"Vostok \uc2dc\uac04", "VOST",
                                                "Vostok \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VOSST",
                                                "\uBCF4\uC2A4\uD1A1 \uD45C\uC900\uC2DC", "VOST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"\uc54c\ub9c8\uc544\ud0c0 \uc2dc\uac04", "ALMT",
                                          "\uc54c\ub9c8\uc544\ud0c0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ALMST",
                                          "\uC54C\uB9C8\uC544\uD0C0 \uD45C\uC900\uC2DC", "ALMT"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"\uc544\ub098\ub514\ub974 \uc2dc\uac04", "ANAT",
                                          "\uc544\ub098\ub514\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ANAST",
                                          "\uC544\uB098\uB514\uB9AC \uD45C\uC900\uC2DC", "ANAT"}},
            {"Asia/Aqtau", new String[] {"\uc545\ud0c0\uc6b0 \uc2dc\uac04", "AQTT",
                                         "\uc545\ud0c0\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AQTST",
                                         "\uC544\uD06C\uD0C0\uC6B0 \uD45C\uC900\uC2DC", "AQTT"}},
            {"Asia/Aqtobe", new String[] {"\uc545\ud1a0\ube0c \uc2dc\uac04", "AQTT",
                                          "\uc545\ud1a0\ube0c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AQTST",
                                          "\uC544\uD06C\uD1A0\uBCA0 \uD45C\uC900\uC2DC", "AQTT"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"\uc544\uc81c\ub974\ubc14\uc774\uc794 \uc2dc\uac04", "AZT",
                                        "\uc544\uc81c\ub974\ubc14\uc774\uc794 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AZST",
                                        "\uC544\uC81C\uB974\uBC14\uC774\uC794 \uD45C\uC900\uC2DC", "AZT"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"\ud0a4\ub974\ud0a4\uc988\uc2a4\ud0c4 \uc2dc\uac04", "KGT",
                                           "\ud0a4\ub974\uae30\uc988\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KGST",
                                           "\uD0A4\uB974\uAE30\uC2A4\uC2A4\uD0C4 \uD45C\uC900\uC2DC", "KGT"}},
            {"Asia/Brunei", new String[] {"\ube0c\ub8e8\ub098\uc774 \uc2dc\uac04", "BNT",
                                          "\ube0c\ub8e8\ub098\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BNST",
                                          "\uBE0C\uB8E8\uB098\uC774 \uD45C\uC900\uC2DC", "BNT"}},
            {"Asia/Calcutta", IST},
            {"Asia/Chita", YAKT},
            {"Asia/Choibalsan", new String[] {"Choibalsan \uc2dc\uac04", "CHOT",
                                              "Choibalsan \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CHOST",
                                              "\uCD08\uC774\uBC1C\uC0B0 \uD45C\uC900\uC2DC", "CHOT"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"\ud2f0\ubaa8\ub974-\ub808\uc2a4\ud14c \uc2dc\uac04", "TLT",
                                        "\ud2f0\ubaa8\ub974-\ub808\uc2a4\ud14c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TLST",
                                        "\uB3D9\uD2F0\uBAA8\uB974 \uD45C\uC900\uC2DC", "TLT"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \uc2dc\uac04", "TJT",
                                            "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TJST",
                                            "\uD0C0\uC9C0\uD0A4\uC2A4\uD0C4 \uD45C\uC900\uC2DC", "TJT"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Hovd \uc2dc\uac04", "HOVT",
                                        "Hovd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "HOVST",
                                        "\uD638\uBE0C\uB4DC \uD45C\uC900\uC2DC", "HOVT"}},
            {"Asia/Irkutsk", IRKT},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\ub3d9\ubd80 \uc778\ub3c4\ub124\uc2dc\uc544 \uc2dc\uac04", "WIT",
                                            "\ub3d9\ubd80 \uc778\ub3c4\ub124\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EIST",
                                            "\uB3D9\uBD80 \uC778\uB3C4\uB124\uC2DC\uC544 \uD45C\uC900\uC2DC", "WIT"}},
            {"Asia/Kabul", new String[] {"\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4 \uc2dc\uac04", "AFT",
                                         "\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AFST",
                                         "\uC544\uD504\uAC00\uB2C8\uC2A4\uD0C4 \uD45C\uC900\uC2DC", "AFT"}},
            {"Asia/Kamchatka", new String[] {"\ud398\ud2b8\ub85c\ud30c\ube14\ub85c\ud504\uc2a4\ud06c-\uce84\ucc28\uce20\ud0a4 \uc2dc\uac04", "PETT",
                                            "\ud398\ud2b8\ub85c\ud30c\ube14\ub85c\ud504\uc2a4\ud06c-\uce84\ucc28\uce20\ud0a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PETST",
                                            "\uD398\uD2B8\uB85C\uD30C\uBE0C\uB85C\uD504\uC2A4\uD06C-\uCE84\uCC28\uCE20\uD0A4 \uD45C\uC900\uC2DC", "PETT"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", XJT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", YAKT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", KRAT},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"\ub9c8\uac00\ub2e8 \uc2dc\uac04", "MAGT",
                                           "\ub9c8\uac00\ub2e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MAGST",
                                           "\uB9C8\uAC00\uB2E8 \uD45C\uC900\uC2DC", "MAGT"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Philippines Standard Time", "PST",
                                          "Philippines Daylight Time", "PDT",
                                          "Philippines Time", "PT"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", KRAT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral \ud45c\uc900\uc2dc", "ORAT",
                                        "Oral \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ORAST",
                                        "\uC624\uB7F4 \uD45C\uC900\uC2DC", "ORAT"}},
            {"Asia/Omsk", new String[] {"Omsk \uc2dc\uac04", "OMST",
                                        "Omsk \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "OMSST",
                                        "\uC634\uC2A4\uD06C \uD45C\uC900\uC2DC", "OMST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda \ud45c\uc900\uc2dc", "QYZT",
                                             "Qyzylorda \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "QYZST",
                                             "\uD0A4\uC9C8\uB85C\uB974\uB2E4 \uD45C\uC900\uC2DC", "QYZT"}},
            {"Asia/Rangoon", MMT},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"\uc0ac\ud560\ub9b0 \uc2dc\uac04", "SAKT",
                                            "\uc0ac\ud560\ub9b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SAKST",
                                            "\uC0AC\uD560\uB9B0 \uD45C\uC900\uC2DC", "SAKT"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Srednekolymsk", new String[] {"Srednekolymsk Time", "SRET",
                                                 "Srednekolymsk Daylight Time", "SREDT",
                                                 "Srednekolymsk Time", "SRET"}},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"\uadf8\ub8e8\uc9c0\uc57c \uc2dc\uac04", "GET",
                                          "\uadf8\ub8e8\uc9c0\uc57c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GEST",
                                          "\uADF8\uB8E8\uC9C0\uC57C \uD45C\uC900\uC2DC", "GET"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", XJT},
            {"Asia/Ust-Nera", new String[] {"\uC6B0\uC2A4\uD2F0\uB124\uB77C \uD45C\uC900\uC2DC", "VLAT",
                                            "\uC6B0\uC2A4\uD2F0\uB124\uB77C \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "VLAST" ,
                                            "\uC6B0\uC2A4\uD2F0\uB124\uB77C \uD45C\uC900\uC2DC", "VLAT"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a1 \uc2dc\uac04", "VLAT",
                                               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a1 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VLAST",
                                               "\uBE14\uB77C\uB514\uBCF4\uC2A4\uD1A1 \uD45C\uC900\uC2DC", "VLAT"}},
            {"Asia/Yakutsk", YAKT},
            {"Asia/Yangon", MMT},
            {"Asia/Yekaterinburg", new String[] {"\uc608\uce74\ud14c\ub9b0\ubc84\uadf8 \uc2dc\uac04", "YEKT",
                                                 "\uc608\uce74\ud14c\ub9b0\ubc84\uadf8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "YEKST",
                                                 "\uC608\uCE74\uD14C\uB9B0\uBD80\uB974\uD06C \uD45C\uC900\uC2DC", "YEKT"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"\uc544\uc870\ub808\uc2a4 \uc2dc\uac04", "AZOT",
                                              "\uc544\uc870\ub808\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AZOST",
                                              "\uC544\uC870\uB808\uC2A4 \uD45C\uC900\uC2DC", "AZOT"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"\uae4c\ubf40\ubca0\ub974\ub370 \uc2dc\uac04", "CVT",
                                                  "\uae4c\ubf40\ubca0\ub974\ub370 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CVST",
                                                  "\uCF00\uC774\uD504\uBCA0\uB974\uB370 \uD45C\uC900\uC2DC", "CVT"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \ud45c\uc900\uc2dc", "GST",
                                                     "\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GDT",
                                                     "\uC0AC\uC6B0\uC2A4\uC870\uC9C0\uC544 \uD45C\uC900\uC2DC", "GT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"\ud3ec\ud074\ub79c\ub4dc \uad70\ub3c4 \uc2dc\uac04", "FKT",
                                               "\ud3ec\ud074\ub79c\ub4dc \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "FKST",
                                               "\uD3EC\uD074\uB79C\uB4DC \uC81C\uB3C4 \uD45C\uC900\uC2DC", "FKT"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"\uC911\uC559 \uC11C\uBD80 \uD45C\uC900\uC2DC(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACWST",
                                              "\uC911\uC559 \uC11C\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACWDT",
                                              "\uC911\uC559 \uC11C\uBD80 \uD45C\uC900\uC2DC(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACWT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", MST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", MSK},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"\uc0ac\ub9c8\ub77c \uc2dc\uac04", "SAMT",
                                            "\uc0ac\ub9c8\ub77c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SAMST",
                                            "\uC0AC\uB9C8\uB77C \uD45C\uC900\uC2DC", "SAMT"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", MSK},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"\uc601\uc778\ub3c4 \uc81c\ub3c4 \uc2dc\uac04", "IOT",
                                            "\uc601\uc778\ub3c4 \uc81c\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IOST",
                                            "\uC778\uB3C4\uC591 \uC2DD\uBBFC\uC9C0 \uD45C\uC900\uC2DC", "IOT"}},
            {"Indian/Christmas", new String[] {"\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c \uc2dc\uac04", "CXT",
                                               "\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CXST",
                                               "\uD06C\uB9AC\uC2A4\uB9C8\uC2A4 \uC12C \uD45C\uC900\uC2DC", "CIT"}},
            {"Indian/Cocos", new String[] {"\ucf54\ucf54\uc2a4 \uad70\ub3c4 \uc2dc\uac04", "CCT",
                                           "\ucf54\ucf54\uc2a4 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CCST",
                                           "\uCF54\uCF54\uC2A4 \uC81C\uB3C4 \uD45C\uC900\uC2DC", "CCT"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29 \ubc0f \ub0a8\uadf9 \uc9c0\uc5ed \uc2dc\uac04", "TFT",
                                               "\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29 \ubc0f \ub0a8\uadf9 \uc9c0\uc5ed \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TFST",
                                               "\uD504\uB791\uC2A4\uB839 \uB0A8\uBD80 \uBC0F \uB0A8\uADF9 \uB300\uB959 \uD45C\uC900\uC2DC", "TFT"}},
            {"Indian/Mahe", new String[] {"\uc138\uc774\uc140 \uc2dc\uac04", "SCT",
                                          "\uc138\uc774\uc258 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SCST",
                                          "\uC138\uC774\uC178 \uD45C\uC900\uC2DC", "SCT"}},
            {"Indian/Maldives", new String[] {"\ubab0\ub514\ube0c \uc2dc\uac04", "MVT",
                                              "\ubab0\ub514\ube0c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MVST",
                                              "\uBAB0\uB514\uBE0C \uD45C\uC900\uC2DC", "MVT"}},
            {"Indian/Mauritius", new String[] {"\ubaa8\ub9ac\uc154\uc2a4 \uc2dc\uac04", "MUT",
                                               "\ubaa8\ub9ac\uc154\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MUST",
                                               "\uBAA8\uB9AC\uC154\uC2A4 \uD45C\uC900\uC2DC", "MUT"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"\ub9ac\uc720\ub2c8\uc5b8 \uc2dc\uac04", "RET",
                                             "\ub9ac\uc720\ub2c8\uc5b8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "REST",
                                             "\uB808\uC704\uB2C8\uC639 \uD45C\uC900\uC2DC", "RET"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"\uc911\ubd80 \uc720\ub7fd \uc2dc\uac04", "MET",
                                  "\uc911\ubd80 \uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MEST",
                                  "MET", "MET"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Bougainville", new String[] {"Bougainville Standard Time", "BST",
                                                   "Bougainville Daylight Time", "BST",
                                                   "Bougainville Time", "BT"}},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"\ube44\ub204\uc544\ud22c \uc2dc\uac04", "VUT",
                                            "\ubc14\ub204\uc544\ud22c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VUST",
                                            "\uBC14\uB204\uC544\uD22C \uD45C\uC900\uC2DC", "VUT"}},
            {"Pacific/Enderbury", new String[] {"\ud53c\ub2c9\uc2a4 \uad70\ub3c4 \uc2dc\uac04", "PHOT",
                                                "\ud53c\ub2c9\uc2a4 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PHOST",
                                                "\uD53C\uB2C9\uC2A4 \uC81C\uB3C4 \uD45C\uC900\uC2DC", "PHOT"}},
            {"Pacific/Fakaofo", new String[] {"\ud1a0\ucf08\ub77c\uc6b0 \uc2dc\uac04", "TKT",
                                              "\ud1a0\ucf08\ub77c\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TKST",
                                              "\uD1A0\uCF08\uB77C\uC6B0 \uD45C\uC900\uC2DC", "TKT"}},
            {"Pacific/Fiji", new String[] {"\ud53c\uc9c0 \uc2dc\uac04", "FJT",
                                          "\ud53c\uc9c0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "FJST",
                                          "\uD53C\uC9C0 \uD45C\uC900\uC2DC", "FJT"}},
            {"Pacific/Funafuti", new String[] {"\ud22c\ubc1c\ub8e8 \uc2dc\uac04", "TVT",
                                             "\ud22c\ubc1c\ub8e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TVST",
                                             "\uD22C\uBC1C\uB8E8 \uD45C\uC900\uC2DC", "TVT"}},
            {"Pacific/Galapagos", new String[] {"\uac08\ub77c\ud30c\uace0\uc2a4 \uc2dc\uac04", "GALT",
                                                "\uac08\ub77c\ud30c\uace0\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GALST",
                                                "\uAC08\uB77C\uD30C\uACE0\uC2A4 \uD45C\uC900\uC2DC", "GALT"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"\ub77c\uc778 \uad70\ub3c4 \uc2dc\uac04", "LINT",
                                                 "\ub77c\uc778 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "LINST",
                                                 "\uB77C\uC778 \uC81C\uB3C4 \uD45C\uC900\uC2DC", "LINT"}},
            {"Pacific/Kosrae", new String[] {"\ucf54\uc2a4\ub798 \uc2dc\uac04", "KOST",
                                             "\ucf54\uc2a4\ub798 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KOSST",
                                             "\uCF54\uC2A4\uB808 \uD45C\uC900\uC2DC", "KOST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"\ub9c8\ub974\ucf00\uc0ac\uc2a4 \uc2dc\uac04", "MART",
                                                "\ub9c8\ub974\ucf00\uc0ac\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MARST",
                                                "\uB9C8\uD0A4\uC800\uC2A4 \uD45C\uC900\uC2DC", "MART"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"\ub098\uc6b0\ub8e8 \uc2dc\uac04", "NRT",
                                           "\ub098\uc6b0\ub8e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NRST",
                                           "\uB098\uC6B0\uB8E8 \uD45C\uC900\uC2DC", "NRT"}},
            {"Pacific/Niue", new String[] {"\ub2c8\uc6b0\uc5d0 \uc2dc\uac04", "NUT",
                                           "\ub2c8\uc6b0\uc5d0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NUST",
                                           "\uB2C8\uC6B0\uC5D0 \uD45C\uC900\uC2DC", "NUT"}},
            {"Pacific/Norfolk", new String[] {"\ub178\ud37d \uc2dc\uac04", "NFT",
                                              "\ub178\ud37d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NFST",
                                              "\uB178\uD37D \uD45C\uC900\uC2DC", "NFT"}},
            {"Pacific/Noumea", new String[] {"\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544 \uc2dc\uac04", "NCT",
                                             "\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NCST",
                                             "\uB274 \uCE7C\uB808\uB3C4\uB2C8\uC544 \uD45C\uC900\uC2DC", "NCT"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"\ud314\ub77c\uc6b0 \uc2dc\uac04", "PWT",
                                            "\ud314\ub77c\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PWST",
                                            "\uD314\uB77C\uC6B0 \uD45C\uC900\uC2DC", "PWT"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"\ud30c\ud478\uc544\ub274\uae30\ub2c8 \uc2dc\uac04", "PGT",
                                                  "\ud30c\ud478\uc544\ub274\uae30\ub2c8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PGST",
                                                  "\uD30C\uD478\uC544 \uB274\uAE30\uB2C8\uC544 \uD45C\uC900\uC2DC", "PGT"}},
            {"Pacific/Rarotonga", new String[] {"\ucfe0\ud06c \uad70\ub3c4 \uc2dc\uac04", "CKT",
                                                "\ucfe0\ud06c \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CKHST",
                                                "\uCFE1 \uC81C\uB3C4 \uD45C\uC900\uC2DC", "CKT"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"\ud0c0\ud788\ud2f0 \uc2dc\uac04", "TAHT",
                                             "\ud0c0\ud788\ud2f0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TAHST",
                                             "\uD0C0\uD788\uD2F0 \uD45C\uC900\uC2DC", "TAHT"}},
            {"Pacific/Tarawa", new String[] {"\uae38\ubc84\ud2b8 \uad70\ub3c4 \uc2dc\uac04", "GILT",
                                             "\uae38\ubc84\ud2b8 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GILST",
                                             "\uAE38\uBC84\uD2B8 \uC81C\uB3C4 \uD45C\uC900\uC2DC", "GILT"}},
            {"Pacific/Tongatapu", new String[] {"\ud1b5\uac00 \uc2dc\uac04", "TOT",
                                                "\ud1b5\uac00 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TOST",
                                                "\uD1B5\uAC00 \uD45C\uC900\uC2DC", "TOT"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"\uc6e8\uc774\ud06c \uc2dc\uac04", "WAKT",
                                           "\uc6e8\uc774\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WAKST",
                                           "\uC6E8\uC774\uD06C \uD45C\uC900\uC2DC", "WAKT"}},
            {"Pacific/Wallis", new String[] {"\uc6d4\ub9ac\uc2a4 \ud6c4\ud22c\ub098 \uc2dc\uac04", "WFT",
                                             "\uc6d4\ub9ac\uc2a4 \ud6c4\ud2b8\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WFST",
                                             "\uC6D4\uB9AC\uC2A4 \uD478\uD22C\uB098 \uD45C\uC900\uC2DC", "WFT"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Samoa", SAMOA},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
