/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.nio.ByteOrder;

public class DataEncoding
implements Cloneable,
SerializationInterface {
    protected long id;
    protected DataMode mode;
    protected PeakEncoding peakEncoding;
    protected String compression;
    protected ByteOrder byteOrder;
    protected int peakStructSize;

    public DataEncoding(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public DataEncoding(long id, DataMode mode, PeakEncoding peakEncoding, String compression, ByteOrder byteOrder) {
        this.id = id;
        this.mode = mode;
        this.peakEncoding = peakEncoding;
        this.compression = compression;
        this.byteOrder = byteOrder;
        int peakBytesSize = this.getPeakEncoding().getValue();
        if (this.getMode() == DataMode.FITTED) {
            peakBytesSize += 8;
        }
        this.peakStructSize = peakBytesSize;
    }

    public long getId() {
        return this.id;
    }

    public DataMode getMode() {
        return this.mode;
    }

    public PeakEncoding getPeakEncoding() {
        return this.peakEncoding;
    }

    public void setPeakEncoding(PeakEncoding p) {
        this.peakEncoding = p;
    }

    public String getCompression() {
        return this.compression;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getPeakStructSize() {
        return this.peakStructSize;
    }

    public DataEncoding clone() {
        return new DataEncoding(this.id, this.mode, this.peakEncoding, this.compression, this.byteOrder);
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        writer.writeInt64(this.id);
        boolean hasData = this.mode != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.mode.write(writer);
        }
        hasData = this.peakEncoding != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.peakEncoding.write(writer);
        }
        hasData = this.compression != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeString(this.compression);
        }
        hasData = this.byteOrder != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            writer.writeString(this.byteOrder.toString());
        }
        writer.writeInt32(this.peakStructSize);
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        String byteOrderString;
        this.id = reader.readInt64();
        boolean hasData = reader.readBoolean();
        this.mode = hasData ? DataMode.getEnum(reader) : null;
        hasData = reader.readBoolean();
        this.peakEncoding = hasData ? PeakEncoding.getEnum(reader) : null;
        hasData = reader.readBoolean();
        this.compression = hasData ? reader.readString() : null;
        hasData = reader.readBoolean();
        this.byteOrder = hasData ? ((byteOrderString = reader.readString()).equals(ByteOrder.BIG_ENDIAN.toString()) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN) : null;
        this.peakStructSize = reader.readInt32();
    }
}

