/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayHolder
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayHolder(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
        this.count = 0;
    }

    public ByteArrayHolder() {
        this(32);
    }

    public ByteArrayHolder(byte[] underlyingBuf) {
        this.buf = underlyingBuf;
        this.count = underlyingBuf.length - 1;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private void grow(int minCapacity, boolean keepData) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError("Not enought memory to extend a ByteArrayHolder");
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = keepData ? Arrays.copyOf(this.buf, newCapacity) : new byte[newCapacity];
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        return new String(this.buf, 0, this.count);
    }

    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Deprecated
    public synchronized String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.size());
    }

    public byte[] getUnderlyingBytes() {
        return this.buf;
    }

    public final int getCapacity() {
        return this.buf.length;
    }

    public final int getCapacityLeft() {
        return this.buf.length - this.count;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    public void ensureCapacity(int minCapacity, boolean keepData) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity, keepData);
        }
        if (!keepData) {
            this.reset();
        }
    }

    public void ensureHasSpace(int numBytesToAdd) {
        if (numBytesToAdd < 0) {
            throw new IllegalArgumentException("Number of bytes can't be negative");
        }
        int capacityLeft = this.getCapacityLeft();
        if (capacityLeft < numBytesToAdd) {
            this.grow(numBytesToAdd - capacityLeft, true);
        }
    }

    public final int getPosition() {
        return this.size();
    }

    public final void setPosition(int newPos) {
        if (newPos > this.getCapacity()) {
            throw new IndexOutOfBoundsException("New position can't be greater than the capacity");
        }
        if (newPos < 0) {
            throw new IndexOutOfBoundsException("New position can't be less than zero");
        }
        this.count = newPos;
    }

    public final void clear() {
        Arrays.fill(this.buf, (byte)0);
        this.setPosition(0);
    }
}

