/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.msi.Ptm;
import fr.proline.core.orm.msi.PtmClassification;
import fr.proline.core.orm.msi.PtmEvidence;
import fr.proline.core.orm.msi.UsedPtm;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity(name="fr.proline.core.orm.msi.PtmSpecificity")
@NamedQueries(value={@NamedQuery(name="findMsiPtmSpecForNameLocResidue", query="select ps from fr.proline.core.orm.msi.PtmSpecificity ps where (upper(ps.location) = :location) and (ps.residue = :residue) and (upper(ps.ptm.shortName) = :ptmShortName)"), @NamedQuery(name="findMsiPtmSpecForNameAndLoc", query="select ps from fr.proline.core.orm.msi.PtmSpecificity ps where (upper(ps.location) = :location) and (ps.residue is null) and (upper(ps.ptm.shortName) = :ptmShortName)")})
@Table(name="ptm_specificity")
public class PtmSpecificity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private long id;
    private String location;
    private Character residue;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @ManyToOne
    @JoinColumn(name="ptm_id")
    private Ptm ptm;
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="classification_id")
    private PtmClassification classification;
    @OneToMany(mappedBy="specificity", cascade={CascadeType.PERSIST})
    private Set<PtmEvidence> evidences;
    @OneToMany(mappedBy="ptmSpecificity")
    private Set<UsedPtm> usedPtms;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Character getResidue() {
        return this.residue;
    }

    public void setResidue(Character pResidue) {
        this.residue = pResidue;
    }

    public Ptm getPtm() {
        return this.ptm;
    }

    public void setPtm(Ptm ptm) {
        this.ptm = ptm;
    }

    public PtmClassification getClassification() {
        return this.classification;
    }

    public void setClassification(PtmClassification classification) {
        this.classification = classification;
    }

    public void setEvidences(Set<PtmEvidence> pEvidences) {
        this.evidences = pEvidences;
    }

    public Set<PtmEvidence> getEvidences() {
        return this.evidences;
    }

    public void addEvidence(PtmEvidence evidence) {
        if (evidence != null) {
            Set<PtmEvidence> localEvidences = this.getEvidences();
            if (localEvidences == null) {
                localEvidences = new HashSet<PtmEvidence>();
                this.setEvidences(localEvidences);
            }
            localEvidences.add(evidence);
        }
    }

    public void removeEvidence(PtmEvidence evidence) {
        Set<PtmEvidence> localEvidences = this.getEvidences();
        if (localEvidences != null) {
            localEvidences.remove(evidence);
        }
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public Set<UsedPtm> getUsedPtms() {
        return this.usedPtms;
    }

    public void setUsedPtms(Set<UsedPtm> pUsedPtms) {
        this.usedPtms = pUsedPtms;
    }

    public void addUsedPtm(UsedPtm usedPtm) {
        if (usedPtm != null) {
            Set<UsedPtm> localUsedPtms = this.getUsedPtms();
            if (localUsedPtms == null) {
                localUsedPtms = new HashSet<UsedPtm>();
                this.setUsedPtms(localUsedPtms);
            }
            localUsedPtms.add(usedPtm);
        }
    }

    public void removeUsedPtms(UsedPtm usedPtm) {
        Set<UsedPtm> localUsedPtms = this.getUsedPtms();
        if (localUsedPtms != null) {
            localUsedPtms.remove(usedPtm);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.ptm.getShortName());
        if (!PtmLocation.withName(this.location).equals((Object)PtmLocation.ANYWHERE)) {
            sb.append(" (").append(this.location).append(")");
        }
        if (this.residue != null && this.residue.charValue() != '\u0000') {
            sb.append(" (").append(this.residue).append(")");
        }
        return sb.toString();
    }

    public static final class PtmLocation
    extends Enum<PtmLocation> {
        public static final /* enum */ PtmLocation ANYWHERE = new PtmLocation("Anywhere");
        public static final /* enum */ PtmLocation ANY_N_TERM = new PtmLocation("Any N-term");
        public static final /* enum */ PtmLocation ANY_C_TERM = new PtmLocation("Any C-term");
        public static final /* enum */ PtmLocation PROT_N_TERM = new PtmLocation("Protein N-term");
        public static final /* enum */ PtmLocation PROT_C_TERM = new PtmLocation("Protein C-term");
        private final String m_location;
        private static HashMap<String, PtmLocation> ptmLocationByLocation;
        private static final /* synthetic */ PtmLocation[] $VALUES;

        public static PtmLocation[] values() {
            return (PtmLocation[])$VALUES.clone();
        }

        public static PtmLocation valueOf(String name) {
            return Enum.valueOf(PtmLocation.class, name);
        }

        private PtmLocation(String location) {
            assert (!StringUtils.isEmpty((String)location)) : "PtmSpecificity.Location() invalid location";
            this.m_location = location;
        }

        public static PtmLocation withName(String location) {
            if (ptmLocationByLocation == null) {
                ptmLocationByLocation = new HashMap();
                for (PtmLocation ptmLoc : PtmLocation.values()) {
                    ptmLocationByLocation.put(ptmLoc.toString(), ptmLoc);
                }
            }
            return ptmLocationByLocation.get(location);
        }

        public String toString() {
            return this.m_location;
        }

        private static /* synthetic */ PtmLocation[] $values() {
            return new PtmLocation[]{ANYWHERE, ANY_N_TERM, ANY_C_TERM, PROT_N_TERM, PROT_C_TERM};
        }

        static {
            $VALUES = PtmLocation.$values();
            ptmLocationByLocation = null;
        }
    }
}

